/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.ExpiringCache;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

class ExpiringCache {
    private long millisUntilExpiration;
    private Map<String, Entry> map;
    private int queryCount;
    private int queryOverflow = 300;
    private int MAX_ENTRIES = 200;

    ExpiringCache() {
        this(30000L);
    }

    ExpiringCache(long l) {
        this.millisUntilExpiration = l;
        this.map = new LinkedHashMap<String, Entry>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Entry> entry) {
                return this.size() > ExpiringCache.this.MAX_ENTRIES;
            }
        };
    }

    synchronized String get(String string) {
        Entry entry;
        if (++this.queryCount >= this.queryOverflow) {
            this.cleanup();
        }
        if ((entry = this.entryFor(string)) != null) {
            return entry.val();
        }
        return null;
    }

    synchronized void put(String string, String string2) {
        Entry entry;
        if (++this.queryCount >= this.queryOverflow) {
            this.cleanup();
        }
        if ((entry = this.entryFor(string)) != null) {
            entry.setTimestamp(System.currentTimeMillis());
            entry.setVal(string2);
        } else {
            this.map.put(string, new Entry(System.currentTimeMillis(), string2));
        }
    }

    synchronized void clear() {
        this.map.clear();
    }

    private Entry entryFor(String string) {
        long l;
        Entry entry = this.map.get(string);
        if (entry != null && ((l = System.currentTimeMillis() - entry.timestamp()) < 0L || l >= this.millisUntilExpiration)) {
            this.map.remove(string);
            entry = null;
        }
        return entry;
    }

    private void cleanup() {
        Set<String> set = this.map.keySet();
        String[] stringArray = new String[set.size()];
        int n = 0;
        for (String string : set) {
            stringArray[n++] = string;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.entryFor(stringArray[i]);
        }
        this.queryCount = 0;
    }
}

