/*
 * Decompiled with CFR 0.152.
 */
package io.vlinx.service.creator;

import io.vlinx.logging.Logger;
import io.vlinx.processutils.ProcessUtils;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a!\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\u0002\u0010\u0005\u001a\u0019\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"getExecutableCommand", "", "exePath", "arguments", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "main", "", "args", "([Ljava/lang/String;)V", "linux-service-creator"})
public final class MainKt {
    public static final void main(@NotNull String[] args2) {
        Intrinsics.checkNotNullParameter(args2, "args");
        if (args2.length < 2) {
            System.err.println("Usage: service-creator <service-name> <exe-file-path> [<arguments>]");
            int n = 1;
            boolean bl = false;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        String serviceName = args2[0];
        Path exePath = Paths.get(args2[1], new String[0]).toAbsolutePath();
        Path workingDir = exePath.getParent();
        String[] arguments = ArraysKt.sliceArray(args2, new IntRange(2, args2.length));
        Logger.INFO("Service name", serviceName);
        Logger.INFO("Executable file path", exePath);
        String serviceContent = StringsKt.trimIndent("\n            [Unit]\n            Description=\"Linux service created by Protector4J\"\n            After=syslog.target\n            \n            [Service]\n            WorkingDirectory=" + workingDir + "\n            ExecStart=" + MainKt.getExecutableCommand(((Object)exePath).toString(), arguments) + "\n            \n            [Install]\n            WantedBy=multi-user.target\n        ");
        Path serviceFilePath = Paths.get(Intrinsics.stringPlus(serviceName, ".service"), new String[0]);
        Files.writeString(serviceFilePath, (CharSequence)serviceContent, new OpenOption[0]);
        String[] stringArray = new String[]{Intrinsics.stringPlus(serviceName, ".service")};
        Path targetServiceFilePath = Paths.get("/etc/systemd/system", stringArray);
        Logger.INFO("Copy " + serviceFilePath + " to " + targetServiceFilePath);
        Files.copy(serviceFilePath, targetServiceFilePath, new CopyOption[0]);
        Files.deleteIfExists(serviceFilePath);
        String command = "systemctl daemon-reload";
        Logger.INFO(command);
        ProcessUtils.run(command, true);
        command = Intrinsics.stringPlus("systemctl start ", serviceName);
        ProcessUtils.run(command, true);
        command = Intrinsics.stringPlus("systemctl enable ", serviceName);
        ProcessUtils.run(command, true);
        command = Intrinsics.stringPlus("systemctl status ", serviceName);
        ProcessUtils.run(command, true);
    }

    @NotNull
    public static final String getExecutableCommand(@NotNull String exePath, @NotNull String[] arguments) {
        Intrinsics.checkNotNullParameter(exePath, "exePath");
        Intrinsics.checkNotNullParameter(arguments, "arguments");
        StringBuilder argsBuilder = new StringBuilder();
        String[] $this$forEach$iv = arguments;
        boolean $i$f$forEach = false;
        String[] stringArray = $this$forEach$iv;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String it = element$iv = stringArray[i];
            boolean bl = false;
            argsBuilder.append(Intrinsics.stringPlus(it, " "));
        }
        String string = exePath + ' ' + argsBuilder;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string2)).toString();
    }
}

