/*
 * Decompiled with CFR 0.152.
 */
package io.vlinx.javax;

import io.vlinx.utils.StringUtil;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public class ResourceUtils {
    public static String getResourcePath(String relativePath) throws Exception {
        if (StringUtil.isEmpty(relativePath)) {
            throw new Exception("Invalid relativePath");
        }
        String path = ResourceUtils.getBasePath() + File.separator + relativePath;
        if (new File(path).exists()) {
            return new File(path).getAbsolutePath();
        }
        return new File(path).getAbsolutePath();
    }

    public static String getBasePath() throws UnsupportedEncodingException {
        String path = ResourceUtils.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        File file = new File(path = URLDecoder.decode(path, "UTF-8"));
        if (file.isDirectory()) {
            return file.getAbsolutePath();
        }
        return file.getParentFile().getAbsolutePath();
    }
}

