/*
 * Decompiled with CFR 0.152.
 */
package io.vlinx.utils;

import io.vlinx.utils.StringUtil;
import io.vlinx.utils.SystemInfo;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.CRC32;

public class FileUtil {
    public static boolean mkdirs(String dirPath) {
        File file = new File(dirPath);
        return file.mkdirs();
    }

    public static List<String> readFileToLines(String filePath) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        File file = new File(filePath);
        BufferedReader input = new BufferedReader(new FileReader(file));
        String text = "";
        while ((text = input.readLine()) != null) {
            lines.add(text);
        }
        return lines;
    }

    public static String readFile(String filePath) throws IOException {
        String content = "";
        File file = new File(filePath);
        BufferedReader input = new BufferedReader(new FileReader(file));
        StringBuffer buffer = new StringBuffer();
        String text = "";
        while ((text = input.readLine()) != null) {
            buffer.append(text + "\n");
        }
        content = buffer.toString();
        return content;
    }

    public static void saveFile(String content, String filePath) throws IOException {
        FileUtil.saveFile(content, filePath, true);
    }

    public static void saveFile(String content, String filePath, boolean override) throws IOException {
        File file = new File(filePath);
        if (!override && file.exists()) {
            throw new IOException(filePath + "(exists)");
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        writer.write(content, 0, content.length());
        writer.close();
    }

    public static void appendFile(String content, String filePath) throws IOException {
        File file = new File(filePath);
        if (!file.exists()) {
            file.createNewFile();
        }
        content = content + "\n";
        BufferedWriter writer = new BufferedWriter(new FileWriter(file, true));
        writer.write(content, 0, content.length());
        writer.close();
    }

    public static String getBaseNameFromPath(String filePath) {
        File file = new File(filePath);
        String fileName = "";
        if (file.exists()) {
            fileName = file.getName();
            fileName = FileUtil.getBaseName(fileName);
        }
        return fileName;
    }

    public static String getExtensionFromPath(String filePath) {
        File file = new File(filePath);
        String fileName = file.getName();
        String ext = FileUtil.getExtension(fileName);
        if (ext == null) {
            ext = "";
        }
        return ext;
    }

    public static String getBaseName(String fileName) {
        int dot;
        if (fileName != null && fileName.length() > 0 && (dot = fileName.lastIndexOf(46)) > -1 && dot < fileName.length()) {
            return fileName.substring(0, dot);
        }
        return fileName;
    }

    public static String getExtension(String fileName) {
        int dot;
        if (fileName != null && fileName.length() > 0 && (dot = fileName.lastIndexOf(46)) > -1 && dot < fileName.length() - 1) {
            return fileName.substring(dot + 1);
        }
        return fileName;
    }

    public static String getName(String path) {
        File file = new File(path);
        return file.getName();
    }

    public static String getParent(String path) {
        File file = new File(path);
        return file.getParent();
    }

    public static boolean samePath(String path1, String path2) throws IOException {
        if (StringUtil.isEmpty(path1) || StringUtil.isEmpty(path2)) {
            return false;
        }
        File f1 = new File(path1);
        File f2 = new File(path2);
        return f1.getCanonicalPath().equals(f2.getCanonicalPath());
    }

    public static boolean isExist(String path) {
        return new File(path).exists();
    }

    public static boolean isDirectory(String path) {
        return new File(path).isDirectory();
    }

    public static String getRelative(String base, String path) {
        String relative = new File(base).toURI().relativize(new File(path).toURI()).getPath();
        return relative;
    }

    public static File[] searchFile(File folder, final String keyWord) {
        File[] subFolders = folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() || pathname.isFile() && pathname.getName().toLowerCase().contains(keyWord.toLowerCase());
            }
        });
        ArrayList<File> result = new ArrayList<File>();
        for (int i = 0; i < subFolders.length; ++i) {
            if (subFolders[i].isFile()) {
                result.add(subFolders[i]);
                continue;
            }
            File[] foldResult = FileUtil.searchFile(subFolders[i], keyWord);
            for (int j = 0; j < foldResult.length; ++j) {
                result.add(foldResult[j]);
            }
        }
        File[] files = new File[result.size()];
        result.toArray(files);
        return files;
    }

    public static long crc32(String filepath) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(filepath));){
            int c;
            CRC32 crc = new CRC32();
            while ((c = ((InputStream)in).read()) != -1) {
                crc.update(c);
            }
            long l = crc.getValue();
            return l;
        }
    }

    public static String getAbsolutePath(String path) {
        File file = new File(path);
        return file.getAbsolutePath();
    }

    public static boolean isValidPath(String path) {
        try {
            Paths.get(path, new String[0]);
        }
        catch (NullPointerException | InvalidPathException ex) {
            return false;
        }
        return true;
    }

    public static boolean isEmptyDir(String path) {
        File dir = new File(path);
        if (!dir.exists()) {
            return true;
        }
        if (dir.listFiles().length == 0) {
            return true;
        }
        File[] files = dir.listFiles();
        return SystemInfo.getPlatform().startsWith("mac") ? files.length == 1 && files[0].getName().toLowerCase().equals(".DS_Store") : (SystemInfo.getPlatform().startsWith("win") ? files.length == 1 && files[0].getName().toLowerCase().equals("thumbs.db") : SystemInfo.getPlatform().startsWith("linux") && files.length == 1 && files[0].getName().toLowerCase().equals("lost+found"));
    }
}

