/*
 * Decompiled with CFR 0.152.
 */
package io.vlinx.utils;

import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    public static Map<String, String> parametersToMap(String paramters) {
        String[] params;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (String param : params = paramters.split("&")) {
            String[] values = param.split("=");
            if (values.length < 2) continue;
            String key = values[0].trim();
            String value = values[1].trim();
            paramMap.put(key, value);
        }
        return paramMap;
    }

    public static String capitalize(String srcString) {
        StringBuilder sb = new StringBuilder();
        sb.append(Character.toUpperCase(srcString.charAt(0)));
        sb.append(srcString.substring(1));
        return sb.toString();
    }

    public static boolean isEmpty(String content) {
        return content == null || content.isEmpty();
    }

    public static String bytesToHex(byte[] buf) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buf.length; ++i) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }

    public static byte[] hextoBytes(String hexStr) throws Exception {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; ++i) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
        }
        return result;
    }

    public static String getResourceFromURL(String urlStr) {
        URL url;
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException e) {
            return "";
        }
        String file = url.getFile();
        String[] splitStr = file.split("/");
        int len = splitStr.length;
        String result = splitStr[len - 1];
        return result;
    }

    public static String removeComments(String code) {
        boolean outsideComment = false;
        boolean insideLineComment = true;
        int insideblockComment = 2;
        int insideblockComment_noNewLineYet = 3;
        int currentState = 0;
        String endResult = "";
        Scanner s = new Scanner(code);
        s.useDelimiter("");
        while (s.hasNext()) {
            String c = s.next();
            block0 : switch (currentState) {
                case 0: {
                    String c2;
                    if (c.equals("/") && s.hasNext()) {
                        c2 = s.next();
                        if (c2.equals("/")) {
                            currentState = 1;
                            break;
                        }
                        if (c2.equals("*")) {
                            currentState = 3;
                            break;
                        }
                        endResult = endResult + c + c2;
                        break;
                    }
                    endResult = endResult + c;
                    break;
                }
                case 1: {
                    if (!c.equals("\n")) break;
                    currentState = 0;
                    endResult = endResult + "\n";
                    break;
                }
                case 3: {
                    if (c.equals("\n")) {
                        endResult = endResult + "\n";
                        currentState = 2;
                    }
                }
                case 2: {
                    String c2;
                    while (c.equals("*") && s.hasNext()) {
                        c2 = s.next();
                        if (!c2.equals("/")) continue;
                        currentState = 0;
                        break block0;
                    }
                    break;
                }
            }
        }
        s.close();
        return endResult;
    }

    public static String getFileNameBaseOnURL(String url) {
        String fileName = url;
        fileName = fileName.replaceAll("http:", "");
        fileName = fileName.replaceAll("https:", "");
        fileName = fileName.replace("/", "");
        return fileName;
    }

    public static String getMD5(String content) {
        MessageDigest m = null;
        try {
            m = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return "";
        }
        m.reset();
        m.update(content.getBytes());
        byte[] digest = m.digest();
        BigInteger bigInt = new BigInteger(1, digest);
        String hashtext = bigInt.toString(16);
        while (hashtext.length() < 32) {
            hashtext = "0" + hashtext;
        }
        return hashtext;
    }

    public static String removeHTMLTag(String htmlStr) {
        String regEx_script = "<script[^>]*?>[\\s\\S]*?<\\/script>";
        String regEx_style = "<style[^>]*?>[\\s\\S]*?<\\/style>";
        String regEx_html = "<[^>]+>";
        Pattern p_script = Pattern.compile(regEx_script, 2);
        Matcher m_script = p_script.matcher(htmlStr);
        htmlStr = m_script.replaceAll("");
        Pattern p_style = Pattern.compile(regEx_style, 2);
        Matcher m_style = p_style.matcher(htmlStr);
        htmlStr = m_style.replaceAll("");
        Pattern p_html = Pattern.compile(regEx_html, 2);
        Matcher m_html = p_html.matcher(htmlStr);
        htmlStr = m_html.replaceAll("");
        return htmlStr.trim();
    }

    public static boolean isValidEmailAddress(String email) {
        Pattern emailPattern = Pattern.compile("\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*");
        Matcher matcher = emailPattern.matcher(email);
        return matcher.find();
    }

    public static boolean isValidUsername(String username) {
        Pattern usernamPattern = Pattern.compile("^[a-z0-9._-]{2,25}$");
        Matcher matcher = usernamPattern.matcher(username);
        return matcher.find();
    }

    public static boolean isValidMobilephoneNumber(String str) {
        Pattern p = null;
        Matcher m = null;
        boolean b = false;
        p = Pattern.compile("^[1][3,4,5,8][0-9]{9}$");
        m = p.matcher(str);
        b = m.matches();
        return b;
    }

    public static boolean isValidPhoneNumber(String str) {
        Pattern p1 = null;
        Pattern p2 = null;
        Matcher m = null;
        boolean b = false;
        p1 = Pattern.compile("^[0][1-9]{2,3}-[0-9]{5,10}$");
        p2 = Pattern.compile("^[1-9]{1}[0-9]{5,8}$");
        if (str.length() > 9) {
            m = p1.matcher(str);
            b = m.matches();
        } else {
            m = p2.matcher(str);
            b = m.matches();
        }
        return b;
    }

    public static String removeBlank(String str) {
        String dest = "";
        if (str != null) {
            Pattern p = Pattern.compile("\\s*|\t|\r|\n");
            Matcher m = p.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }

    public static boolean isWildcardMatch(String s, String p) {
        int i = 0;
        int j = 0;
        int starIndex = -1;
        int iIndex = -1;
        while (i < s.length()) {
            if (j < p.length() && (p.charAt(j) == '?' || p.charAt(j) == s.charAt(i))) {
                ++i;
                ++j;
                continue;
            }
            if (j < p.length() && p.charAt(j) == '*') {
                starIndex = j++;
                iIndex = i;
                continue;
            }
            if (starIndex != -1) {
                j = starIndex + 1;
                i = iIndex + 1;
                ++iIndex;
                continue;
            }
            return false;
        }
        while (j < p.length() && p.charAt(j) == '*') {
            ++j;
        }
        return j == p.length();
    }
}

