/*
 * Decompiled with CFR 0.152.
 */
package io.vlinx.utils;

public class SystemInfo {
    public String osName = "";
    public String osVersion = "";
    public String arch = "";
    public String username = "";
    public String javaVendor = "";
    public String javaVersion = "";

    public static String getOSName() {
        return System.getProperties().getProperty("os.name");
    }

    public static String getOSVersion() {
        return System.getProperties().getProperty("os.version");
    }

    public static String getOSArch() {
        return System.getProperties().getProperty("os.arch");
    }

    public static String getJavaVendor() {
        return System.getProperties().getProperty("java.vendor");
    }

    public static String getJavaVersion() {
        return System.getProperties().getProperty("java.version");
    }

    public static String getUsername() {
        return System.getProperties().getProperty("user.name");
    }

    public static String getPlatform() {
        String platform = "";
        String os = SystemInfo.getOSName().toLowerCase();
        String arch = SystemInfo.getOSArch().toLowerCase();
        if (os.startsWith("win")) {
            platform = "win";
        } else if (os.startsWith("linux")) {
            platform = "linux";
        } else if (os.startsWith("mac")) {
            platform = "mac";
        }
        if (!os.startsWith("mac") && (arch.toLowerCase().equals("x86") || arch.toLowerCase().equals("i386") || arch.toLowerCase().equals("i486") || arch.toLowerCase().equals("i586"))) {
            platform = platform + "32";
        }
        if (arch.equals("aarch64")) {
            platform = platform + "-aarch64";
        }
        return platform;
    }

    public static boolean isWindows() {
        return SystemInfo.getOSName().toLowerCase().indexOf("win") >= 0;
    }

    public static boolean isMac() {
        return SystemInfo.getOSName().toLowerCase().indexOf("mac") >= 0;
    }

    public static boolean isUnix() {
        return SystemInfo.getOSName().toLowerCase().indexOf("nix") >= 0 || SystemInfo.getOSName().indexOf("nux") >= 0 || SystemInfo.getOSName().indexOf("aix") > 0;
    }

    public static boolean isSolaris() {
        return SystemInfo.getOSName().toLowerCase().indexOf("sunos") >= 0;
    }
}

