/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.util.Hashtable;
import sun.misc.NativeSignalHandler;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public final class Signal {
    private static Hashtable<Signal, SignalHandler> handlers = new Hashtable(4);
    private static Hashtable<Integer, Signal> signals = new Hashtable(4);
    private int number;
    private String name;

    public int getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Signal)) {
            return false;
        }
        Signal signal = (Signal)object;
        return this.name.equals(signal.name) && this.number == signal.number;
    }

    public int hashCode() {
        return this.number;
    }

    public String toString() {
        return "SIG" + this.name;
    }

    public Signal(String string) {
        this.number = Signal.findSignal(string);
        this.name = string;
        if (this.number < 0) {
            throw new IllegalArgumentException("Unknown signal: " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized SignalHandler handle(Signal signal, SignalHandler signalHandler) throws IllegalArgumentException {
        long l = signalHandler instanceof NativeSignalHandler ? ((NativeSignalHandler)signalHandler).getHandler() : 2L;
        long l2 = Signal.handle0(signal.number, l);
        if (l2 == -1L) {
            throw new IllegalArgumentException("Signal already used by VM or OS: " + signal);
        }
        signals.put(signal.number, signal);
        Hashtable<Signal, SignalHandler> hashtable = handlers;
        synchronized (hashtable) {
            SignalHandler signalHandler2 = handlers.get(signal);
            handlers.remove(signal);
            if (l == 2L) {
                handlers.put(signal, signalHandler);
            }
            if (l2 == 0L) {
                return SignalHandler.SIG_DFL;
            }
            if (l2 == 1L) {
                return SignalHandler.SIG_IGN;
            }
            if (l2 == 2L) {
                return signalHandler2;
            }
            return new NativeSignalHandler(l2);
        }
    }

    public static void raise(Signal signal) throws IllegalArgumentException {
        if (handlers.get(signal) == null) {
            throw new IllegalArgumentException("Unhandled signal: " + signal);
        }
        Signal.raise0(signal.number);
    }

    private static void dispatch(int n) {
        Signal signal = signals.get(n);
        SignalHandler signalHandler = handlers.get(signal);
        1 var3_3 = new /* Unavailable Anonymous Inner Class!! */;
        if (signalHandler != null) {
            new Thread((Runnable)var3_3, signal + " handler").start();
        }
    }

    private static native int findSignal(String var0);

    private static native long handle0(int var0, long var1);

    private static native void raise0(int var0);
}

