/*
 * Decompiled with CFR 0.152.
 */
package io.vlinx.aot.loader;

import io.vlinx.aot.loader.Platform;
import io.vlinx.aot.loader.StreamUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class Loader {
    private static final Map<String, Boolean> loaded = new HashMap<String, Boolean>();
    private static final Map<String, Boolean> loading = new HashMap<String, Boolean>();
    private static final ReentrantLock lock = new ReentrantLock();
    private static final String VLX_LOADER_DEBUG = "VLX_LOADER_DEBUG";
    private static boolean debug = false;
    private static String tempFolderName = "vlx-aot-loader";

    private static void extractLLVMResources() throws IOException {
        String tempFolderPath = System.getProperty("java.io.tmpdir") + "/" + tempFolderName + "/launcher-resources";
        Files.createDirectories(Paths.get(tempFolderPath, new String[0]), new FileAttribute[0]);
        Loader.verbose("Extract launcher-resources to " + tempFolderPath);
        Loader.extractDir("launcher-resources", tempFolderPath);
    }

    private static native void nativeHello(String var0);

    private static native void initLauncher(String var0);

    private static void verbose(String msg) {
        if (!debug) {
            return;
        }
        System.out.println(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void load(Class clazz) {
        Loader.verbose("Load class: " + clazz.getName());
        URL url = clazz.getProtectionDomain().getCodeSource().getLocation();
        String jarPath = url.getPath();
        try {
            Map<String, Boolean> map = loaded;
            synchronized (map) {
                if (loaded.get(jarPath) != null) {
                    return;
                }
            }
            map = loading;
            synchronized (map) {
                if (loading.get(jarPath) != null && loading.get(jarPath).booleanValue()) {
                    Loader.verbose(jarPath + " is loading, skip: " + clazz.getName());
                    return;
                }
                loading.put(jarPath, Boolean.TRUE);
            }
            Loader.loadJar(jarPath);
            map = loaded;
            synchronized (map) {
                loaded.put(jarPath, true);
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        finally {
            Map<String, Boolean> map = loading;
            synchronized (map) {
                loading.remove(jarPath);
            }
        }
    }

    private static void loadJar(String jarPath) {
        Loader.verbose("Load jar: " + jarPath);
        Loader.loadObjectsAndBitcode(jarPath);
    }

    private static void loadObject(String objectPath) {
        Loader.verbose("Load object: " + objectPath);
        try (InputStream is = Loader.class.getResourceAsStream(objectPath);){
            byte[] data = StreamUtils.inputStreamToByteArray(is);
            long baseAddr = Loader.doLoadObject(data);
            Loader.verbose("Addr: " + baseAddr);
            String propsPath = objectPath + ".props";
            Loader.verbose("Load props: " + propsPath);
            Properties properties = StreamUtils.inputStreamToProperties(Loader.class.getResourceAsStream(propsPath));
            for (Object key : properties.keySet()) {
                if (!key.toString().toLowerCase().startsWith("java")) continue;
                Loader.verbose("do load method: " + key);
                String methodInfo = key.toString();
                String[] parts = methodInfo.split("_");
                String className = parts[1];
                String methodName = parts[2];
                String methodSignature = parts[3];
                Class<?> clazz = Class.forName(className);
                long addr = Long.parseLong(properties.getProperty(key.toString())) + baseAddr;
                Loader.doLoadMethod(clazz, methodName, methodSignature, addr);
            }
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private static void loadBitcode(String bitcodePath) {
        Loader.verbose("Load bitcode: " + bitcodePath);
        String resourcesDir = System.getProperty("java.io.tmpdir") + "/" + tempFolderName + "/launcher-resources";
        Loader.verbose("Resources Dir: " + resourcesDir);
        try (InputStream is = Loader.class.getResourceAsStream(bitcodePath);){
            byte[] data = StreamUtils.inputStreamToByteArray(is);
            Loader.doLoadBitcode(data, resourcesDir);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void loadObjectsAndBitcode(String jarPath) {
        Loader.verbose("loadObjectsAndBitcode from jar: " + jarPath);
        List<String> objects = Loader.fetchAllObjects(jarPath);
        for (String object : objects) {
            if (object.endsWith(".dat0")) {
                Loader.loadObject("/" + object);
                continue;
            }
            if (!object.endsWith(".dat1")) continue;
            Loader.loadBitcode("/" + object);
        }
    }

    private static native long doLoadObject(byte[] var0);

    private static native void doLoadBitcode(byte[] var0, String var1);

    private static native void doLoadMethod(Class var0, String var1, String var2, long var3);

    private static byte[] readAllBytes(InputStream is) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        try {
            int nRead;
            while ((nRead = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer.toByteArray();
    }

    private static String loadLib() {
        String currentPlatform = Platform.currentPlatform();
        String arch = currentPlatform.split("-")[1];
        String ext = "";
        if (currentPlatform.startsWith("win")) {
            ext = "dll";
        } else if (currentPlatform.startsWith("linux")) {
            ext = "so";
        } else if (currentPlatform.startsWith("mac")) {
            ext = "dylib";
        }
        String libName = "vlx_jvm_executor-" + arch + "." + ext;
        if (!currentPlatform.startsWith("win")) {
            libName = "lib" + libName;
        }
        Loader.loadLib(libName, ext);
        return "";
    }

    private static String loadLib(String libName, String ext) {
        String string;
        block9: {
            String libPath = "/native-libs/" + libName;
            InputStream in = Loader.class.getResourceAsStream(libPath);
            try {
                if (in == null) {
                    throw new IllegalArgumentException("Library not found: " + libPath);
                }
                String tempFolderPath = System.getProperty("java.io.tmpdir") + "/" + tempFolderName;
                Files.createDirectories(Paths.get(tempFolderPath, new String[0]), new FileAttribute[0]);
                String fileName = Loader.randomId() + "." + ext;
                String filePath = tempFolderPath + "/" + fileName;
                Path tempFile = Files.createFile(Paths.get(filePath, new String[0]), new FileAttribute[0]);
                Files.copy(in, tempFile, StandardCopyOption.REPLACE_EXISTING);
                Loader.verbose("Load lib: " + tempFile.toAbsolutePath().toString());
                System.load(tempFile.toAbsolutePath().toString());
                tempFile.toFile().deleteOnExit();
                string = tempFile.toAbsolutePath().toString();
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            in.close();
        }
        return string;
    }

    private static List<String> fetchAllObjects(String jarPath) {
        ArrayList<String> objects = new ArrayList<String>();
        try (JarFile jarFile = new JarFile(jarPath);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().startsWith("objects/" + Platform.currentPlatform()) || !entry.getName().endsWith(".dat0") && !entry.getName().endsWith(".dat1") || entry.isDirectory()) continue;
                objects.add(entry.getName());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return objects;
    }

    private static String randomId() {
        return UUID.randomUUID().toString().replace("-", "").substring(0, 8);
    }

    private static void extractDir(String source, String target) throws IOException {
        URL url = Loader.class.getProtectionDomain().getCodeSource().getLocation();
        String jarPath = url.getPath();
        Path targetDir = Paths.get(target, new String[0]);
        Files.createDirectories(targetDir, new FileAttribute[0]);
        try (JarFile jarFile = new JarFile(jarPath);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().startsWith(source) || entry.isDirectory()) continue;
                Path entryDestination = targetDir.resolve(entry.getName().substring(source.length() + 1));
                Files.createDirectories(entryDestination.getParent(), new FileAttribute[0]);
                InputStream in = jarFile.getInputStream(entry);
                try {
                    Files.copy(in, entryDestination, StandardCopyOption.REPLACE_EXISTING);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
    }

    static {
        if (System.getProperty(VLX_LOADER_DEBUG) != null && System.getProperty(VLX_LOADER_DEBUG).equals("true")) {
            debug = true;
        }
        Loader.loadLib();
        String string = Loader.loadLib();
    }
}

