//
// Created by vlinx on 2024/6/10.
//

#ifndef BINARY_LOADER_EXECUTOR_H
#define BINARY_LOADER_EXECUTOR_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <stdbool.h>
#include <jni.h>

#define CONDITION_EQUAL 0
#define CONDITION_NOT_EQUAL 1
#define CONDITION_LESS_THAN 2
#define CONDITION_GREATER_THAN 3
#define CONDITION_LESS_THAN_OR_EQUAL 4
#define CONDITION_GREATER_THAN_OR_EQUAL 5

#define null NULL

void printClassName(JNIEnv* env, jclass clazz);

char* replace_char(const char* str, char oldChar, char newChar);

jclass forName(JNIEnv* env, const char* className);

jclass findClassByObject(JNIEnv* env, jobject obj);

jclass findClassByName(JNIEnv* env, const char* className);

jfieldID findField(JNIEnv* env, jclass clazz, const char* fieldName, const char* fieldSig);

jfieldID findStaticField(JNIEnv* env, jclass clazz, const char* fieldName, const char* fieldSig);

jmethodID findMethod(JNIEnv* env, jobject obj, const char* methodName, const char* methodSig);

jmethodID findClassMethod(JNIEnv* env, jclass clazz, const char* methodName, const char* methodSig);

// 获取字段值的函数声明
jboolean getBooleanField(JNIEnv* env, jobject obj, jfieldID fieldId);

jbyte getByteField(JNIEnv* env, jobject obj, jfieldID fieldId);

jchar getCharField(JNIEnv* env, jobject obj, jfieldID fieldId);

jshort getShortField(JNIEnv* env, jobject obj, jfieldID fieldId);

jint getIntField(JNIEnv* env, jobject obj, jfieldID fieldId);

jlong getLongField(JNIEnv* env, jobject obj, jfieldID fieldId);

jfloat getFloatField(JNIEnv* env, jobject obj, jfieldID fieldId);

jdouble getDoubleField(JNIEnv* env, jobject obj, jfieldID fieldId);

jobject getObjectField(JNIEnv* env, jobject obj, jfieldID fieldId);

// 获取静态字段值的函数声明
jboolean getStaticBooleanField(JNIEnv* env, jclass clazz, jfieldID fieldId);

jbyte getStaticByteField(JNIEnv* env, jclass clazz, jfieldID fieldId);

jchar getStaticCharField(JNIEnv* env, jclass clazz, jfieldID fieldId);

jshort getStaticShortField(JNIEnv* env, jclass clazz, jfieldID fieldId);

jint getIntStaticField(JNIEnv* env, jclass clazz, jfieldID fieldId);

jlong getStaticLongField(JNIEnv* env, jclass clazz, jfieldID fieldId);

jfloat getStaticFloatField(JNIEnv* env, jclass clazz, jfieldID fieldId);

jdouble getStaticDoubleField(JNIEnv* env, jclass clazz, jfieldID fieldId);

jobject getStaticObjectField(JNIEnv* env, jclass clazz, jfieldID fieldId);

// 设置字段值的函数声明
void setBooleanField(JNIEnv* env, jobject obj, jfieldID fieldId, jboolean value);

void setByteField(JNIEnv* env, jobject obj, jfieldID fieldId, jbyte value);

void setCharField(JNIEnv* env, jobject obj, jfieldID fieldId, jchar value);

void setShortField(JNIEnv* env, jobject obj, jfieldID fieldId, jshort value);

void setIntField(JNIEnv* env, jobject obj, jfieldID fieldId, jint value);

void setLongField(JNIEnv* env, jobject obj, jfieldID fieldId, jlong value);

void setFloatField(JNIEnv* env, jobject obj, jfieldID fieldId, jfloat value);

void setDoubleField(JNIEnv* env, jobject obj, jfieldID fieldId, jdouble value);

void setObjectField(JNIEnv* env, jobject obj, jfieldID fieldId, jobject value);

// 设置静态字段值的函数声明
void setStaticBooleanField(JNIEnv* env, jclass clazz, jfieldID fieldId, jboolean value);

void setStaticByteField(JNIEnv* env, jclass clazz, jfieldID fieldId, jbyte value);

void setStaticCharField(JNIEnv* env, jclass clazz, jfieldID fieldId, jchar value);

void setStaticShortField(JNIEnv* env, jclass clazz, jfieldID fieldId, jshort value);

void setStaticIntField(JNIEnv* env, jclass clazz, jfieldID fieldId, jint value);

void setStaticLongField(JNIEnv* env, jclass clazz, jfieldID fieldId, jlong value);

void setStaticFloatField(JNIEnv* env, jclass clazz, jfieldID fieldId, jfloat value);

void setStaticDoubleField(JNIEnv* env, jclass clazz, jfieldID fieldId, jdouble value);

void setStaticObjectField(JNIEnv* env, jclass clazz, jfieldID fieldId, jobject value);

// 创建字符串、对象和数组的函数声明
jstring createNewString(JNIEnv* env, const char* str);

jobject allocateObject(JNIEnv* env, const char* className);

jbooleanArray createBooleanArray(JNIEnv* env, jint size);

jbyteArray createByteArray(JNIEnv* env, jint size);

jshortArray createShortArray(JNIEnv* env, jint size);

jintArray createIntArray(JNIEnv* env, jint size);

jlongArray createLongArray(JNIEnv* env, jint size);

jfloatArray createFloatArray(JNIEnv* env, jint size);

jdoubleArray createDoubleArray(JNIEnv* env, jint size);

jobjectArray createObjectArray(JNIEnv* env, const char* className, jint size);

jint getArrayLength(JNIEnv* env, jarray array);

// 实例判断和类型转换的函数声明
jboolean instanceOf(JNIEnv* env, jobject obj, const char* className);

void checkCast(JNIEnv* env, jobject obj, const char* className);

// 比较函数的声明
jint lcmp(jlong v1, jlong v2);

jint fcmp(jfloat v1, jfloat v2, jboolean g);

jint dcmp(jdouble v1, jdouble v2, jboolean g);

jboolean ifcmp(jint value, jint condition);

jboolean if_icmp(jint v1, jint v2, jint condition);

jboolean if_acmp(jobject v1, jobject v2, jint condition);

jboolean ifnull(jobject v1, jint condition);

// 调用函数的声明
void invokeStaticVoidMethod(JNIEnv* env, const char* className, const char* methodName, const char* methodSig, ...);

jboolean
invokeStaticBooleanMethod(JNIEnv* env, const char* className, const char* methodName, const char* methodSig, ...);

jbyte invokeStaticByteMethod(JNIEnv* env, const char* className, const char* methodName, const char* methodSig, ...);

jchar invokeStaticCharMethod(JNIEnv* env, const char* className, const char* methodName, const char* methodSig, ...);

jshort invokeStaticShortMethod(JNIEnv* env, const char* className, const char* methodName, const char* methodSig, ...);

jint invokeStaticIntMethod(JNIEnv* env, const char* className, const char* methodName, const char* methodSig, ...);

jlong invokeStaticLongMethod(JNIEnv* env, const char* className, const char* methodName, const char* methodSig, ...);

jfloat invokeStaticFloatMethod(JNIEnv* env, const char* className, const char* methodName, const char* methodSig, ...);

jdouble
invokeStaticDoubleMethod(JNIEnv* env, const char* className, const char* methodName, const char* methodSig, ...);

jobject
invokeStaticObjectMethod(JNIEnv* env, const char* className, const char* methodName, const char* methodSig, ...);

void invokeVoidMethod(JNIEnv* env, jobject obj, const char* methodName, const char* methodSig, ...);

jboolean invokeBooleanMethod(JNIEnv* env, jobject obj, const char* methodName, const char* methodSig, ...);

jbyte invokeByteMethod(JNIEnv* env, jobject obj, const char* methodName, const char* methodSig, ...);

jchar invokeCharMethod(JNIEnv* env, jobject obj, const char* methodName, const char* methodSig, ...);

jshort invokeShortMethod(JNIEnv* env, jobject obj, const char* methodName, const char* methodSig, ...);

jint invokeIntMethod(JNIEnv* env, jobject obj, const char* methodName, const char* methodSig, ...);

jlong invokeLongMethod(JNIEnv* env, jobject obj, const char* methodName, const char* methodSig, ...);

jfloat invokeFloatMethod(JNIEnv* env, jobject obj, const char* methodName, const char* methodSig, ...);

jdouble invokeDoubleMethod(JNIEnv* env, jobject obj, const char* methodName, const char* methodSig, ...);

jobject invokeObjectMethod(JNIEnv* env, jobject obj, const char* methodName, const char* methodSig, ...);

// 设置数组元素的函数声明
void setBooleanArrayElement(JNIEnv* env, jboolean* elements, jint index, jboolean value);

void setByteArrayElement(JNIEnv* env, jbyte* elements, jint index, jbyte value);

void setCharArrayElement(JNIEnv* env, jchar* elements, jint index, jchar value);

void setShortArrayElement(JNIEnv* env, jshort* elements, jint index, jshort value);

void setIntArrayElement(JNIEnv* env, jint* elements, jint index, jint value);

void setLongArrayElement(JNIEnv* env, jlong* elements, jint index, jlong value);

void setFloatArrayElement(JNIEnv* env, jfloatArray array, jint index, jfloat value);

void setDoubleArrayElement(JNIEnv* env, jdoubleArray array, jint index, jdouble value);

void setObjectArrayElement(JNIEnv* env, jobjectArray array, jint index, jobject value);

// 获取数组元素的函数声明
jboolean getBooleanArrayElement(JNIEnv* env, jbooleanArray array, jint index);

jbyte getByteArrayElement(JNIEnv* env, jbyteArray array, jint index);

jshort getShortArrayElement(JNIEnv* env, jshortArray array, jint index);

jint getIntArrayElement(JNIEnv* env, jint* elements, jint index);

jlong getLongArrayElement(JNIEnv* env, jlongArray array, jint index);

jfloat getFloatArrayElement(JNIEnv* env, jfloatArray array, jint index);

jdouble getDoubleArrayElement(JNIEnv* env, jdoubleArray array, jint index);

jobject getObjectArrayElement(JNIEnv* env, jobjectArray array, jint index);

jint* getIntArrayElements(JNIEnv* env, jintArray array);

// 字符串操作函数声明
bool startsWith(const char* str, const char* prefix);

bool endsWith(const char* str, const char* suffix);

const char* prependBrackets(const char* original, int dim);

// 创建多维数组的函数声明
jobjectArray createMultiArray(JNIEnv* env, const char* type, jint* sizes, jint dim);

// 方法句柄相关函数声明
jobject createMethodType(JNIEnv* env, const char* signature, jobject loader);

jobject currentThreadClassLoader(JNIEnv* env);

jobject createLookup(JNIEnv* env, const char* clazzName);

jobject createMethodHandle(JNIEnv* env, const char* className, const char* methodName, const char* methodSignature,
                           jboolean isStatic);

jboolean invokeWithArgumentsBoolean(JNIEnv* env, jobject methodHandle, jobjectArray args);

jbyte invokeWithArgumentsByte(JNIEnv* env, jobject methodHandle, jobjectArray args);

jchar invokeWithArgumentsChar(JNIEnv* env, jobject methodHandle, jobjectArray args);

jshort invokeWithArgumentsShort(JNIEnv* env, jobject methodHandle, jobjectArray args);

jint invokeWithArgumentsInt(JNIEnv* env, jobject methodHandle, jobjectArray args);

jlong invokeWithArgumentsLong(JNIEnv* env, jobject methodHandle, jobjectArray args);

jfloat invokeWithArgumentsFloat(JNIEnv* env, jobject methodHandle, jobjectArray args);

jdouble invokeWithArgumentsDouble(JNIEnv* env, jobject methodHandle, jobjectArray args);

void invokeWithArgumentsVoid(JNIEnv* env, jobject methodHandle, jobjectArray args);

jobject invokeWithArgumentsObject(JNIEnv* env, jobject methodHandle, jobjectArray args);

jobject dynamicInvoker(JNIEnv* env, jobject callSite);

// 装箱和拆箱函数声明
jobject boxInt(JNIEnv* env, jint value);

jobject boxBoolean(JNIEnv* env, jboolean value);

jobject boxByte(JNIEnv* env, jbyte value);

jobject boxChar(JNIEnv* env, jchar value);

jobject boxShort(JNIEnv* env, jshort value);

jobject boxLong(JNIEnv* env, jlong value);

jobject boxFloat(JNIEnv* env, jfloat value);

jobject boxDouble(JNIEnv* env, jdouble value);

jboolean unboxBoolean(JNIEnv* env, jobject value);

jbyte unboxByte(JNIEnv* env, jobject value);

jchar unboxChar(JNIEnv* env, jobject value);

jshort unboxShort(JNIEnv* env, jobject value);

jint unboxInt(JNIEnv* env, jobject value);

jlong unboxLong(JNIEnv* env, jobject value);

jfloat unboxFloat(JNIEnv* env, jobject value);

jdouble unboxDouble(JNIEnv* env, jobject value);

jboolean checkException(JNIEnv* env);

#endif //BINARY_LOADER_EXECUTOR_H

