/*	$FreeBSD: src/sys/netinet6/ipsec.h,v 1.4.2.2 2001/07/03 11:01:54 ume Exp $	*/
/*	$KAME: ipsec.h,v 1.44 2001/03/23 08:08:47 itojun Exp $	*/

/*
 * Copyright (C) 1995, 1996, 1997, and 1998 WIDE Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * IPsec controller part.
 */

#ifndef _NETINET6_IPSEC_H_
#define _NETINET6_IPSEC_H_
#include <sys/cdefs.h>
#include <sys/appleapiopts.h>

#include <net/pfkeyv2.h>
#include <uuid/uuid.h>

/* according to IANA assignment, port 0x0000 and proto 0xff are reserved. */
#define IPSEC_PORT_ANY          0
#define IPSEC_ULPROTO_ANY       255
#define IPSEC_PROTO_ANY         255

/* mode of security protocol */
/* NOTE: DON'T use IPSEC_MODE_ANY at SPD.  It's only use in SAD */
#define IPSEC_MODE_ANY          0       /* i.e. wildcard. */
#define IPSEC_MODE_TRANSPORT    1
#define IPSEC_MODE_TUNNEL       2

/*
 * Direction of security policy.
 * NOTE: Since INVALID is used just as flag.
 * The other are used for loop counter too.
 */
#define IPSEC_DIR_ANY           0
#define IPSEC_DIR_INBOUND       1
#define IPSEC_DIR_OUTBOUND      2
#define IPSEC_DIR_MAX           3
#define IPSEC_DIR_INVALID       4

/* Policy level */
/*
 * IPSEC, ENTRUST and BYPASS are allowed for setsockopt() in PCB,
 * DISCARD, IPSEC and NONE are allowed for setkey() in SPD.
 * DISCARD and NONE are allowed for system default.
 */
#define IPSEC_POLICY_DISCARD    0       /* discarding packet */
#define IPSEC_POLICY_NONE       1       /* through IPsec engine */
#define IPSEC_POLICY_IPSEC      2       /* do IPsec */
#define IPSEC_POLICY_ENTRUST    3       /* consulting SPD if present. */
#define IPSEC_POLICY_BYPASS     4       /* only for privileged socket. */
#define IPSEC_POLICY_GENERATE   5       /* same as discard - IKE daemon can override with generated policy */

/* Security protocol level */
#define IPSEC_LEVEL_DEFAULT     0       /* reference to system default */
#define IPSEC_LEVEL_USE         1       /* use SA if present. */
#define IPSEC_LEVEL_REQUIRE     2       /* require SA. */
#define IPSEC_LEVEL_UNIQUE      3       /* unique SA. */

#define IPSEC_MANUAL_REQID_MAX  0x3fff
/*
 * if security policy level == unique, this id
 * indicate to a relative SA for use, else is
 * zero.
 * 1 - 0x3fff are reserved for manual keying.
 * 0 are reserved for above reason.  Others is
 * for kernel use.
 * Note that this id doesn't identify SA
 * by only itself.
 */
#define IPSEC_REPLAYWSIZE  32

/* statistics for ipsec processing */
struct ipsecstat {
	u_quad_t in_success __attribute__ ((aligned(8)));  /* succeeded inbound process */
	u_quad_t in_polvio __attribute__ ((aligned(8)));
	/* security policy violation for inbound process */
	u_quad_t in_nosa __attribute__ ((aligned(8)));      /* inbound SA is unavailable */
	u_quad_t in_inval __attribute__ ((aligned(8)));     /* inbound processing failed due to EINVAL */
	u_quad_t in_nomem __attribute__ ((aligned(8)));     /* inbound processing failed due to ENOBUFS */
	u_quad_t in_badspi __attribute__ ((aligned(8)));    /* failed getting a SPI */
	u_quad_t in_ahreplay __attribute__ ((aligned(8)));  /* AH replay check failed */
	u_quad_t in_espreplay __attribute__ ((aligned(8)));  /* ESP replay check failed */
	u_quad_t in_ahauthsucc __attribute__ ((aligned(8)));  /* AH authentication success */
	u_quad_t in_ahauthfail __attribute__ ((aligned(8)));  /* AH authentication failure */
	u_quad_t in_espauthsucc __attribute__ ((aligned(8)));  /* ESP authentication success */
	u_quad_t in_espauthfail __attribute__ ((aligned(8)));  /* ESP authentication failure */
	u_quad_t in_esphist[256] __attribute__ ((aligned(8)));
	u_quad_t in_ahhist[256] __attribute__ ((aligned(8)));
	u_quad_t in_comphist[256] __attribute__ ((aligned(8)));
	u_quad_t out_success __attribute__ ((aligned(8)));  /* succeeded outbound process */
	u_quad_t out_polvio __attribute__ ((aligned(8)));
	/* security policy violation for outbound process */
	u_quad_t out_nosa __attribute__ ((aligned(8)));     /* outbound SA is unavailable */
	u_quad_t out_inval __attribute__ ((aligned(8)));    /* outbound process failed due to EINVAL */
	u_quad_t out_nomem __attribute__ ((aligned(8)));     /* inbound processing failed due to ENOBUFS */
	u_quad_t out_noroute __attribute__ ((aligned(8)));  /* there is no route */
	u_quad_t out_esphist[256] __attribute__ ((aligned(8)));
	u_quad_t out_ahhist[256] __attribute__ ((aligned(8)));
	u_quad_t out_comphist[256] __attribute__ ((aligned(8)));
};

#define IPSEC_MAX_WAKE_PKT_LEN  100
struct ipsec_wake_pkt_info {
	u_int8_t wake_pkt[IPSEC_MAX_WAKE_PKT_LEN];
	uuid_string_t wake_uuid;
	u_int32_t wake_pkt_spi;
	u_int32_t wake_pkt_seq;
	u_int16_t wake_pkt_len;
};

struct ipsec_wake_pkt_event_data {
	uuid_string_t wake_uuid;
};


__BEGIN_DECLS
extern caddr_t ipsec_set_policy(char *, int);
extern int ipsec_get_policylen(caddr_t);
extern char *ipsec_dump_policy(caddr_t, char *);

extern const char *ipsec_strerror(void);
__END_DECLS

#endif /* _NETINET6_IPSEC_H_ */
