/*++ BUILD Version: 0001    // Increment this if a change has global effects

Copyright (c) 1992-1996  Microsoft Corporation

Module Name:

    netevent.h

Abstract:

    Definitions for network events.

Author:

    Portable Systems Group 6-May-1992

Revision History:

Notes:

    This file is generated by the MC tool from the netevent.mc file.

--*/

#ifndef _NETEVENT_
#define _NETEVENT_


/////////////////////////////////////////////////////////////////////////
//
// Lanman Server Events (2000 - 2999)
//     2000-2499 are generated by the server driver (kernel mode)
//     2500-2999 are generated by the server service (user mode)
//
/////////////////////////////////////////////////////////////////////////


// Server driver events, issued from kernel mode.  Don't use %1 for
// server-supplied insertion strings -- the I/O system provides the
// first string.

//
//  Values are 32 bit values laid out as follows:
//
//   3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
//   1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
//  +---+-+-+-----------------------+-------------------------------+
//  |Sev|C|R|     Facility          |               Code            |
//  +---+-+-+-----------------------+-------------------------------+
//
//  where
//
//      Sev - is the severity code
//
//          00 - Success
//          01 - Informational
//          10 - Warning
//          11 - Error
//
//      C - is the Customer code flag
//
//      R - is a reserved bit
//
//      Facility - is the facility code
//
//      Code - is the facility's status code
//
//
// Define the facility codes
//


//
// Define the severity codes
//
#define STATUS_SEVERITY_SUCCESS          0x0
#define STATUS_SEVERITY_INFORMATIONAL    0x1
#define STATUS_SEVERITY_WARNING          0x2
#define STATUS_SEVERITY_ERROR            0x3


//
// MessageId: EVENT_SRV_SERVICE_FAILED
//
// MessageText:
//
// The server's call to a system service failed unexpectedly.
//
#define EVENT_SRV_SERVICE_FAILED         0xC00007D0L

//
// MessageId: EVENT_SRV_RESOURCE_SHORTAGE
//
// MessageText:
//
// The server was unable to perform an operation due to a shortage of available resources.
//
#define EVENT_SRV_RESOURCE_SHORTAGE      0xC00007D1L

//
// MessageId: EVENT_SRV_CANT_CREATE_DEVICE
//
// MessageText:
//
// The server could not create its device.  The server could not be started.
//
#define EVENT_SRV_CANT_CREATE_DEVICE     0xC00007D2L

//
// MessageId: EVENT_SRV_CANT_CREATE_PROCESS
//
// MessageText:
//
// The server could not create a process.  The server could not be started.
//
#define EVENT_SRV_CANT_CREATE_PROCESS    0xC00007D3L

//
// MessageId: EVENT_SRV_CANT_CREATE_THREAD
//
// MessageText:
//
// The server could not create a startup thread.  The server could not be started.
//
#define EVENT_SRV_CANT_CREATE_THREAD     0xC00007D4L

//
// MessageId: EVENT_SRV_UNEXPECTED_DISC
//
// MessageText:
//
// The server received an unexpected disconnection from a client.
//
#define EVENT_SRV_UNEXPECTED_DISC        0xC00007D5L

//
// MessageId: EVENT_SRV_INVALID_REQUEST
//
// MessageText:
//
// The server received an incorrectly formatted request from %2.
//
#define EVENT_SRV_INVALID_REQUEST        0xC00007D6L

//
// MessageId: EVENT_SRV_CANT_OPEN_NPFS
//
// MessageText:
//
// The server could not open the named pipe file system.  Remote named pipes are disabled.
//
#define EVENT_SRV_CANT_OPEN_NPFS         0xC00007D7L

//
// MessageId: EVENT_SRV_CANT_GROW_TABLE
//
// MessageText:
//
// The server could not expand a table because the table reached the maximum size.
//
#define EVENT_SRV_CANT_GROW_TABLE        0x800007D9L

//
// MessageId: EVENT_SRV_CANT_START_SCAVENGER
//
// MessageText:
//
// The server could not start the scavenger thread.  The server could not be started.
//
#define EVENT_SRV_CANT_START_SCAVENGER   0xC00007DAL

//
// MessageId: EVENT_SRV_IRP_STACK_SIZE
//
// MessageText:
//
// The server's configuration parameter "irpstacksize" is too small for the server to use a local device.  Please increase the value of this parameter.
//
#define EVENT_SRV_IRP_STACK_SIZE         0xC00007DBL

//
// MessageId: EVENT_SRV_NETWORK_ERROR
//
// MessageText:
//
// While transmitting or receiving data, the server encountered a network error.
// Occasional errors are expected, but large amounts of these indicate a possible
// error in your network configuration.  The error status code is contained within
// the returned data (formatted as Words) and may point you towards the problem.
//
#define EVENT_SRV_NETWORK_ERROR          0x800007DCL

//
// MessageId: EVENT_SRV_DISK_FULL
//
// MessageText:
//
// The %2 disk is at or near capacity.  You may need to delete some files.
//
#define EVENT_SRV_DISK_FULL              0x800007DDL

//
// MessageId: EVENT_SRV_NO_VIRTUAL_MEMORY
//
// MessageText:
//
// The server was unable to allocate virtual memory.
//
#define EVENT_SRV_NO_VIRTUAL_MEMORY      0xC00007E0L

//
// MessageId: EVENT_SRV_NONPAGED_POOL_LIMIT
//
// MessageText:
//
// The server was unable to allocate from the system nonpaged pool because the server reached the configured limit for nonpaged pool allocations.
//
#define EVENT_SRV_NONPAGED_POOL_LIMIT    0xC00007E1L

//
// MessageId: EVENT_SRV_PAGED_POOL_LIMIT
//
// MessageText:
//
// The server was unable to allocate from the system paged pool because the server reached the configured limit for paged pool allocations.
//
#define EVENT_SRV_PAGED_POOL_LIMIT       0xC00007E2L

//
// MessageId: EVENT_SRV_NO_NONPAGED_POOL
//
// MessageText:
//
// The server was unable to allocate from the system nonpaged pool because the pool was empty.
//
#define EVENT_SRV_NO_NONPAGED_POOL       0xC00007E3L

//
// MessageId: EVENT_SRV_NO_PAGED_POOL
//
// MessageText:
//
// The server was unable to allocate from the system paged pool because the pool was empty.
//
#define EVENT_SRV_NO_PAGED_POOL          0xC00007E4L

//
// MessageId: EVENT_SRV_NO_WORK_ITEM
//
// MessageText:
//
// The server was unable to allocate a work item %2 times in the last %3 seconds.
//
#define EVENT_SRV_NO_WORK_ITEM           0x800007E5L

//
// MessageId: EVENT_SRV_NO_FREE_CONNECTIONS
//
// MessageText:
//
// The server was unable to find a free connection %2 times in the last %3 seconds.  This indicates a spike in
// network traffic.  If this is happening frequently, you should consider increasing the minimum number of free
// connections to add headroom.  To do that, modify the MinFreeConnections and MaxFreeConnections for the LanmanServer
// in the registry.
//
#define EVENT_SRV_NO_FREE_CONNECTIONS    0x800007E6L

//
// MessageId: EVENT_SRV_NO_FREE_RAW_WORK_ITEM
//
// MessageText:
//
// The server was unable to find a free raw work item %2 times in the last %3 seconds.
//
#define EVENT_SRV_NO_FREE_RAW_WORK_ITEM  0x800007E7L

//
// MessageId: EVENT_SRV_NO_BLOCKING_IO
//
// MessageText:
//
// The server was unable to allocate resources for blocking I/O %2 times in the last %3 seconds.
//
#define EVENT_SRV_NO_BLOCKING_IO         0x800007E8L

//
// MessageId: EVENT_SRV_DOS_ATTACK_DETECTED
//
// MessageText:
//
// The server has detected an attempted Denial-Of-Service attack from client %2, and has disconnected the connection.
//
#define EVENT_SRV_DOS_ATTACK_DETECTED    0x800007E9L

//
// MessageId: EVENT_SRV_TOO_MANY_DOS
//
// MessageText:
//
// The server has detected too many Denial-Of-Service attacks and will stop logging
// events for any more of them.  Be advised it is likely someone is actively attacking
// your machine.
//
#define EVENT_SRV_TOO_MANY_DOS           0x800007EAL

//
// MessageId: EVENT_SRV_OUT_OF_WORK_ITEM_DOS
//
// MessageText:
//
// The server has detected a potential Denial-of-Service attack caused by consuming all the work-items.  Some connections
// were disconnected to protect against this.  If this is not the case, please raise the MaxWorkItems for the server or
// disable DoS detection.  This event will not be logged again for 24 hours.
//
#define EVENT_SRV_OUT_OF_WORK_ITEM_DOS   0x800007EBL


// Server service events, issued from user mode.  %1 is the first
// service-supplied insertion string.

//
// MessageId: EVENT_SRV_KEY_NOT_FOUND
//
// MessageText:
//
// The server's Registry key %1 was not present.  The server could not start.
//
#define EVENT_SRV_KEY_NOT_FOUND          0xC00009C5L

//
// MessageId: EVENT_SRV_KEY_NOT_CREATED
//
// MessageText:
//
// The server's Registry key %1 was not present and could not be created.  The server could not start.
//
#define EVENT_SRV_KEY_NOT_CREATED        0xC00009C6L

//
// MessageId: EVENT_SRV_NO_TRANSPORTS_BOUND
//
// MessageText:
//
// The server did not bind to any transports.  The server could not start.
//
#define EVENT_SRV_NO_TRANSPORTS_BOUND    0xC00009C7L

//
// MessageId: EVENT_SRV_CANT_BIND_TO_TRANSPORT
//
// MessageText:
//
// The server could not bind to the transport %1.
//
#define EVENT_SRV_CANT_BIND_TO_TRANSPORT 0x800009C8L

//
// MessageId: EVENT_SRV_CANT_BIND_DUP_NAME
//
// MessageText:
//
// The server could not bind to the transport %1 because another computer on the network has the same name.  The server could not start.
//
#define EVENT_SRV_CANT_BIND_DUP_NAME     0xC00009C9L

//
// MessageId: EVENT_SRV_INVALID_REGISTRY_VALUE
//
// MessageText:
//
// The value named %1 in the server's registry key %2 was not valid, and was ignored.
// If you want to change the value, change it to one that is the correct type and is
// within the acceptable range, or delete the value to use the default. This value
// might have been set up by an older program that did not use the correct boundaries.
//
#define EVENT_SRV_INVALID_REGISTRY_VALUE 0x800009CAL

//
// MessageId: EVENT_SRV_INVALID_SD
//
// MessageText:
//
// The security descriptor stored in the Registry for the share %1 was invalid.  The share was not automatically recreated.
//
#define EVENT_SRV_INVALID_SD             0x800009CBL

//
// MessageId: EVENT_SRV_CANT_LOAD_DRIVER
//
// MessageText:
//
// The server service was unable to load the server driver.
//
#define EVENT_SRV_CANT_LOAD_DRIVER       0x800009CCL

//
// MessageId: EVENT_SRV_CANT_UNLOAD_DRIVER
//
// MessageText:
//
// The server service was unable to unload the server driver.
//
#define EVENT_SRV_CANT_UNLOAD_DRIVER     0x800009CDL

//
// MessageId: EVENT_SRV_CANT_MAP_ERROR
//
// MessageText:
//
// The server service was unable to map error code %1.
//
#define EVENT_SRV_CANT_MAP_ERROR         0x800009CEL

//
// MessageId: EVENT_SRV_CANT_RECREATE_SHARE
//
// MessageText:
//
// The server service was unable to recreate the share %1 because the directory %2 no longer exists.  Please run "net share %1 /delete" to delete the share, or recreate the directory %2.
//
#define EVENT_SRV_CANT_RECREATE_SHARE    0x800009CFL

//
// MessageId: EVENT_SRV_CANT_CHANGE_DOMAIN_NAME
//
// MessageText:
//
// The server service was unable to change the domain name from %1 to %2.
//
#define EVENT_SRV_CANT_CHANGE_DOMAIN_NAME 0x800009D0L

//
// MessageId: EVENT_SRV_TXF_INIT_FAILED
//
// MessageText:
//
// The server service was unable to register to the transaction resource manager. Remote transactions will be unavailable.
//
#define EVENT_SRV_TXF_INIT_FAILED        0x800009D1L


/////////////////////////////////////////////////////////////////////////
//
// Lanman Redirector Events
//
//
/////////////////////////////////////////////////////////////////////////


//
// MessageId: EVENT_RDR_RESOURCE_SHORTAGE
//
// MessageText:
//
// The redirector was unable to allocate memory.
//
#define EVENT_RDR_RESOURCE_SHORTAGE      0x80000BB9L

//
// MessageId: EVENT_RDR_CANT_CREATE_DEVICE
//
// MessageText:
//
// The redirector could not create its device.  The redirector could not be started.
//
#define EVENT_RDR_CANT_CREATE_DEVICE     0x80000BBAL

//
// MessageId: EVENT_RDR_CANT_CREATE_THREAD
//
// MessageText:
//
// The redirector could not create a system thread.
//
#define EVENT_RDR_CANT_CREATE_THREAD     0x80000BBBL

//
// MessageId: EVENT_RDR_CANT_SET_THREAD
//
// MessageText:
//
// The redirector could not set the priority for a system thread.
//
#define EVENT_RDR_CANT_SET_THREAD        0x80000BBCL

//
// MessageId: EVENT_RDR_INVALID_REPLY
//
// MessageText:
//
// The redirector received an incorrectly formatted response from %2.
//
#define EVENT_RDR_INVALID_REPLY          0x80000BBDL

//
// MessageId: EVENT_RDR_INVALID_SMB
//
// MessageText:
//
// The redirector received an SMB that was too short.
//
#define EVENT_RDR_INVALID_SMB            0x80000BBEL

//
// MessageId: EVENT_RDR_INVALID_LOCK_REPLY
//
// MessageText:
//
// The redirector received an incorrect response from %2 to a lock request.
//
#define EVENT_RDR_INVALID_LOCK_REPLY     0x80000BBFL

//
// MessageId: EVENT_RDR_FAILED_UNLOCK
//
// MessageText:
//
// The redirector failed to unlock part of a file on server %2.
//
#define EVENT_RDR_FAILED_UNLOCK          0x80000BC1L

//
// MessageId: EVENT_RDR_CLOSE_BEHIND
//
// MessageText:
//
// The redirector failed to write data to server %2 after the file was closed.
//
#define EVENT_RDR_CLOSE_BEHIND           0x80000BC3L

//
// MessageId: EVENT_RDR_UNEXPECTED_ERROR
//
// MessageText:
//
// An unexpected network error has occurred on the virtual circuit to %2.
//
#define EVENT_RDR_UNEXPECTED_ERROR       0x80000BC4L

//
// MessageId: EVENT_RDR_TIMEOUT
//
// MessageText:
//
// The redirector has timed out a request to %2.
//
#define EVENT_RDR_TIMEOUT                0x80000BC5L

//
// MessageId: EVENT_RDR_INVALID_OPLOCK
//
// MessageText:
//
// The redirector received an invalid oplock level from %2.
//
#define EVENT_RDR_INVALID_OPLOCK         0x80000BC6L

//
// MessageId: EVENT_RDR_CONNECTION_REFERENCE
//
// MessageText:
//
// The redirector dereferenced a connection through zero.
//
#define EVENT_RDR_CONNECTION_REFERENCE   0x80000BC7L

//
// MessageId: EVENT_RDR_SERVER_REFERENCE
//
// MessageText:
//
// The redirector dereferenced a server through zero.
//
#define EVENT_RDR_SERVER_REFERENCE       0x80000BC8L

//
// MessageId: EVENT_RDR_SMB_REFERENCE
//
// MessageText:
//
// The redirector dereferenced the allocated SMB count through zero.
//
#define EVENT_RDR_SMB_REFERENCE          0x80000BC9L

//
// MessageId: EVENT_RDR_ENCRYPT
//
// MessageText:
//
// The redirector accessed a share-level server that indicates it encrypts passwords.
// This combination is not supported.
//
#define EVENT_RDR_ENCRYPT                0x80000BCAL

//
// MessageId: EVENT_RDR_CONNECTION
//
// MessageText:
//
// The redirector failed to determine the connection type.
//
#define EVENT_RDR_CONNECTION             0x80000BCBL

//
// MessageId: EVENT_RDR_MAXCMDS
//
// MessageText:
//
// The redirector failed to allocate a multiplex table entry.  This indicates that
// the MAXCMDS parameter to the redirector is insufficient for the users needs.
//
#define EVENT_RDR_MAXCMDS                0x80000BCDL

//
// MessageId: EVENT_RDR_OPLOCK_SMB
//
// MessageText:
//
// The redirector failed to allocate a buffer for an oplock break.
//
#define EVENT_RDR_OPLOCK_SMB             0x80000BCEL

//
// MessageId: EVENT_RDR_DISPOSITION
//
// MessageText:
//
// The redirector failed to map the requested file disposition (for NtCreateFile).
//
#define EVENT_RDR_DISPOSITION            0x80000BCFL

//
// MessageId: EVENT_RDR_CONTEXTS
//
// MessageText:
//
// The redirector is allocating additional resources for input/output request packet contexts.  This is
// probably caused by a resource leak in the redirector.
//
#define EVENT_RDR_CONTEXTS               0x80000BD0L

//
// MessageId: EVENT_RDR_WRITE_BEHIND_FLUSH_FAILED
//
// MessageText:
//
// A write-behind operation has failed to the remote server %2.  The data contains the amount requested to write and the amount actually written.
//
#define EVENT_RDR_WRITE_BEHIND_FLUSH_FAILED 0x80000BD1L

//
// MessageId: EVENT_RDR_AT_THREAD_MAX
//
// MessageText:
//
// The redirector was unable to create a worker thread because it has already created the maximum number of configured work threads.
//
#define EVENT_RDR_AT_THREAD_MAX          0x80000BD2L

//
// MessageId: EVENT_RDR_CANT_READ_REGISTRY
//
// MessageText:
//
// The redirector was unable to initialize variables from the Registry.
//
#define EVENT_RDR_CANT_READ_REGISTRY     0x80000BD3L

//
// MessageId: EVENT_RDR_TIMEZONE_BIAS_TOO_LARGE
//
// MessageText:
//
// The time zone bias calculated between %2 and the current workstation is too
// large.  The data specifies the number of 100ns units between the workstation
// and server.  Make sure that the time of day on the workstation and server are
// correct.
//
#define EVENT_RDR_TIMEZONE_BIAS_TOO_LARGE 0x80000BD4L

//
// MessageId: EVENT_RDR_PRIMARY_TRANSPORT_CONNECT_FAILED
//
// MessageText:
//
// The redirector has failed to connect to the server %2 on the primary transport.  The data contains the error.
//
#define EVENT_RDR_PRIMARY_TRANSPORT_CONNECT_FAILED 0x80000BD5L

//
// MessageId: EVENT_RDR_DELAYED_SET_ATTRIBUTES_FAILED
//
// MessageText:
//
// The redirector was unable to update the file attributes on a file located on server %2.
// The data contains the name of the file.
//
#define EVENT_RDR_DELAYED_SET_ATTRIBUTES_FAILED 0x80000BD6L

//
// MessageId: EVENT_RDR_DELETEONCLOSE_FAILED
//
// MessageText:
//
// The redirector was unable to delete the file specified on server %2 when it was closed by the application.
// The data contains the name of the file.
//
#define EVENT_RDR_DELETEONCLOSE_FAILED   0x80000BD7L

//
// MessageId: EVENT_RDR_CANT_BIND_TRANSPORT
//
// MessageText:
//
// The redirector was unable to register the domain %2 on to transport %3 for the following reason: %4. Transport has been taken offline.
//
#define EVENT_RDR_CANT_BIND_TRANSPORT    0x80000BD8L

//
// MessageId: EVENT_RDR_CANT_REGISTER_ADDRESS
//
// MessageText:
//
// The redirector was unable to register the address for transport %3 for the following reason: %4. Transport has been taken offline.
//
#define EVENT_RDR_CANT_REGISTER_ADDRESS  0x80000BD9L

//
// MessageId: EVENT_RDR_CANT_GET_SECURITY_CONTEXT
//
// MessageText:
//
// The redirector was unable to initialize security context or query context attributes.
//
#define EVENT_RDR_CANT_GET_SECURITY_CONTEXT 0x80000BDAL

//
// MessageId: EVENT_RDR_CANT_BUILD_SMB_HEADER
//
// MessageText:
//
// The redirector was unable to build SMB header.
//
#define EVENT_RDR_CANT_BUILD_SMB_HEADER  0x80000BDBL

//
// MessageId: EVENT_RDR_SECURITY_SIGNATURE_MISMATCH
//
// MessageText:
//
// The redirector detected a security signature mismatch. The connection has been disconnected.
//
#define EVENT_RDR_SECURITY_SIGNATURE_MISMATCH 0x80000BDCL



/////////////////////////////////////////////////////////////////////////
//
// IPv6 Events
//
// Codes 3100 - 3199
//
/////////////////////////////////////////////////////////////////////////


//
// MessageId: EVENT_TCPIP6_STARTED
//
// MessageText:
//
// The Microsoft TCP/IP version 6 driver was started.
//
#define EVENT_TCPIP6_STARTED             0x40000C1CL



/////////////////////////////////////////////////////////////////////////
//
// STREAMS Environment Events
//
// Codes 4000 - 4099
//
/////////////////////////////////////////////////////////////////////////


//
// MessageId: EVENT_STREAMS_STRLOG
//
// MessageText:
//
// %2
//
#define EVENT_STREAMS_STRLOG             0xC0000FA0L

//
// MessageId: EVENT_STREAMS_ALLOCB_FAILURE
//
// MessageText:
//
// Unable to allocate a %2 byte message.
//
#define EVENT_STREAMS_ALLOCB_FAILURE     0x80000FA1L

//
// MessageId: EVENT_STREAMS_ALLOCB_FAILURE_CNT
//
// MessageText:
//
// %2 message allocations have failed since initialization.
//
#define EVENT_STREAMS_ALLOCB_FAILURE_CNT 0x80000FA2L

//
// MessageId: EVENT_STREAMS_ESBALLOC_FAILURE
//
// MessageText:
//
// Unable to allocate a %2 byte external message.
//
#define EVENT_STREAMS_ESBALLOC_FAILURE   0x80000FA3L

//
// MessageId: EVENT_STREAMS_ESBALLOC_FAILURE_CNT
//
// MessageText:
//
// %2 external message allocations have failed since initialization.
//
#define EVENT_STREAMS_ESBALLOC_FAILURE_CNT 0x80000FA4L



/////////////////////////////////////////////////////////////////////////
//
// TCP/IP Events
//
// Codes 4100 - 4299
//
/////////////////////////////////////////////////////////////////////////


//
// Common TCP/IP messages
//
// Codes 4100 - 4149
//
//

//
// MessageId: EVENT_TCPIP_CREATE_DEVICE_FAILED
//
// MessageText:
//
// Unable to create device object %2. Initialization failed.
//
#define EVENT_TCPIP_CREATE_DEVICE_FAILED 0xC0001004L

//
// MessageId: EVENT_TCPIP_NO_RESOURCES_FOR_INIT
//
// MessageText:
//
// Unable to allocate required resources. Initialization failed.
//
#define EVENT_TCPIP_NO_RESOURCES_FOR_INIT 0xC0001005L


//
// ARP messages
//
// Codes 4150-4174


//
// IP Loopback messages
//
// Codes 4175-4184
//


//
// IP/ICMP messages
//
// Codes 4185 - 4224

//
// MessageId: EVENT_TCPIP_TOO_MANY_NETS
//
// MessageText:
//
// IP has been bound to more than the maximum number of supported interfaces.
// Some interfaces on network adapter %2 will not be initialized.
//
#define EVENT_TCPIP_TOO_MANY_NETS        0xC0001059L

//
// MessageId: EVENT_TCPIP_NO_MASK
//
// MessageText:
//
// No subnet mask was specified for interface %2. This interface and all
// subsequent interfaces on network adapter %3 cannot be initialized.
//
#define EVENT_TCPIP_NO_MASK              0xC000105AL

//
// MessageId: EVENT_TCPIP_INVALID_ADDRESS
//
// MessageText:
//
// An invalid address %2 was specified for network adapter %3. This interface
// cannot be initialized.
//
#define EVENT_TCPIP_INVALID_ADDRESS      0xC000105BL

//
// MessageId: EVENT_TCPIP_INVALID_MASK
//
// MessageText:
//
// An invalid subnet mask %2 was specified for address %3 on network adapter %4.
// This interface cannot be initialized.
//
#define EVENT_TCPIP_INVALID_MASK         0xC000105CL

//
// MessageId: EVENT_TCPIP_NO_ADAPTER_RESOURCES
//
// MessageText:
//
// IP could not allocate some resources required to configure network adapter %2.
// Some interfaces on this network adapter will not be initialized.
//
#define EVENT_TCPIP_NO_ADAPTER_RESOURCES 0xC000105DL

//
// MessageId: EVENT_TCPIP_DHCP_INIT_FAILED
//
// MessageText:
//
// IP was unable to initialize network adapter %2 for configuration by DHCP.
// If DHCP is enabled on this network adapter, the primary interface may not be
// configured properly. Interfaces on this network adapter not configured by
// DHCP will be unaffected.
//
#define EVENT_TCPIP_DHCP_INIT_FAILED     0x8000105EL

//
// MessageId: EVENT_TCPIP_ADAPTER_REG_FAILURE
//
// MessageText:
//
// IP could not open the registry key for network adapter %2.
// Interfaces on this network adapter will not be initialized.
//
#define EVENT_TCPIP_ADAPTER_REG_FAILURE  0xC000105FL

//
// MessageId: EVENT_TCPIP_INVALID_DEFAULT_GATEWAY
//
// MessageText:
//
// Invalid default gateway address %2 was specified for network adapter %3.
// Some remote networks may not be reachable as a result.
//
#define EVENT_TCPIP_INVALID_DEFAULT_GATEWAY 0x80001060L

//
// MessageId: EVENT_TCPIP_NO_ADDRESS_LIST
//
// MessageText:
//
// Unable to read the configured IP addresses for network adapter %2.
// IP interfaces will not be initialized on this network adapter.
//
#define EVENT_TCPIP_NO_ADDRESS_LIST      0xC0001061L

//
// MessageId: EVENT_TCPIP_NO_MASK_LIST
//
// MessageText:
//
// Unable to read the configured subnet masks for network adapter %2.
// IP interfaces will not be initialized on this network adapter.
//
#define EVENT_TCPIP_NO_MASK_LIST         0xC0001062L

//
// MessageId: EVENT_TCPIP_NO_BINDINGS
//
// MessageText:
//
// IP was unable to read its bindings from the registry. No network interfaces
// were configured.
//
#define EVENT_TCPIP_NO_BINDINGS          0xC0001063L

//
// MessageId: EVENT_TCPIP_IP_INIT_FAILED
//
// MessageText:
//
// Initialization of IP failed.
//
#define EVENT_TCPIP_IP_INIT_FAILED       0xC0001064L

//
// MessageId: EVENT_TCPIP_TOO_MANY_GATEWAYS
//
// MessageText:
//
// More than the maximum number of default gateways were specified for
// network adapter %2. Some remote networks may not be reachable as a result.
//
#define EVENT_TCPIP_TOO_MANY_GATEWAYS    0x80001065L

//
// MessageId: EVENT_TCPIP_ADDRESS_CONFLICT1
//
// MessageText:
//
// The system detected an address conflict for IP address %2 with the system
// having network hardware address %3. The local interface has been disabled.
//
#define EVENT_TCPIP_ADDRESS_CONFLICT1    0xC0001066L

//
// MessageId: EVENT_TCPIP_ADDRESS_CONFLICT2
//
// MessageText:
//
// The system detected an address conflict for IP address %2 with the system
// having network hardware address %3. Network operations on this system may
// be disrupted as a result.
//
#define EVENT_TCPIP_ADDRESS_CONFLICT2    0xC0001067L

//
// MessageId: EVENT_TCPIP_NTE_CONTEXT_LIST_FAILURE
//
// MessageText:
//
// Unable to read or write the NTE Context list for network adapter %2.
// IP interfaces on this network adapter may not be initialized completely.
//
#define EVENT_TCPIP_NTE_CONTEXT_LIST_FAILURE 0xC0001068L

//
// MessageId: EVENT_TCPIP_MEDIA_CONNECT
//
// MessageText:
//
// The system detected that network adapter %2 was connected to the network,
// and has initiated normal operation.
//
#define EVENT_TCPIP_MEDIA_CONNECT        0x40001069L

//
// MessageId: EVENT_TCPIP_MEDIA_DISCONNECT
//
// MessageText:
//
// The system detected that network adapter %2 was disconnected from the network
// and its network configuration has been released. If the network adapter was
// not disconnected, this may indicate that it has malfunctioned.
// Try updating the driver for the network adapter.
//
#define EVENT_TCPIP_MEDIA_DISCONNECT     0x4000106AL

//
// MessageId: EVENT_TCPIP_IPV4_UNINSTALLED
//
// MessageText:
//
// The system detected that IPv4 is not installed.  This may cause some
// networking services to fail to start, or to malfunction.  To install IPv4, use
// "netsh interface ipv4 install".
//
#define EVENT_TCPIP_IPV4_UNINSTALLED     0x4000106BL

//
// MessageId: EVENT_TCPIP_AUTOCONFIGURED_ADDRESS_LIMIT_REACHED
//
// MessageText:
//
// Autoconfigured address limit has been reached. No further autoconfigured addresses will be added until the interface is reconnected.
//
#define EVENT_TCPIP_AUTOCONFIGURED_ADDRESS_LIMIT_REACHED 0x8000106CL

//
// MessageId: EVENT_TCPIP_AUTOCONFIGURED_ROUTE_LIMIT_REACHED
//
// MessageText:
//
// Autoconfigured route limit has been reached. No further autoconfigured routes will be added until the interface is reconnected.
//
#define EVENT_TCPIP_AUTOCONFIGURED_ROUTE_LIMIT_REACHED 0x8000106DL

//
// MessageId: EVENT_TCPIP_OUT_OF_ORDER_FRAGMENTS_EXCEEDED
//
// MessageText:
//
// More than the supported number of out of order IP fragments were received. One or
// more fragmented IP packets were dropped as a result.
//
#define EVENT_TCPIP_OUT_OF_ORDER_FRAGMENTS_EXCEEDED 0x8000106EL

//
// MessageId: EVENT_TCPIP_INTERFACE_BIND_FAILURE
//
// MessageText:
//
// The %2 TCP/IP interface with index %3 failed to bind to its provider.
//
#define EVENT_TCPIP_INTERFACE_BIND_FAILURE 0xC000106FL


//
// TCP messages
//
// Codes 4225 - 4264
//

//
// MessageId: EVENT_TCPIP_TCP_INIT_FAILED
//
// MessageText:
//
// Initialization of TCP/UDP failed.
//
#define EVENT_TCPIP_TCP_INIT_FAILED      0xC0001081L

//
// MessageId: EVENT_TCPIP_TCP_CONNECT_LIMIT_REACHED
//
// MessageText:
//
// TCP/IP has reached the security limit imposed on the number of concurrent TCP connect attempts.
//
#define EVENT_TCPIP_TCP_CONNECT_LIMIT_REACHED 0x80001082L

//
// MessageId: EVENT_TCPIP_TCP_TIME_WAIT_COLLISION
//
// MessageText:
//
// TCP/IP failed to establish an outgoing connection because the selected local endpoint
// was recently used to connect to the same remote endpoint. This error typically occurs
// when outgoing connections are opened and closed at a high rate, causing all available
// local ports to be used and forcing TCP/IP to reuse a local port for an outgoing connection.
// To minimize the risk of data corruption, the TCP/IP standard requires a minimum time period
// to elapse between successive connections from a given local endpoint to a given remote endpoint.
//
#define EVENT_TCPIP_TCP_TIME_WAIT_COLLISION 0x80001083L

//
// MessageId: EVENT_TCPIP_TCP_WSD_WS_RESTRICTED
//
// MessageText:
//
// TCP/IP has chosen to restrict the scale factor due to a network condition. 
// This could be related to a problem in a network device and will cause 
// degraded throughput.
//
#define EVENT_TCPIP_TCP_WSD_WS_RESTRICTED 0x80001084L

//
// MessageId: EVENT_TCPIP_TCP_MPP_ATTACKS_DETECTED
//
// MessageText:
//
// TCP/IP has detected high memory utilization and has terminated some existing connections to 
// maintain system stability.  
//
#define EVENT_TCPIP_TCP_MPP_ATTACKS_DETECTED 0x80001085L

//
// MessageId: EVENT_TCPIP_TCP_CONNECTIONS_PERF_IMPACTED
//
// MessageText:
//
// TCP/IP has chosen to restrict the congestion window for several connections due to a network condition. 
// This could be related to a problem in the TCP global or supplemental configuration and will cause 
// degraded throughput. 
//
#define EVENT_TCPIP_TCP_CONNECTIONS_PERF_IMPACTED 0x80001086L

//
// MessageId: EVENT_TCPIP_TCP_GLOBAL_EPHEMERAL_PORT_SPACE_EXHAUSTED
//
// MessageText:
//
// A request to allocate an ephemeral port number from the global TCP port space has failed due to all such ports being in use.
//
#define EVENT_TCPIP_TCP_GLOBAL_EPHEMERAL_PORT_SPACE_EXHAUSTED 0x80001087L


//
// UDP messages
//
// Codes 4265 - 4280
//

//
// MessageId: EVENT_TCPIP_UDP_LIMIT_REACHED
//
// MessageText:
//
// Backlog of pending datagram sends reached. Please increase the value of Tcpip\Parameters\DGMaxSendFree in the registry.
//
#define EVENT_TCPIP_UDP_LIMIT_REACHED    0x800010A9L

//
// MessageId: EVENT_TCPIP_UDP_GLOBAL_EPHEMERAL_PORT_SPACE_EXHAUSTED
//
// MessageText:
//
// A request to allocate an ephemeral port number from the global UDP port space has failed due to all such ports being in use.
//
#define EVENT_TCPIP_UDP_GLOBAL_EPHEMERAL_PORT_SPACE_EXHAUSTED 0x800010AAL


//
// Packet Coalesing Filter messages
//
// Codes 4290 - 4299
//

//
// MessageId: EVENT_TCPIP_PCF_MULTICAST_OID_ISSUE
//
// MessageText:
//
// Multicast address list could not be set on the network adapter with hardware address %2 (%3 %4 %5 %6).
//
#define EVENT_TCPIP_PCF_MULTICAST_OID_ISSUE 0x800010C2L

//
// MessageId: EVENT_TCPIP_PCF_MISSING_CAPABILITY
//
// MessageText:
//
// The network adapter with hardware address %2 has indicated packet coalescing capability
// without indicating support for one or more prerequisite receive filter capabilities (%3 %4).
//
#define EVENT_TCPIP_PCF_MISSING_CAPABILITY 0x800010C3L

//
// MessageId: EVENT_TCPIP_PCF_SET_FILTER_FAILURE
//
// MessageText:
//
// An attempt to set a packet coalescing filter on the network adapter with hardware address %2 has failed (%3 %4 %5).
//
#define EVENT_TCPIP_PCF_SET_FILTER_FAILURE 0x800010C4L

//
// MessageId: EVENT_TCPIP_PCF_NO_ARP_FILTER
//
// MessageText:
//
// The ARP packet coalescing filter on the network adapter with hardware address %2 is not set
// since more than one IPv4 address is currently assigned to the adapter. An ARP packet coalescing
// filter may be set later when only one IPv4 address is assigned to this adapter (%3 %4).
//
#define EVENT_TCPIP_PCF_NO_ARP_FILTER    0x800010C5L

//
// MessageId: EVENT_TCPIP_PCF_CLEAR_FILTER_FAILURE
//
// MessageText:
//
// An attempt to clear a packet coalescing filter on the network adapter with hardware address %2 has failed (%3 %4 %5).
//
#define EVENT_TCPIP_PCF_CLEAR_FILTER_FAILURE 0xC00010C6L



/////////////////////////////////////////////////////////////////////////
//
// NBT Events
//
// Codes 4300 - 4399
//
/////////////////////////////////////////////////////////////////////////



// Don't use %1 for driver supplied insertion strings.  The IO subsystem
// supplies the first string!!

//
// MessageId: EVENT_NBT_CREATE_DRIVER
//
// MessageText:
//
// The driver could not be created.
//
#define EVENT_NBT_CREATE_DRIVER          0xC00010CCL

//
// MessageId: EVENT_NBT_OPEN_REG_PARAMS
//
// MessageText:
//
// Unable to open the Registry Parameters to read configuration information.
//
#define EVENT_NBT_OPEN_REG_PARAMS        0xC00010CDL

//
// MessageId: EVENT_NBT_NO_BACKUP_WINS
//
// MessageText:
//
// The backup WINS server address is not configured in the registry.
//
#define EVENT_NBT_NO_BACKUP_WINS         0x800010CEL

//
// MessageId: EVENT_NBT_NO_WINS
//
// MessageText:
//
// The primary WINS server address is not configured in the registry.
//
#define EVENT_NBT_NO_WINS                0x800010CFL

//
// MessageId: EVENT_NBT_BAD_BACKUP_WINS_ADDR
//
// MessageText:
//
// The backup WINS server address is not formated correctly in the registry.
//
#define EVENT_NBT_BAD_BACKUP_WINS_ADDR   0x800010D0L

//
// MessageId: EVENT_NBT_BAD_PRIMARY_WINS_ADDR
//
// MessageText:
//
// The primary WINS server address is not formatted correctly in the registry.
//
#define EVENT_NBT_BAD_PRIMARY_WINS_ADDR  0x800010D1L

//
// MessageId: EVENT_NBT_NAME_SERVER_ADDRS
//
// MessageText:
//
// Unable to configure the addresses of the WINS servers.
//
#define EVENT_NBT_NAME_SERVER_ADDRS      0xC00010D2L

//
// MessageId: EVENT_NBT_CREATE_ADDRESS
//
// MessageText:
//
// Initialization failed because the transport refused to open initial addresses.
//
#define EVENT_NBT_CREATE_ADDRESS         0xC00010D3L

//
// MessageId: EVENT_NBT_CREATE_CONNECTION
//
// MessageText:
//
// Initialization failed because the transport refused to open initial connections.
//
#define EVENT_NBT_CREATE_CONNECTION      0xC00010D4L

//
// MessageId: EVENT_NBT_NON_OS_INIT
//
// MessageText:
//
// Data structure initialization failed.
//
#define EVENT_NBT_NON_OS_INIT            0xC00010D5L

//
// MessageId: EVENT_NBT_TIMERS
//
// MessageText:
//
// Initialization failed because the timers could not be started.
//
#define EVENT_NBT_TIMERS                 0xC00010D6L

//
// MessageId: EVENT_NBT_CREATE_DEVICE
//
// MessageText:
//
// Initialization failed because the driver device could not be created.
// Use the string "%2" to identify the interface for which initialization
// failed. It represents the MAC address of the failed interface or the 
// Globally Unique Interface Identifier (GUID) if NetBT was unable to 
// map from GUID to MAC address. If neither the MAC address nor the GUID were 
// available, the string represents a cluster device name.
// 
//
#define EVENT_NBT_CREATE_DEVICE          0xC00010D7L

//
// MessageId: EVENT_NBT_NO_DEVICES
//
// MessageText:
//
// There are no network adapters configured for this protocol stack.
//
#define EVENT_NBT_NO_DEVICES             0x800010D8L

//
// MessageId: EVENT_NBT_OPEN_REG_LINKAGE
//
// MessageText:
//
// Unable to open the Registry Linkage to read configuration information.
//
#define EVENT_NBT_OPEN_REG_LINKAGE       0xC00010D9L

//
// MessageId: EVENT_NBT_READ_BIND
//
// MessageText:
//
// Unable to read the driver's bindings to the transport from the registry.
//
#define EVENT_NBT_READ_BIND              0xC00010DAL

//
// MessageId: EVENT_NBT_READ_EXPORT
//
// MessageText:
//
// Unable to read the driver's exported linkage configuration information.
//
#define EVENT_NBT_READ_EXPORT            0xC00010DBL

//
// MessageId: EVENT_NBT_OPEN_REG_NAMESERVER
//
// MessageText:
//
// Unable to open the registry to read the WINS server addresses.
//
#define EVENT_NBT_OPEN_REG_NAMESERVER    0x800010DCL

//
// MessageId: EVENT_SCOPE_LABEL_TOO_LONG
//
// MessageText:
//
// The Netbios Name Scope has a component longer than 63 characters. Each label
// in the Scope cannot be longer than 63 bytes.
//
#define EVENT_SCOPE_LABEL_TOO_LONG       0x800010DDL

//
// MessageId: EVENT_SCOPE_TOO_LONG
//
// MessageText:
//
// The Netbios Name Scope is too long. The scope cannot be longer than
// 255 bytes.
//
#define EVENT_SCOPE_TOO_LONG             0x800010DEL

//
// MessageId: EVENT_NBT_DUPLICATE_NAME
//
// MessageText:
//
// A duplicate name has been detected on the TCP network.  The IP address of
// the computer that sent the message is in the data. Use nbtstat -n in a
// command window to see which name is in the Conflict state.
//
#define EVENT_NBT_DUPLICATE_NAME         0xC00010DFL

//
// MessageId: EVENT_NBT_NAME_RELEASE
//
// MessageText:
//
// Another computer has sent a name release message to this computer, probably
// because a duplicate name has been detected on the TCP network.  The IP address
// of the node that sent the message is in the data. Use nbtstat -n in a
// command window to see which name is in the Conflict state.
//
#define EVENT_NBT_NAME_RELEASE           0xC00010E0L

//
// MessageId: EVENT_NBT_DUPLICATE_NAME_ERROR
//
// MessageText:
//
// The name "%2" could not be registered on the interface with IP address %3.
// The computer with the IP address %4 did not allow the name to be claimed by
// this computer.
//
#define EVENT_NBT_DUPLICATE_NAME_ERROR   0xC00010E1L

//
// MessageId: EVENT_NBT_NO_RESOURCES
//
// MessageText:
//
// NetBT failed to process a request because it encountered OutOfResources
// exception(s) in the last 1 hour.
//
#define EVENT_NBT_NO_RESOURCES           0xC00010E2L


/////////////////////////////////////////////////////////////////////////
//
// NDIS Environment Events
//
// Codes 5000 - 5099
//
/////////////////////////////////////////////////////////////////////////


//
// MessageId: EVENT_NDIS_RESOURCE_CONFLICT
//
// MessageText:
//
// %2 : Has encountered a conflict in resources and could not load.
//
#define EVENT_NDIS_RESOURCE_CONFLICT     0xC0001388L

//
// MessageId: EVENT_NDIS_OUT_OF_RESOURCE
//
// MessageText:
//
// %2 : Could not allocate the resources necessary for operation.
//
#define EVENT_NDIS_OUT_OF_RESOURCE       0xC0001389L

//
// MessageId: EVENT_NDIS_HARDWARE_FAILURE
//
// MessageText:
//
// %2 : Has determined that the network adapter is not functioning properly.
//
#define EVENT_NDIS_HARDWARE_FAILURE      0xC000138AL

//
// MessageId: EVENT_NDIS_ADAPTER_NOT_FOUND
//
// MessageText:
//
// %2 : Could not find a network adapter.
//
#define EVENT_NDIS_ADAPTER_NOT_FOUND     0xC000138BL

//
// MessageId: EVENT_NDIS_INTERRUPT_CONNECT
//
// MessageText:
//
// %2 : Could not connect to the interrupt number supplied.
//
#define EVENT_NDIS_INTERRUPT_CONNECT     0xC000138CL

//
// MessageId: EVENT_NDIS_DRIVER_FAILURE
//
// MessageText:
//
// %2 : Has encountered an internal error and has failed.
//
#define EVENT_NDIS_DRIVER_FAILURE        0xC000138DL

//
// MessageId: EVENT_NDIS_BAD_VERSION
//
// MessageText:
//
// %2 : The version number is incorrect for this driver.
//
#define EVENT_NDIS_BAD_VERSION           0xC000138EL

//
// MessageId: EVENT_NDIS_TIMEOUT
//
// MessageText:
//
// %2 : Timed out during an operation.
//
#define EVENT_NDIS_TIMEOUT               0x8000138FL

//
// MessageId: EVENT_NDIS_NETWORK_ADDRESS
//
// MessageText:
//
// %2 : Has encountered an invalid network address.
//
#define EVENT_NDIS_NETWORK_ADDRESS       0xC0001390L

//
// MessageId: EVENT_NDIS_UNSUPPORTED_CONFIGURATION
//
// MessageText:
//
// %2 : Does not support the configuration supplied.
//
#define EVENT_NDIS_UNSUPPORTED_CONFIGURATION 0xC0001391L

//
// MessageId: EVENT_NDIS_INVALID_VALUE_FROM_ADAPTER
//
// MessageText:
//
// %2 : The network adapter has returned an invalid value to the driver.
//
#define EVENT_NDIS_INVALID_VALUE_FROM_ADAPTER 0xC0001392L

//
// MessageId: EVENT_NDIS_MISSING_CONFIGURATION_PARAMETER
//
// MessageText:
//
// %2 : A required parameter is missing from the registry.
//
#define EVENT_NDIS_MISSING_CONFIGURATION_PARAMETER 0xC0001393L

//
// MessageId: EVENT_NDIS_BAD_IO_BASE_ADDRESS
//
// MessageText:
//
// %2 : The I/O base address supplied does not match the jumpers on the adapter.
//
#define EVENT_NDIS_BAD_IO_BASE_ADDRESS   0xC0001394L

//
// MessageId: EVENT_NDIS_RECEIVE_SPACE_SMALL
//
// MessageText:
//
// %2 : The adapter is configured such that the receive space is smaller than
// the maximum packet size.  Some packets may be lost.
//
#define EVENT_NDIS_RECEIVE_SPACE_SMALL   0x40001395L

//
// MessageId: EVENT_NDIS_ADAPTER_DISABLED
//
// MessageText:
//
// %2 : The driver cannot function because the network adapter is disabled.
//
#define EVENT_NDIS_ADAPTER_DISABLED      0x80001396L

//
// MessageId: EVENT_NDIS_IO_PORT_CONFLICT
//
// MessageText:
//
// %2 : There is an I/O port conflict.
//
#define EVENT_NDIS_IO_PORT_CONFLICT      0x80001397L

//
// MessageId: EVENT_NDIS_PORT_OR_DMA_CONFLICT
//
// MessageText:
//
// %2 : There is an I/O port or DMA channel conflict.
//
#define EVENT_NDIS_PORT_OR_DMA_CONFLICT  0x80001398L

//
// MessageId: EVENT_NDIS_MEMORY_CONFLICT
//
// MessageText:
//
// %2 : There is a memory conflict at address 0x%3.
//
#define EVENT_NDIS_MEMORY_CONFLICT       0x80001399L

//
// MessageId: EVENT_NDIS_INTERRUPT_CONFLICT
//
// MessageText:
//
// %2 : There is a interrupt conflict at Interrupt %3.
//
#define EVENT_NDIS_INTERRUPT_CONFLICT    0x8000139AL

//
// MessageId: EVENT_NDIS_DMA_CONFLICT
//
// MessageText:
//
// %2 : There is a resource conflict at DMA channel %3.
//
#define EVENT_NDIS_DMA_CONFLICT          0x8000139BL

//
// MessageId: EVENT_NDIS_INVALID_DOWNLOAD_FILE_ERROR
//
// MessageText:
//
// %2 : The download file is invalid.  The driver is unable to load.
//
#define EVENT_NDIS_INVALID_DOWNLOAD_FILE_ERROR 0xC000139CL

//
// MessageId: EVENT_NDIS_MAXRECEIVES_ERROR
//
// MessageText:
//
// %2 : The specified registry entry MaxReceives is out of range. Using 
// default value.
//
#define EVENT_NDIS_MAXRECEIVES_ERROR     0x8000139DL

//
// MessageId: EVENT_NDIS_MAXTRANSMITS_ERROR
//
// MessageText:
//
// %2 : The specified registry entry MaxTransmits is out of range. Using 
// default value
//
#define EVENT_NDIS_MAXTRANSMITS_ERROR    0x8000139EL

//
// MessageId: EVENT_NDIS_MAXFRAMESIZE_ERROR
//
// MessageText:
//
// %2 : The specified registry entry MaxFrameSize is out of range. Using 
// default value.
//
#define EVENT_NDIS_MAXFRAMESIZE_ERROR    0x8000139FL

//
// MessageId: EVENT_NDIS_MAXINTERNALBUFS_ERROR
//
// MessageText:
//
// %2 : The specified registry entry MaxInternalBufs is out of range. Using 
// default value.
//
#define EVENT_NDIS_MAXINTERNALBUFS_ERROR 0x800013A0L

//
// MessageId: EVENT_NDIS_MAXMULTICAST_ERROR
//
// MessageText:
//
// %2 : The specified registry entry MaxMulticast is out of range. Using 
// default value.
//
#define EVENT_NDIS_MAXMULTICAST_ERROR    0x800013A1L

//
// MessageId: EVENT_NDIS_PRODUCTID_ERROR
//
// MessageText:
//
// %2 : The specified registry entry ProductId is out of range. Using 
// default value.
//
#define EVENT_NDIS_PRODUCTID_ERROR       0x800013A2L

//
// MessageId: EVENT_NDIS_LOBE_FAILUE_ERROR
//
// MessageText:
//
// %2 : A Token Ring Lobe Wire Fault has occurred. Verify cable connections. 
// The network adapter will continue to try to reinsert into the ring.
//
#define EVENT_NDIS_LOBE_FAILUE_ERROR     0x800013A3L

//
// MessageId: EVENT_NDIS_SIGNAL_LOSS_ERROR
//
// MessageText:
//
// %2 : The adapter had detected a loss of signal on the ring.  The adapter
// will continue to try to reinsert back into the ring.
//
#define EVENT_NDIS_SIGNAL_LOSS_ERROR     0x800013A4L

//
// MessageId: EVENT_NDIS_REMOVE_RECEIVED_ERROR
//
// MessageText:
//
// %2 : The adapter has received a request to deinsert from the
// ring.  The adapter will continue to try to reinsert back into the ring.
//
#define EVENT_NDIS_REMOVE_RECEIVED_ERROR 0x800013A5L

//
// MessageId: EVENT_NDIS_TOKEN_RING_CORRECTION
//
// MessageText:
//
// %2 : The network adapter has successfully reinserted into the ring.
//
#define EVENT_NDIS_TOKEN_RING_CORRECTION 0x400013A6L

//
// MessageId: EVENT_NDIS_ADAPTER_CHECK_ERROR
//
// MessageText:
//
// %2 : The network adapter has detected an Adapter Check as a result of 
// an unrecoverable hardware or software error.
//
#define EVENT_NDIS_ADAPTER_CHECK_ERROR   0xC00013A7L

//
// MessageId: EVENT_NDIS_RESET_FAILURE_ERROR
//
// MessageText:
//
// %2 : The network adapter failed to reset within a specified time, which could 
// be caused by a hardware failure. The network adapter will continue to try to reset.
//
#define EVENT_NDIS_RESET_FAILURE_ERROR   0x800013A8L

//
// MessageId: EVENT_NDIS_CABLE_DISCONNECTED_ERROR
//
// MessageText:
//
// %2 : The network adapter has detected that the token ring cable is disconnected 
// from the network adapter. Please reconnect the cable.
//
#define EVENT_NDIS_CABLE_DISCONNECTED_ERROR 0x800013A9L

//
// MessageId: EVENT_NDIS_RESET_FAILURE_CORRECTION
//
// MessageText:
//
// %2 : The network adapter has successfully completed a previously failed reset.
//
#define EVENT_NDIS_RESET_FAILURE_CORRECTION 0x800013AAL


/////////////////////////////////////////////////////////////////////////
//
// General NT System Events
//
/////////////////////////////////////////////////////////////////////////

//
// Eventlog Events 6000 - 6099
//
//
// MessageId: EVENT_EventlogStarted
//
// MessageText:
//
// The Event log service was started.
//
#define EVENT_EventlogStarted            0x80001775L

//
// MessageId: EVENT_EventlogStopped
//
// MessageText:
//
// The Event log service was stopped.
//
#define EVENT_EventlogStopped            0x80001776L

//
// MessageId: EVENT_EventlogAbnormalShutdown
//
// MessageText:
//
// The previous system shutdown at %1 on %2 was unexpected.
//
#define EVENT_EventlogAbnormalShutdown   0x80001778L

//
// MessageId: EVENT_EventLogProductInfo
//
// MessageText:
//
// Microsoft (R) Windows (R) %1 %2 %3 %4.
//
#define EVENT_EventLogProductInfo        0x80001779L

//
// MessageId: EVENT_ComputerNameChange
//
// MessageText:
//
// The NetBIOS name and DNS host name of this machine have been changed from %1 to %2.
//
#define EVENT_ComputerNameChange         0x8000177BL

//
// MessageId: EVENT_DNSDomainNameChange
//
// MessageText:
//
// The DNS domain assigned to this computer has been changed from %1 to %2.
//
#define EVENT_DNSDomainNameChange        0x8000177CL

//
// MessageId: EVENT_EventlogUptime
//
// MessageText:
//
// The system uptime is %5 seconds.
//
#define EVENT_EventlogUptime             0x8000177DL

//
// System Events 6100 - 6199
//
//
// MessageId: EVENT_UP_DRIVER_ON_MP
//
// MessageText:
//
// A uniprocessor-specific driver was loaded on a multiprocessor system.  The driver could not load.
//
#define EVENT_UP_DRIVER_ON_MP            0xC00017D4L

//
// Service Controller Events 7000 - 7899
//
// IMPORTANT NOTE: Do not add any new Vista+ SCM events in netevent.mc, please add those to base\screg\sc\manifests\services.man which contains
// Crimson-friendly event definitions. The SCM events defined here are not used by the eventvwr MMC snapin but continue to remain here due to
// few components depending on the definition (test code, tools code, etc.)
//
//
// MessageId: EVENT_SERVICE_START_FAILED
//
// MessageText:
//
// The %1 service failed to start due to the following error: %n%2
//
#define EVENT_SERVICE_START_FAILED       0xC0001B58L

//
// MessageId: EVENT_SERVICE_START_FAILED_II
//
// MessageText:
//
// The %1 service depends on the %2 service which failed to start because of the following error: %n%3
//
#define EVENT_SERVICE_START_FAILED_II    0xC0001B59L

//
// MessageId: EVENT_SERVICE_START_FAILED_GROUP
//
// MessageText:
//
// The %1 service depends on the %2 group and no member of this group started.
//
#define EVENT_SERVICE_START_FAILED_GROUP 0xC0001B5AL

//
// MessageId: EVENT_SERVICE_START_FAILED_NONE
//
// MessageText:
//
// The %1 service depends on the following nonexistent service: %2
//
#define EVENT_SERVICE_START_FAILED_NONE  0xC0001B5BL

//
// MessageId: EVENT_CALL_TO_FUNCTION_FAILED
//
// MessageText:
//
// The %1 call failed with the following error: %n%2
//
#define EVENT_CALL_TO_FUNCTION_FAILED    0xC0001B5DL

//
// MessageId: EVENT_CALL_TO_FUNCTION_FAILED_II
//
// MessageText:
//
// The %1 call failed for %2 with the following error: %n%3
//
#define EVENT_CALL_TO_FUNCTION_FAILED_II 0xC0001B5EL

//
// MessageId: EVENT_REVERTED_TO_LASTKNOWNGOOD
//
// MessageText:
//
// The system reverted to its last known good configuration.  The system is restarting....
//
#define EVENT_REVERTED_TO_LASTKNOWNGOOD  0xC0001B5FL

//
// MessageId: EVENT_BAD_ACCOUNT_NAME
//
// MessageText:
//
// No backslash is in the account name.
//
#define EVENT_BAD_ACCOUNT_NAME           0xC0001B60L

//
// MessageId: EVENT_CONNECTION_TIMEOUT
//
// MessageText:
//
// Timeout (%1 milliseconds) waiting for the %2 service to connect.
//
#define EVENT_CONNECTION_TIMEOUT         0xC0001B61L

//
// MessageId: EVENT_READFILE_TIMEOUT
//
// MessageText:
//
// Timeout (%1 milliseconds) waiting for ReadFile.
//
#define EVENT_READFILE_TIMEOUT           0xC0001B62L

//
// MessageId: EVENT_TRANSACT_TIMEOUT
//
// MessageText:
//
// Timeout (%1 milliseconds) waiting for a transaction response from the %2 service.
//
#define EVENT_TRANSACT_TIMEOUT           0xC0001B63L

//
// MessageId: EVENT_TRANSACT_INVALID
//
// MessageText:
//
// Message returned in transaction has incorrect size.
//
#define EVENT_TRANSACT_INVALID           0xC0001B64L

//
// MessageId: EVENT_FIRST_LOGON_FAILED
//
// MessageText:
//
// Logon attempt with current password failed with the following error: %n%1
//
#define EVENT_FIRST_LOGON_FAILED         0xC0001B65L

//
// MessageId: EVENT_SECOND_LOGON_FAILED
//
// MessageText:
//
// Second logon attempt with old password also failed with the following error: %n%1
//
#define EVENT_SECOND_LOGON_FAILED        0xC0001B66L

//
// MessageId: EVENT_INVALID_DRIVER_DEPENDENCY
//
// MessageText:
//
// Boot-start or system-start driver (%1) must not depend on a service.
//
#define EVENT_INVALID_DRIVER_DEPENDENCY  0xC0001B67L

//
// MessageId: EVENT_BAD_SERVICE_STATE
//
// MessageText:
//
// The %1 service has reported an invalid current state %2.
//
#define EVENT_BAD_SERVICE_STATE          0xC0001B68L

//
// MessageId: EVENT_CIRCULAR_DEPENDENCY_DEMAND
//
// MessageText:
//
// Detected circular dependencies demand starting %1.
//
#define EVENT_CIRCULAR_DEPENDENCY_DEMAND 0xC0001B69L

//
// MessageId: EVENT_CIRCULAR_DEPENDENCY_AUTO
//
// MessageText:
//
// Detected circular dependencies auto-starting services.
//
#define EVENT_CIRCULAR_DEPENDENCY_AUTO   0xC0001B6AL

//
// MessageId: EVENT_DEPEND_ON_LATER_SERVICE
//
// MessageText:
//
// Circular dependency: The %1 service depends on a service in a group which starts later.
//
#define EVENT_DEPEND_ON_LATER_SERVICE    0xC0001B6BL

//
// MessageId: EVENT_DEPEND_ON_LATER_GROUP
//
// MessageText:
//
// Circular dependency: The %1 service depends on a group which starts later.
//
#define EVENT_DEPEND_ON_LATER_GROUP      0xC0001B6CL

//
// MessageId: EVENT_SEVERE_SERVICE_FAILED
//
// MessageText:
//
// About to revert to the last known good configuration because the %1 service failed to start.
//
#define EVENT_SEVERE_SERVICE_FAILED      0xC0001B6DL

//
// MessageId: EVENT_SERVICE_START_HUNG
//
// MessageText:
//
// The %1 service hung on starting.
//
#define EVENT_SERVICE_START_HUNG         0xC0001B6EL

//
// MessageId: EVENT_SERVICE_EXIT_FAILED
//
// MessageText:
//
// The %1 service terminated with the following error: %n%2
//
#define EVENT_SERVICE_EXIT_FAILED        0xC0001B6FL

//
// MessageId: EVENT_SERVICE_EXIT_FAILED_SPECIFIC
//
// MessageText:
//
// The %1 service terminated with service-specific error %2.
//
#define EVENT_SERVICE_EXIT_FAILED_SPECIFIC 0xC0001B70L

//
// MessageId: EVENT_SERVICE_START_AT_BOOT_FAILED
//
// MessageText:
//
// At least one service or driver failed during system startup.  Use Event Viewer to examine the event log for details.
//
#define EVENT_SERVICE_START_AT_BOOT_FAILED 0xC0001B71L

//
// MessageId: EVENT_BOOT_SYSTEM_DRIVERS_FAILED
//
// MessageText:
//
// The following boot-start or system-start driver(s) failed to load: %1
//
#define EVENT_BOOT_SYSTEM_DRIVERS_FAILED 0xC0001B72L

//
// MessageId: EVENT_RUNNING_LASTKNOWNGOOD
//
// MessageText:
//
// Windows could not be started as configured.  A previous working configuration was used instead.
//
#define EVENT_RUNNING_LASTKNOWNGOOD      0xC0001B73L

//
// MessageId: EVENT_TAKE_OWNERSHIP
//
// MessageText:
//
// The %1 Registry key denied access to SYSTEM account programs so the Service Control Manager took ownership of the Registry key.
//
#define EVENT_TAKE_OWNERSHIP             0xC0001B74L

//
// This Text is used as a title for the message box used to display
// MessageId 7027.  It is not an event or error message.
//
//
// MessageId: TITLE_SC_MESSAGE_BOX
//
// MessageText:
//
// Service Control Manager %0
//
#define TITLE_SC_MESSAGE_BOX             0xC0001B75L

//
// MessageId: EVENT_SERVICE_NOT_INTERACTIVE
//
// MessageText:
//
// The %1 service is marked as an interactive service.  However, the system is configured to not allow interactive services.  This service may not function properly.
//
#define EVENT_SERVICE_NOT_INTERACTIVE    0xC0001B76L

//
// Parameter %4 is the value, in decimal, of the SC_ACTION_ constant for
// the action described in parameter %5.
//
//
// MessageId: EVENT_SERVICE_CRASH
//
// MessageText:
//
// The %1 service terminated unexpectedly.  It has done this %2 time(s).  The following corrective action will be taken in %3 milliseconds: %5.
//
#define EVENT_SERVICE_CRASH              0xC0001B77L

//
// Parameter %1 is the value, in decimal, of the SC_ACTION_ constant for
// the action described in parameter %2.
//
//
// MessageId: EVENT_SERVICE_RECOVERY_FAILED
//
// MessageText:
//
// The Service Control Manager tried to take a corrective action (%2) after the unexpected termination of the %3 service, but this action failed with the following error: %n%4
//
#define EVENT_SERVICE_RECOVERY_FAILED    0xC0001B78L

//
// MessageId: EVENT_SERVICE_SCESRV_FAILED
//
// MessageText:
//
// The Service Control Manager did not initialize successfully. The security
// configuration server (scesrv.dll) failed to initialize with error %1.  The
// system is restarting...
//
#define EVENT_SERVICE_SCESRV_FAILED      0xC0001B79L

//
// MessageId: EVENT_SERVICE_CRASH_NO_ACTION
//
// MessageText:
//
// The %1 service terminated unexpectedly.  It has done this %2 time(s).
//
#define EVENT_SERVICE_CRASH_NO_ACTION    0xC0001B7AL

//
// Parameter %2 is the string name of the control
//
//
// MessageId: EVENT_SERVICE_CONTROL_SUCCESS
//
// MessageText:
//
// The %1 service was successfully sent a %2 control.
//
#define EVENT_SERVICE_CONTROL_SUCCESS    0x40001B7BL

//
// Parameter %2 is the string name of the control
//
//
// MessageId: EVENT_SERVICE_STATUS_SUCCESS
//
// MessageText:
//
// The %1 service entered the %2 state.
//
#define EVENT_SERVICE_STATUS_SUCCESS     0x40001B7CL

//
// MessageId: EVENT_SERVICE_CONFIG_BACKOUT_FAILED
//
// MessageText:
//
// The Service Control Manager encountered an error undoing a configuration change
// to the %1 service.  The service's %2 is currently in an unpredictable state.
// 
// If you do not correct this configuration, you may not be able to restart the %1
// service or may encounter other errors.  To ensure that the service is configured
// properly, use the Services snap-in in Microsoft Management Console (MMC).
//
#define EVENT_SERVICE_CONFIG_BACKOUT_FAILED 0xC0001B7DL

//
// MessageId: EVENT_FIRST_LOGON_FAILED_II
//
// MessageText:
//
// The %1 service was unable to log on as %2 with the currently configured
// password due to the following error: %n%3%n%nTo ensure that the service is
// configured properly, use the Services snap-in in Microsoft Management
// Console (MMC).
//
#define EVENT_FIRST_LOGON_FAILED_II      0xC0001B7EL

//
// MessageId: EVENT_SERVICE_DIFFERENT_PID_CONNECTED
//
// MessageText:
//
// A service process other than the one launched by the Service Control Manager
// connected when starting the %1 service.  The Service Control Manager launched
// process %2 and process %3 connected instead.%n%n
// 
// Note that if this service is configured to start under a debugger, this behavior
// is expected.
//
#define EVENT_SERVICE_DIFFERENT_PID_CONNECTED 0x80001B7FL

//
// MessageId: EVENT_SERVICE_START_TYPE_CHANGED
//
// MessageText:
//
// The start type of the %1 service was changed from %2 to %3.
//
#define EVENT_SERVICE_START_TYPE_CHANGED 0x40001B80L

//
// MessageId: EVENT_SERVICE_LOGON_TYPE_NOT_GRANTED
//
// MessageText:
//
// The %1 service was unable to log on as %2 with the currently configured
// password due to the following error:
// %nLogon failure: the user has not been granted the requested logon type at this
// computer.%n
// %nService: %1
// %nDomain and account: %2%n
// %nThis service account does not have the necessary user right "Log on as a service."%n
// %nUser Action%n
// %nAssign "Log on as a service" to the service account on this computer. You can
// use Local Security Settings (Secpol.msc) to do this. If this computer is a
// node in a cluster, check that this user right is assigned to the Cluster
// service account on all nodes in the cluster.%n
// %nIf you have already assigned this user right to the service account, and the
// user right appears to be removed, a Group Policy object associated with this
// node might be removing the right. Check with your domain administrator to find
// out if this is happening.
//
#define EVENT_SERVICE_LOGON_TYPE_NOT_GRANTED 0xC0001B81L

//
// MessageId: EVENT_SERVICE_STOP_SUCCESS_WITH_REASON
//
// MessageText:
//
// The %1 service was successfully sent a %2 control.%n%n
// The reason specified was: %3 [%4]%n%n
// Comment: %5
//
#define EVENT_SERVICE_STOP_SUCCESS_WITH_REASON 0x40001B82L

//
// MessageId: EVENT_SERVICE_SHUTDOWN_FAILED
//
// MessageText:
//
// The %1 service did not shutdown properly after receiving a preshutdown control.
//
#define EVENT_SERVICE_SHUTDOWN_FAILED    0xC0001B83L

//
// IMPORTANT NOTE: Do not add any new Vista+ SCM events in netevent.mc, please add those to base\screg\sc\manifests\services.man which contains
// Crimson-friendly event definitions. The SCM events defined here are not used by the eventvwr MMC snapin but continue to remain here due to
// few components depending on the definition (test code, tools code, etc.)
//
//
// Schedule (AT command) Service Events 7900 - 7999
//
//
// MessageId: EVENT_COMMAND_NOT_INTERACTIVE
//
// MessageText:
//
// The %1 command is marked as an interactive command.  However, the system is
// configured to not allow interactive command execution.  This command may not
// function properly.
//
#define EVENT_COMMAND_NOT_INTERACTIVE    0xC0001EDCL

//
// MessageId: EVENT_COMMAND_START_FAILED
//
// MessageText:
//
// The %1 command failed to start due to the following error: %n%2
//
#define EVENT_COMMAND_START_FAILED       0xC0001EDDL


/////////////////////////////////////////////////////////////////////////
//
// Lanman Bowser/Browser Events (8000-8499)
//
//
/////////////////////////////////////////////////////////////////////////


//
// MessageId: EVENT_BOWSER_OTHER_MASTER_ON_NET
//
// MessageText:
//
// The master browser has received a server announcement from the computer %2
// that believes that it is the master browser for the domain on transport %3.
// The master browser is stopping or an election is being forced.
//
#define EVENT_BOWSER_OTHER_MASTER_ON_NET 0xC0001F43L

//
// MessageId: EVENT_BOWSER_PROMOTED_WHILE_ALREADY_MASTER
//
// MessageText:
//
// A request has been submitted to promote the computer to backup when it is already a
// master browser.
//
#define EVENT_BOWSER_PROMOTED_WHILE_ALREADY_MASTER 0x80001F44L

//
// MessageId: EVENT_BOWSER_NON_MASTER_MASTER_ANNOUNCE
//
// MessageText:
//
// The browser has received a server announcement indicating that the computer %2
// is a master browser, but this computer is not a master browser.
//
#define EVENT_BOWSER_NON_MASTER_MASTER_ANNOUNCE 0x80001F45L

//
// MessageId: EVENT_BOWSER_ILLEGAL_DATAGRAM
//
// MessageText:
//
// The browser has received an illegal datagram from the remote computer %2 to name %3 on transport %4.  The data is the datagram.
//
#define EVENT_BOWSER_ILLEGAL_DATAGRAM    0x80001F46L

//
// MessageId: EVENT_BROWSER_STATUS_BITS_UPDATE_FAILED
//
// MessageText:
//
// The browser was unable to update the service status bits.  The data is the error.
//
#define EVENT_BROWSER_STATUS_BITS_UPDATE_FAILED 0xC0001F47L

//
// MessageId: EVENT_BROWSER_ROLE_CHANGE_FAILED
//
// MessageText:
//
// The browser was unable to update its role.  The data is the error.
//
#define EVENT_BROWSER_ROLE_CHANGE_FAILED 0xC0001F48L

//
// MessageId: EVENT_BROWSER_MASTER_PROMOTION_FAILED
//
// MessageText:
//
// The browser was unable to promote itself to master browser.  The computer that currently
// believes it is the master browser is %1.
//
#define EVENT_BROWSER_MASTER_PROMOTION_FAILED 0xC0001F49L

//
// MessageId: EVENT_BOWSER_NAME_CONVERSION_FAILED
//
// MessageText:
//
// The browser driver was unable to convert a character string to a unicode string.
//
#define EVENT_BOWSER_NAME_CONVERSION_FAILED 0xC0001F4AL

//
// MessageId: EVENT_BROWSER_OTHERDOMAIN_ADD_FAILED
//
// MessageText:
//
// The browser was unable to add the configuration parameter %1.
//
#define EVENT_BROWSER_OTHERDOMAIN_ADD_FAILED 0xC0001F4BL

//
// MessageId: EVENT_BOWSER_ELECTION_RECEIVED
//
// MessageText:
//
// The browser driver has received an election packet from computer %2 on network %3.  The data is the packet received.
//
#define EVENT_BOWSER_ELECTION_RECEIVED   0x00001F4CL

//
// MessageId: EVENT_BOWSER_ELECTION_SENT_GETBLIST_FAILED
//
// MessageText:
//
// The browser driver has forced an election on network %2 because it was unable to find a master browser to retrieve a backup list on that network.
//
#define EVENT_BOWSER_ELECTION_SENT_GETBLIST_FAILED 0x40001F4DL

//
// MessageId: EVENT_BOWSER_ELECTION_SENT_FIND_MASTER_FAILED
//
// MessageText:
//
// The browser driver has forced an election on network %2 because it was unable to find a master browser for that network.
//
#define EVENT_BOWSER_ELECTION_SENT_FIND_MASTER_FAILED 0x40001F4EL

//
// MessageId: EVENT_BROWSER_ELECTION_SENT_LANMAN_NT_STARTED
//
// MessageText:
//
// The browser has forced an election on network %1 because a Windows Server (or domain master) browser is started.
//
#define EVENT_BROWSER_ELECTION_SENT_LANMAN_NT_STARTED 0x40001F4FL

//
// MessageId: EVENT_BOWSER_ILLEGAL_DATAGRAM_THRESHOLD
//
// MessageText:
//
// The browser driver has received too many illegal datagrams from the remote computer %2 to name %3 on transport %4.  The data is the datagram.
// No more events will be generated until the reset frequency has expired.
//
#define EVENT_BOWSER_ILLEGAL_DATAGRAM_THRESHOLD 0xC0001F50L

//
// MessageId: EVENT_BROWSER_DEPENDANT_SERVICE_FAILED
//
// MessageText:
//
// The browser has failed to start because the dependent service %1 had invalid service status %2.
// Status             Meaning
//   1              Service Stopped%n
//   2              Start Pending%n
//   3              Stop Pending%n
//   4              Running%n
//   5              Continue Pending%n
//   6              Pause Pending%n
//   7              Paused%n
//
#define EVENT_BROWSER_DEPENDANT_SERVICE_FAILED 0xC0001F51L

//
// MessageId: EVENT_BROWSER_MASTER_PROMOTION_FAILED_STOPPING
//
// MessageText:
//
// The browser was unable to promote itself to master browser.  The browser will continue
// to attempt to promote itself to the master browser, but will no longer log any events in the event log in Event Viewer.
//
#define EVENT_BROWSER_MASTER_PROMOTION_FAILED_STOPPING 0xC0001F53L

//
// MessageId: EVENT_BROWSER_MASTER_PROMOTION_FAILED_NO_MASTER
//
// MessageText:
//
// The browser was unable to promote itself to master browser.  The computer that currently
// believes it is the master browser is unknown.
//
#define EVENT_BROWSER_MASTER_PROMOTION_FAILED_NO_MASTER 0xC0001F54L

//
// MessageId: EVENT_BROWSER_SERVER_LIST_FAILED
//
// MessageText:
//
// The browser service was unable to retrieve a list of servers from the browser master %1 on the network %2.%n
// %n
// Browser master: %1%n
// Network: %2%n
// %n
// This event may be caused by a temporary loss of network connectivity. If this message appears again, verify that the server is still connected to the network. The return code is in the Data text box.
//
#define EVENT_BROWSER_SERVER_LIST_FAILED 0x80001F55L

//
// MessageId: EVENT_BROWSER_DOMAIN_LIST_FAILED
//
// MessageText:
//
// The browser service was unable to retrieve a list of domains from the browser master %1 on the network %2.%n
// %n
// Browser master: %1%n
// Network: %2%n
// %n
// This event may be caused by a temporary loss of network connectivity. If this message appears again, verify that the server is still connected to the network. The return code is in the Data text box.
//
#define EVENT_BROWSER_DOMAIN_LIST_FAILED 0x80001F56L

//
// MessageId: EVENT_BROWSER_ILLEGAL_CONFIG
//
// MessageText:
//
// The value for the parameter %1 to the browser service was illegal.
//
#define EVENT_BROWSER_ILLEGAL_CONFIG     0x80001F57L

//
// MessageId: EVENT_BOWSER_OLD_BACKUP_FOUND
//
// MessageText:
//
// The backup browser server %2 is out-of-date.  Consider upgrading this computer.
//
#define EVENT_BOWSER_OLD_BACKUP_FOUND    0x40001F58L

//
// MessageId: EVENT_BROWSER_SERVER_LIST_RETRIEVED
//
// MessageText:
//
// The browser has retrieved a list of servers from remote computer %1 on transport %2.%n
// There were %3 entries read, and %4 total entries.
//
#define EVENT_BROWSER_SERVER_LIST_RETRIEVED 0x00001F59L

//
// MessageId: EVENT_BROWSER_DOMAIN_LIST_RETRIEVED
//
// MessageText:
//
// The browser has retrieved a list of domains from remote computer %1 on transport %2.%n
// There were %3 entries read, and %4 total entries.
//
#define EVENT_BROWSER_DOMAIN_LIST_RETRIEVED 0x00001F5AL

//
// MessageId: EVENT_BOWSER_PDC_LOST_ELECTION
//
// MessageText:
//
// The browser running on the Domain Controller has lost an election.  The computer that won the election is %2, on the transport %3.%n
// The data contains the election version, election criteria, and remote computer time up, and the same information for
// the current computer.
//
#define EVENT_BOWSER_PDC_LOST_ELECTION   0x40001F5BL

//
// MessageId: EVENT_BOWSER_NON_PDC_WON_ELECTION
//
// MessageText:
//
// The browser running on this computer has won a browser election on network %2.
// This computer is a member of a domain, so the Domain Controller should become the master
// browser.
//
#define EVENT_BOWSER_NON_PDC_WON_ELECTION 0x40001F5CL

//
// MessageId: EVENT_BOWSER_CANT_READ_REGISTRY
//
// MessageText:
//
// The browser driver was unable to initialize variables from the Registry.
//
#define EVENT_BOWSER_CANT_READ_REGISTRY  0x40001F5DL

//
// MessageId: EVENT_BOWSER_MAILSLOT_DATAGRAM_THRESHOLD_EXCEEDED
//
// MessageText:
//
// The browser driver has discarded too many mailslot messages.
//
#define EVENT_BOWSER_MAILSLOT_DATAGRAM_THRESHOLD_EXCEEDED 0x40001F5EL

//
// MessageId: EVENT_BOWSER_GETBROWSERLIST_THRESHOLD_EXCEEDED
//
// MessageText:
//
// The browser driver has discarded too many GetBrowserServerList requests.
//
#define EVENT_BOWSER_GETBROWSERLIST_THRESHOLD_EXCEEDED 0x40001F5FL

//
// MessageId: EVENT_BROWSER_BACKUP_STOPPED
//
// MessageText:
//
// The browser service has failed to retrieve the backup list too many times on transport %1.
// The backup browser is stopping.
//
#define EVENT_BROWSER_BACKUP_STOPPED     0xC0001F60L

//
// MessageId: EVENT_BROWSER_ELECTION_SENT_LANMAN_NT_STOPPED
//
// MessageText:
//
// The browser has forced an election on network %1 because a master browser was stopped.
//
#define EVENT_BROWSER_ELECTION_SENT_LANMAN_NT_STOPPED 0x40001F61L

//
// MessageId: EVENT_BROWSER_GETBLIST_RECEIVED_NOT_MASTER
//
// MessageText:
//
// The browser has received a GetBrowserServerList request when it is not the master browser.
//
#define EVENT_BROWSER_GETBLIST_RECEIVED_NOT_MASTER 0xC0001F62L

//
// MessageId: EVENT_BROWSER_ELECTION_SENT_ROLE_CHANGED
//
// MessageText:
//
// The browser has forced an election on network %1 because the Domain Controller (or Server) has changed its role.
//
#define EVENT_BROWSER_ELECTION_SENT_ROLE_CHANGED 0x40001F63L

//
// MessageId: EVENT_BROWSER_NOT_STARTED_IPX_CONFIG_MISMATCH
//
// MessageText:
//
// The browser has failed to start because of an error in the DirectHostBinding parameter to the browser.
//
#define EVENT_BROWSER_NOT_STARTED_IPX_CONFIG_MISMATCH 0xC0001F64L


/////////////////////////////////////////////////////////////////////////
//
// Sap Agent Events (8500-8999)
//
//
/////////////////////////////////////////////////////////////////////////


//
// MessageId: NWSAP_EVENT_KEY_NOT_FOUND
//
// MessageText:
//
// The Registry Key %1 was not present.  The Sap Agent could not start.
//
#define NWSAP_EVENT_KEY_NOT_FOUND        0xC0002134L

//
// MessageId: NWSAP_EVENT_WSASTARTUP_FAILED
//
// MessageText:
//
// Winsock startup routine failed.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_WSASTARTUP_FAILED    0xC0002135L

//
// MessageId: NWSAP_EVENT_SOCKET_FAILED
//
// MessageText:
//
// Socket create call failed for main socket. The Sap Agent cannot continue.
//
#define NWSAP_EVENT_SOCKET_FAILED        0xC0002136L

//
// MessageId: NWSAP_EVENT_SETOPTBCAST_FAILED
//
// MessageText:
//
// Setting broadcast option on socket failed.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_SETOPTBCAST_FAILED   0xC0002137L

//
// MessageId: NWSAP_EVENT_BIND_FAILED
//
// MessageText:
//
// Binding to SAP Socket failed.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_BIND_FAILED          0xC0002138L

//
// MessageId: NWSAP_EVENT_GETSOCKNAME_FAILED
//
// MessageText:
//
// Getting bound address of socket failed.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_GETSOCKNAME_FAILED   0xC0002139L

//
// MessageId: NWSAP_EVENT_OPTEXTENDEDADDR_FAILED
//
// MessageText:
//
// Setting option EXTENDED_ADDRESS failed.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_OPTEXTENDEDADDR_FAILED 0xC000213AL

//
// MessageId: NWSAP_EVENT_OPTBCASTINADDR_FAILED
//
// MessageText:
//
// Setting NWLink option BCASTINTADDR failed.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_OPTBCASTINADDR_FAILED 0xC000213BL

//
// MessageId: NWSAP_EVENT_CARDMALLOC_FAILED
//
// MessageText:
//
// Error allocating memory to hold a card structure.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_CARDMALLOC_FAILED    0xC000213CL

//
// MessageId: NWSAP_EVENT_NOCARDS
//
// MessageText:
//
// Enumeration of cards returned 0 cards.
//
#define NWSAP_EVENT_NOCARDS              0xC000213DL

//
// MessageId: NWSAP_EVENT_THREADEVENT_FAIL
//
// MessageText:
//
// Error creating thread counting event.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_THREADEVENT_FAIL     0xC000213EL

//
// MessageId: NWSAP_EVENT_RECVSEM_FAIL
//
// MessageText:
//
// Error creating receive semaphore.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_RECVSEM_FAIL         0xC000213FL

//
// MessageId: NWSAP_EVENT_SENDEVENT_FAIL
//
// MessageText:
//
// Error creating send event.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_SENDEVENT_FAIL       0xC0002140L

//
// MessageId: NWSAP_EVENT_STARTRECEIVE_ERROR
//
// MessageText:
//
// Error starting receive thread.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_STARTRECEIVE_ERROR   0xC0002141L

//
// MessageId: NWSAP_EVENT_STARTWORKER_ERROR
//
// MessageText:
//
// Error starting worker thread.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_STARTWORKER_ERROR    0xC0002142L

//
// MessageId: NWSAP_EVENT_TABLE_MALLOC_FAILED
//
// MessageText:
//
// Error allocating database array.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_TABLE_MALLOC_FAILED  0xC0002143L

//
// MessageId: NWSAP_EVENT_HASHTABLE_MALLOC_FAILED
//
// MessageText:
//
// Error allocating hash table.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_HASHTABLE_MALLOC_FAILED 0xC0002144L

//
// MessageId: NWSAP_EVENT_STARTLPCWORKER_ERROR
//
// MessageText:
//
// Error starting LPC worker thread.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_STARTLPCWORKER_ERROR 0xC0002145L

//
// MessageId: NWSAP_EVENT_CREATELPCPORT_ERROR
//
// MessageText:
//
// Error creating the LPC port.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_CREATELPCPORT_ERROR  0xC0002146L

//
// MessageId: NWSAP_EVENT_CREATELPCEVENT_ERROR
//
// MessageText:
//
// Error creating the LPC thread event.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_CREATELPCEVENT_ERROR 0xC0002147L

//
// MessageId: NWSAP_EVENT_LPCLISTENMEMORY_ERROR
//
// MessageText:
//
// Error allocating memory for an LPC Client structure.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_LPCLISTENMEMORY_ERROR 0xC0002148L

//
// MessageId: NWSAP_EVENT_LPCHANDLEMEMORY_ERROR
//
// MessageText:
//
// Error allocating buffer to hold LPC worker thread handles.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_LPCHANDLEMEMORY_ERROR 0xC0002149L

//
// MessageId: NWSAP_EVENT_BADWANFILTER_VALUE
//
// MessageText:
//
// The value for WANFilter in the registry must be 0-2.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_BADWANFILTER_VALUE   0xC000214AL

//
// MessageId: NWSAP_EVENT_CARDLISTEVENT_FAIL
//
// MessageText:
//
// Error creating event for card list access synchronization.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_CARDLISTEVENT_FAIL   0xC000214BL

//
// MessageId: NWSAP_EVENT_SDMDEVENT_FAIL
//
// MessageText:
//
// Error creating event for database access synchronization.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_SDMDEVENT_FAIL       0xC000214CL

//
// MessageId: NWSAP_EVENT_INVALID_FILTERNAME
//
// MessageText:
//
// Name too long in key %1: Name = %s.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_INVALID_FILTERNAME   0x8000214DL

//
// MessageId: NWSAP_EVENT_WANSEM_FAIL
//
// MessageText:
//
// Error creating WAN control semaphore.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_WANSEM_FAIL          0xC000214EL

//
// MessageId: NWSAP_EVENT_WANSOCKET_FAILED
//
// MessageText:
//
// Socket create call failed for WAN socket.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_WANSOCKET_FAILED     0xC000214FL

//
// MessageId: NWSAP_EVENT_WANBIND_FAILED
//
// MessageText:
//
// Binding to WAN socket failed.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_WANBIND_FAILED       0xC0002150L

//
// MessageId: NWSAP_EVENT_STARTWANWORKER_ERROR
//
// MessageText:
//
// Error starting WAN worker thread.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_STARTWANWORKER_ERROR 0xC0002151L

//
// MessageId: NWSAP_EVENT_STARTWANCHECK_ERROR
//
// MessageText:
//
// Error starting WAN check thread.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_STARTWANCHECK_ERROR  0xC0002152L

//
// MessageId: NWSAP_EVENT_OPTMAXADAPTERNUM_ERROR
//
// MessageText:
//
// Error on getsockopt IPX_MAX_ADAPTER_NUM.  Data is the error code.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_OPTMAXADAPTERNUM_ERROR 0xC0002153L

//
// MessageId: NWSAP_EVENT_WANHANDLEMEMORY_ERROR
//
// MessageText:
//
// Error allocating buffer to hold WAN notify thread handles.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_WANHANDLEMEMORY_ERROR 0xC0002154L

//
// MessageId: NWSAP_EVENT_WANEVENT_ERROR
//
// MessageText:
//
// Error creating the WAN thread event.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_WANEVENT_ERROR       0xC0002155L


/////////////////////////////////////////////////////////////////////////
//
// Transport Events (9000-9499)
//
//
/////////////////////////////////////////////////////////////////////////


//
// MessageId: EVENT_TRANSPORT_RESOURCE_POOL
//
// MessageText:
//
// %2 could not allocate a resource of type %3 due to system resource problems.
//
#define EVENT_TRANSPORT_RESOURCE_POOL    0x80002329L

//
// MessageId: EVENT_TRANSPORT_RESOURCE_LIMIT
//
// MessageText:
//
// %2 could not allocate a resource of type %3 due to its configured size of %4.
//
#define EVENT_TRANSPORT_RESOURCE_LIMIT   0x8000232AL

//
// MessageId: EVENT_TRANSPORT_RESOURCE_SPECIFIC
//
// MessageText:
//
// %2 could not allocate a resource of type %3 due to a specifically configured limit of %4.
//
#define EVENT_TRANSPORT_RESOURCE_SPECIFIC 0x8000232BL

//
// MessageId: EVENT_TRANSPORT_REGISTER_FAILED
//
// MessageText:
//
// %2 failed to register itself with the NDIS wrapper.
//
#define EVENT_TRANSPORT_REGISTER_FAILED  0xC000232CL

//
// MessageId: EVENT_TRANSPORT_BINDING_FAILED
//
// MessageText:
//
// %2 failed to bind to network adapter %3.
//
#define EVENT_TRANSPORT_BINDING_FAILED   0xC000232DL

//
// MessageId: EVENT_TRANSPORT_ADAPTER_NOT_FOUND
//
// MessageText:
//
// %2 could not find network adapter %3.
//
#define EVENT_TRANSPORT_ADAPTER_NOT_FOUND 0xC000232EL

//
// MessageId: EVENT_TRANSPORT_SET_OID_FAILED
//
// MessageText:
//
// %2 failed while setting object identifier %3 on network adapter %4.
//
#define EVENT_TRANSPORT_SET_OID_FAILED   0xC000232FL

//
// MessageId: EVENT_TRANSPORT_QUERY_OID_FAILED
//
// MessageText:
//
// %2 failed while querying object identifier %3 on network adapter %4.
//
#define EVENT_TRANSPORT_QUERY_OID_FAILED 0xC0002330L

//
// MessageId: EVENT_TRANSPORT_TRANSFER_DATA
//
// MessageText:
//
// %2 could not transfer a packet from the network adapter.  The packet was dropped.
//
#define EVENT_TRANSPORT_TRANSFER_DATA    0x40002331L

//
// MessageId: EVENT_TRANSPORT_TOO_MANY_LINKS
//
// MessageText:
//
// %2 could not create a link to a remote computer.  Your computer has exceeded the number of connections it can make to that remote computer.
//
#define EVENT_TRANSPORT_TOO_MANY_LINKS   0x40002332L

//
// MessageId: EVENT_TRANSPORT_BAD_PROTOCOL
//
// MessageText:
//
// %2 received an unexpected %3 packet from a remote computer.
//
#define EVENT_TRANSPORT_BAD_PROTOCOL     0x40002333L


/////////////////////////////////////////////////////////////////////////
//
// IPX/SPX Events (9500-9999)
//
//
/////////////////////////////////////////////////////////////////////////


//
// MessageId: EVENT_IPX_NEW_DEFAULT_TYPE
//
// MessageText:
//
// The default frame type for auto-detection on %2 was changed to %3.
// This type is now the default if no frame type can be detected.
//
#define EVENT_IPX_NEW_DEFAULT_TYPE       0x4000251DL

//
// MessageId: EVENT_IPX_SAP_ANNOUNCE
//
// MessageText:
//
// A SAP announcement was sent over %2 which is configured for multiple
// networks, but no internal network is configured. This may prevent
// machines on some networks from locating the advertised service.
//
#define EVENT_IPX_SAP_ANNOUNCE           0x8000251EL

//
// MessageId: EVENT_IPX_ILLEGAL_CONFIG
//
// MessageText:
//
// The value for the %2 parameter %3 was illegal.
//
#define EVENT_IPX_ILLEGAL_CONFIG         0x8000251FL

//
// MessageId: EVENT_IPX_INTERNAL_NET_INVALID
//
// MessageText:
//
// %2 was configured with an internal network number of %3. This network
// number conflicts with one of the attached networks. The configured
// internal network number will be ignored.
//
#define EVENT_IPX_INTERNAL_NET_INVALID   0xC0002520L

//
// MessageId: EVENT_IPX_NO_FRAME_TYPES
//
// MessageText:
//
// %2 had no frame types configured for the binding to adapter %3.
//
#define EVENT_IPX_NO_FRAME_TYPES         0xC0002521L

//
// MessageId: EVENT_IPX_CREATE_DEVICE
//
// MessageText:
//
// %2 failed to initialize because the driver device could not be created.
//
#define EVENT_IPX_CREATE_DEVICE          0xC0002522L

//
// MessageId: EVENT_IPX_NO_ADAPTERS
//
// MessageText:
//
// %2 could not bind to any adapters. The transport could not start.
//
#define EVENT_IPX_NO_ADAPTERS            0xC0002523L


/////////////////////////////////////////////////////////////////////////
//
// DCOM Events (10000-10999)
//
//
/////////////////////////////////////////////////////////////////////////


//
// MessageId: EVENT_RPCSS_CREATEPROCESS_FAILURE
//
// MessageText:
//
// Unable to start a DCOM Server: %3.
// The error:%n"%%%2"%nHappened while starting this command:%n%1
//
#define EVENT_RPCSS_CREATEPROCESS_FAILURE 0xC0002710L

//
// MessageId: EVENT_RPCSS_RUNAS_CREATEPROCESS_FAILURE
//
// MessageText:
//
// Unable to start a DCOM Server: %3 as %4/%5.
// The error:%n"%%%2"%nHappened while starting this command:%n%1
//
#define EVENT_RPCSS_RUNAS_CREATEPROCESS_FAILURE 0xC0002711L

//
// MessageId: EVENT_RPCSS_LAUNCH_ACCESS_DENIED
//
// MessageText:
//
// Access denied attempting to launch a DCOM Server.
// The server is:%n%1%nThe user is %2/%3, SID=%4.
//
#define EVENT_RPCSS_LAUNCH_ACCESS_DENIED 0xC0002712L

//
// MessageId: EVENT_RPCSS_DEFAULT_LAUNCH_ACCESS_DENIED
//
// MessageText:
//
// Access denied attempting to launch a DCOM Server using DefaultLaunchPermssion.
// The server is:%n%1%nThe user is %2/%3, SID=%4.
//
#define EVENT_RPCSS_DEFAULT_LAUNCH_ACCESS_DENIED 0xC0002713L

//
// MessageId: EVENT_RPCSS_RUNAS_CANT_LOGIN
//
// MessageText:
//
// DCOM got error "%%%1" and was unable to logon %2\%3
// in order to run the server:%n%4
//
#define EVENT_RPCSS_RUNAS_CANT_LOGIN     0xC0002714L

//
// MessageId: EVENT_RPCSS_START_SERVICE_FAILURE
//
// MessageText:
//
// DCOM got error "%%%1" attempting to start the service %2 with arguments "%3"
// in order to run the server:%n%4
//
#define EVENT_RPCSS_START_SERVICE_FAILURE 0xC0002715L

//
// MessageId: EVENT_RPCSS_REMOTE_SIDE_ERROR
//
// MessageText:
//
// DCOM got error "%%%1" from the computer %2 when attempting to
// activate the server:%n%3
//
#define EVENT_RPCSS_REMOTE_SIDE_ERROR    0xC0002716L

//
// MessageId: EVENT_RPCSS_ACTIVATION_ERROR
//
// MessageText:
//
// DCOM got error "%%%1" when attempting to
// activate the server:%n%2
//
#define EVENT_RPCSS_ACTIVATION_ERROR     0xC0002717L

//
// MessageId: EVENT_RPCSS_REMOTE_SIDE_ERROR_WITH_FILE
//
// MessageText:
//
// DCOM got error "%%%1" from the computer %2 when attempting to
// the server:%n%3 with file %4.
//
#define EVENT_RPCSS_REMOTE_SIDE_ERROR_WITH_FILE 0xC0002718L

//
// MessageId: EVENT_RPCSS_REMOTE_SIDE_UNAVAILABLE
//
// MessageText:
//
// DCOM was unable to communicate with the computer %1 using any of the configured
// protocols.
//
#define EVENT_RPCSS_REMOTE_SIDE_UNAVAILABLE 0xC0002719L

//
// MessageId: EVENT_RPCSS_SERVER_START_TIMEOUT
//
// MessageText:
//
// The server %1 did not register with DCOM within the required timeout.
//
#define EVENT_RPCSS_SERVER_START_TIMEOUT 0xC000271AL

//
// MessageId: EVENT_RPCSS_SERVER_NOT_RESPONDING
//
// MessageText:
//
// The server %1 could not be contacted to establish the connection to the client
//
#define EVENT_RPCSS_SERVER_NOT_RESPONDING 0xC000271BL

//
// MessageId: EVENT_DCOM_ASSERTION_FAILURE
//
// MessageText:
//
// There is an assertion failure in DCOM.  Context follows:
// %1
// %2
// %3
//
#define EVENT_DCOM_ASSERTION_FAILURE     0xC000271CL

//
// MessageId: EVENT_DCOM_INVALID_ENDPOINT_DATA
//
// MessageText:
//
// DCOM server attempted to listen on an invalid endpoint.
// Protseq:  %1
// Endpoint: %2
// Flags:    %3
//
#define EVENT_DCOM_INVALID_ENDPOINT_DATA 0xC000271DL

//
// MessageId: EVENT_DCOM_COMPLUS_DISABLED
//
// MessageText:
//
// The activation for CLSID %1 failed because remote activations for COM+ are disabled.
// To enable this functionality use the Configure Your Server wizard and select the Web
// Application Server role.
//
#define EVENT_DCOM_COMPLUS_DISABLED      0xC000271EL

//
// MessageId: EVENT_RPCSS_STOP_SERVICE_FAILURE
//
// MessageText:
//
// The activation of the CLSID %1 timed out waiting for the service %2 to stop.
//
#define EVENT_RPCSS_STOP_SERVICE_FAILURE 0xC000272DL

//
// MessageId: EVENT_RPCSS_CREATEDEBUGGERPROCESS_FAILURE
//
// MessageText:
//
// Unable to start a COM Server for debugging: %3.
// The error:%n"%%%2"%nHappened while starting this command:%n%1
//
#define EVENT_RPCSS_CREATEDEBUGGERPROCESS_FAILURE 0xC000272EL


/////////////////////////////////////////////////////////////////////////
//
// DNS Caching Resolvers Service and DNS API Events (11000-11999)
//
/////////////////////////////////////////////////////////////////////////

//
// Errors
//

//
// MessageId: EVENT_DNS_CACHE_START_FAILURE_NO_DLL
//
// MessageText:
//
// Unable to start DNS Client Service.
// Failed to load DLL %2, Error: %1.
// Please reinstall this DLL from installation CD.
//
#define EVENT_DNS_CACHE_START_FAILURE_NO_DLL 0xC0002AF8L

//
// MessageId: EVENT_DNS_CACHE_START_FAILURE_NO_ENTRY
//
// MessageText:
//
// Unable to start DNS Client service. Can not find entry %3 in DLL %2.
// Please reinstall this DLL from installation CD. See event details 
// for specific error code information.
//
#define EVENT_DNS_CACHE_START_FAILURE_NO_ENTRY 0xC0002AF9L

//
// MessageId: EVENT_DNS_CACHE_START_FAILURE_NO_CONTROL
//
// MessageText:
//
// Unable to start the DNS Client service. The system could not register a
// service control handler and could be out of resources. Close any
// applications not in use or reboot the computer. See event details for 
// specific error code information.
//
#define EVENT_DNS_CACHE_START_FAILURE_NO_CONTROL 0xC0002AFAL

//
// MessageId: EVENT_DNS_CACHE_START_FAILURE_NO_DONE_EVENT
//
// MessageText:
//
// Unable to start DNS Client service. The system could
// not create a termination event for this service and
// could be out of resources. Close any applications not
// in use or reboot the computer. See event details for 
// specific error code information.
//
#define EVENT_DNS_CACHE_START_FAILURE_NO_DONE_EVENT 0xC0002AFBL

//
// MessageId: EVENT_DNS_CACHE_START_FAILURE_NO_RPC
//
// MessageText:
//
// Unable to start DNS Client service. Could not start the
// Remote Procedure Call (RPC) interface for this service.
// To correct the problem, you may restart the RPC and DNS
// Client services. To do so, use the following commands at a command
// prompt: (1) type "net start rpc" to start the RPC service, and (2)
// type "net start dnscache" to start the DNS Client service. 
// See event details for specific error code information.
//
#define EVENT_DNS_CACHE_START_FAILURE_NO_RPC 0xC0002AFCL

//
// MessageId: EVENT_DNS_CACHE_START_FAILURE_NO_SHUTDOWN_NOTIFY
//
// MessageText:
//
// Unable to start DNS Client service. The system could not register
// shutdown notification for this service and could be out of resources.
// Try closing any applications not in use or reboot the computer.
//
#define EVENT_DNS_CACHE_START_FAILURE_NO_SHUTDOWN_NOTIFY 0xC0002AFDL

//
// MessageId: EVENT_DNS_CACHE_START_FAILURE_NO_UPDATE
//
// MessageText:
//
// Unable to start DNS Client service. Could not update status with
// Service Control Manager. To correct the problem, you may restart
// the RPC and DNS Client services. To do so, use the following commands
// at a command prompt: (1) type "net start rpc" to start the RPC service,
// and (2) type "net start dnscache" to start the DNS Client service. 
// See event details for specific error code information.
//
#define EVENT_DNS_CACHE_START_FAILURE_NO_UPDATE 0xC0002AFEL

//
// MessageId: EVENT_DNS_CACHE_START_FAILURE_LOW_MEMORY
//
// MessageText:
//
// Unable to start DNS Client service because the system failed to allocate
// memory and may be out of available memory. Try closing any applications not
// in use or reboot the computer. See event details for specific error code 
// information.
//
#define EVENT_DNS_CACHE_START_FAILURE_LOW_MEMORY 0xC0002AFFL


//
// Warnings
//

//
// MessageId: EVENT_DNS_CACHE_NETWORK_PERF_WARNING
//
// MessageText:
//
// The DNS Client service could not contact any DNS servers for
// a repeated number of attempts. For the next %3 seconds the
// DNS Client service will not use the network to avoid further
// network performance problems. It will resume its normal behavior
// after that. If this problem persists, verify your TCP/IP
// configuration, specifically check that you have a preferred
// (and possibly an alternate) DNS server configured. If the problem
// continues, verify network conditions to these DNS servers or contact
// your network administrator.
//
#define EVENT_DNS_CACHE_NETWORK_PERF_WARNING 0x80002B2AL

//
// MessageId: EVENT_DNS_CACHE_UNABLE_TO_REACH_SERVER_WARNING
//
// MessageText:
//
// The DNS Client service failed to reach DNS server at address %1. It will
// not use this DNS server for %2 seconds.
//
#define EVENT_DNS_CACHE_UNABLE_TO_REACH_SERVER_WARNING 0x80002B2BL

//
// MessageId: EVENT_DNSAPI_REGISTRATION_FAILED_TIMEOUT
//
// MessageText:
//
// The system failed to register network adapter with settings:%n%n
//   Adapter Name : %1%n
//   Host Name : %2%n
//   Adapter-specific Domain Suffix : %3%n
//   DNS Server list :%n
//     %4%n
//   Sent update to server : %5%n
//   IP Address(es) :%n
//     %6%n%n
// The cause of this DNS registration failure was because the DNS update
// request timed out after being sent to the specified DNS Server. This is
// probably because the authoritative DNS server for the name being updated
// is not running.%n%n You can manually retry registration of the network
// adapter and its settings by typing "ipconfig /registerdns" at the command
// prompt. If problems still  persist, contact your network systems
// administrator to verify network conditions.
//
#define EVENT_DNSAPI_REGISTRATION_FAILED_TIMEOUT 0x80002B8EL

//
// MessageId: EVENT_DNSAPI_REGISTRATION_FAILED_SERVERFAIL
//
// MessageText:
//
// The system failed to register network adapter with settings:%n%n
//   Adapter Name : %1%n
//   Host Name : %2%n
//   Adapter-specific Domain Suffix : %3%n
//   DNS server list :%n
//     %4%n
//   Sent update to server : %5%n
//   IP Address(es) :%n
//     %6%n%n
// The cause of this DNS registration failure was because of DNS server failure.
// This may be due to a zone transfer that has locked the DNS server for the
// applicable zone that your computer needs to register itself with.%n%n
// (The applicable zone should typically correspond to the Adapter-specific
// Domain Suffix that was indicated above.) You can manually retry registration
// of the network adapter and its settings by typing "ipconfig /registerdns"
// at the command prompt. If problems still persist, contact your network
// systems administrator to verify network conditions.
//
#define EVENT_DNSAPI_REGISTRATION_FAILED_SERVERFAIL 0x80002B8FL

//
// MessageId: EVENT_DNSAPI_REGISTRATION_FAILED_NOTSUPP
//
// MessageText:
//
// The system failed to register network adapter with settings:%n%n
//   Adapter Name : %1%n
//   Host Name : %2%n
//   Adapter-specific Domain Suffix : %3%n
//   DNS server list :%n
//     %4%n
//   Sent update to server : %5%n
//   IP Address(es) :%n
//     %6%n%n
// The reason it could not register was because either: (a) the DNS server
// does not support the DNS dynamic update protocol, or (b) the primary zone
// authoritative for the registering names does not currently accept dynamic
// updates.%n%n To add or register a DNS host (A or AAAA) resource record using 
// the specific DNS name for this adapter, contact your DNS server or network
// systems administrator.
//
#define EVENT_DNSAPI_REGISTRATION_FAILED_NOTSUPP 0x80002B90L

//
// MessageId: EVENT_DNSAPI_REGISTRATION_FAILED_REFUSED
//
// MessageText:
//
// The system failed to register network adapter with settings:%n%n
//   Adapter Name : %1%n
//   Host Name : %2%n
//   Adapter-specific Domain Suffix : %3%n
//   DNS server list :%n
//     %4%n
//   Sent update to server : %5%n
//   IP Address(es) :%n
//     %6%n%n
// The reason it could not register was because the DNS server refused the
// dynamic update request. This could happen for the following reasons:
// (a) current DNS update policies do not allow this computer to update
// the DNS domain name configured for this adapter, or (b) the authoritative
// DNS server for this DNS domain name does not support the DNS dynamic update
// protocol.%n%n
// To register a DNS host (A or AAAA) resource record using the specific DNS 
// domain name for this adapter, contact your DNS server or network systems
// administrator.
//
#define EVENT_DNSAPI_REGISTRATION_FAILED_REFUSED 0x80002B91L

//
// MessageId: EVENT_DNSAPI_REGISTRATION_FAILED_SECURITY
//
// MessageText:
//
// The system failed to register network adapter with settings:%n%n
//   Adapter Name : %1%n
//   Host Name : %2%n
//   Adapter-specific Domain Suffix : %3%n
//   DNS server list :%n
//     %4%n
//   Sent update to server : %5%n
//   IP Address(es) :%n
//     %6%n%n
// The system could not register the DNS update request because of a
// security related problem. This could happen for the following reasons:
// (a) the DNS domain name that your computer is trying to register could
// not be updated because your computer does not have the right permissions,
// or (b) there might have been a problem negotiating valid credentials
// with the DNS server to update.%n%n
// You can manually retry DNS registration of the network adapter and its
// settings by typing "ipconfig /registerdns" at the command prompt. If
// problems still persist, contact your DNS server or network systems
// administrator. See event details for specific error code information.
//
#define EVENT_DNSAPI_REGISTRATION_FAILED_SECURITY 0x80002B92L

//
// MessageId: EVENT_DNSAPI_REGISTRATION_FAILED_OTHER
//
// MessageText:
//
// The system failed to register network adapter with settings:%n%n
//   Adapter Name : %1%n
//   Host Name : %2%n
//   Adapter-specific Domain Suffix : %3%n
//   DNS server list :%n
//     %4%n
//   Sent update to server : %5%n
//   IP Address(es) :%n
//     %6%n%n
// The reason the DNS update request could not be completed was because
// of a system problem. You can manually retry DNS registration of the
// network adapter and its settings by typing "ipconfig /registerdns"
// at the command prompt. If problems still persist, contact your DNS
// server or network systems administrator. See event details for 
// specific error code information.
//
#define EVENT_DNSAPI_REGISTRATION_FAILED_OTHER 0x80002B93L

//
// MessageId: EVENT_DNSAPI_PTR_REGISTRATION_FAILED_TIMEOUT
//
// MessageText:
//
// The system failed to register pointer (PTR) resource records (RRs) for
// network adapter%nwith settings:%n%n
//   Adapter Name : %1%n
//   Host Name : %2%n
//   Adapter-specific Domain Suffix : %3%n
//   DNS server list :%n
//     %4%n
//   Sent update to server : %5%n
//   IP Address : %6%n%n
// The reason that the system could not register these RRs was because the
// update request that was sent to the specified DNS server timed out. This
// is probably because the authoritative DNS server for the name being
// registered is not running.%n%n You can manually retry DNS registration
// of the network adapter and its settings by typing "ipconfig /registerdns"
// at the command prompt. If problems still persist, contact your DNS
// server or network systems administrator. See event details for specific 
// error code information.
//
#define EVENT_DNSAPI_PTR_REGISTRATION_FAILED_TIMEOUT 0x80002B94L

//
// MessageId: EVENT_DNSAPI_PTR_REGISTRATION_FAILED_SERVERFAIL
//
// MessageText:
//
// The system failed to register pointer (PTR) resource records (RRs)
// for network adapter%nwith settings:%n%n
//   Adapter Name : %1%n
//   Host Name : %2%n
//   Adapter-specific Domain Suffix : %3%n
//   DNS server list :%n
//     %4%n
//   Sent update to server : %5%n
//   IP Address : %6%n%n
// The cause was DNS server failure. This may because the reverse lookup
// zone is busy or missing on the DNS server that your computer needs to
// update. In most cases, this is a minor problem because it does not
// affect normal (forward) name resolution.%n%n If reverse (address-to-name)
// resolution is required for your computer, you can manually retry DNS
// registration of the network adapter and its settings by typing 
// "ipconfig /registerdns" at the command prompt. If problems still 
// persist, contact your DNS server or network systems administrator. 
// See event details for specific error code information.
//
#define EVENT_DNSAPI_PTR_REGISTRATION_FAILED_SERVERFAIL 0x80002B95L

//
// MessageId: EVENT_DNSAPI_PTR_REGISTRATION_FAILED_NOTSUPP
//
// MessageText:
//
// The system failed to register pointer (PTR) resource records (RRs)
// for network adapter%nwith settings:%n%n
//   Adapter Name : %1%n
//   Host Name : %2%n
//   Adapter-specific Domain Suffix : %3%n
//   DNS server list :%n
//     %4%n
//   Sent update to server : %5%n
//   IP Address : %6%n%n
// The reason that the system could not register these RRs was because
// (a) either the DNS server does not support the DNS dynamic update
// protocol, or (b) the authoritative zone where these records are to
// be registered does not allow dynamic updates.%n%n
// To register DNS pointer (PTR) resource records using the specific
// DNS domain name and IP addresses for this adapter, contact your
// DNS server or network systems administrator.
//
#define EVENT_DNSAPI_PTR_REGISTRATION_FAILED_NOTSUPP 0x80002B96L

//
// MessageId: EVENT_DNSAPI_PTR_REGISTRATION_FAILED_REFUSED
//
// MessageText:
//
// The system failed to register pointer (PTR) resource records (RRs)
// for network adapter%nwith settings:%n%n
//   Adapter Name : %1%n
//   Host Name : %2%n
//   Adapter-specific Domain Suffix : %3%n
//   DNS server list :%n
//     %4%n
//   Sent update to server : %5%n
//   IP Address : %6%n%n
// The reason that the system could not register these RRs was because
// the DNS server refused the update request. The cause of this could
// be (a) your computer is not allowed to update the adapter-specified DNS
// domain name, or (b) because the DNS server authoritative for the specified
// name does not support the DNS dynamic update protocol.%n%n
// To register the DNS pointer (PTR) resource records using the specific
// DNS domain name and IP addresses for this adapter, contact your DNS
// server or network systems administrator.
//
#define EVENT_DNSAPI_PTR_REGISTRATION_FAILED_REFUSED 0x80002B97L

//
// MessageId: EVENT_DNSAPI_PTR_REGISTRATION_FAILED_SECURITY
//
// MessageText:
//
// The system failed to register pointer (PTR) resource records (RRs)
// for network adapter%nwith settings:%n%n
//   Adapter Name : %1%n
//   Host Name : %2%n
//   Adapter-specific Domain Suffix : %3%n
//   DNS server list :%n
//     %4%n
//   Sent update to server : %5%n
//   IP Address : %6%n%n
// The reason that the system could not register these RRs was because
// of a security related problem. The cause of this could be (a) your
// computer does not have permissions to register and update the specific
// DNS domain name set for this adapter, or (b) there might have been a
// problem negotiating valid credentials with the DNS server during the
// processing of the update request.%n%n
// You can manually retry DNS registration of the network adapter and
// its settings by typing "ipconfig /registerdns" at the command prompt.
// If problems still persist, contact your DNS server or network systems
// administrator.
//
#define EVENT_DNSAPI_PTR_REGISTRATION_FAILED_SECURITY 0x80002B98L

//
// MessageId: EVENT_DNSAPI_PTR_REGISTRATION_FAILED_OTHER
//
// MessageText:
//
// The system failed to register pointer (PTR) resource records (RRs)
// for network adapter%nwith settings:%n%n
//   Adapter Name : %1%n
//   Host Name : %2%n
//   Adapter-specific Domain Suffix : %3%n
//   DNS server list :%n
//     %4%n
//   Sent update to server : %5%n
//   IP Address : %6%n%n
// The reason the system could not register these RRs during the
// update request was because of a system problem. You can manually
// retry DNS registration of the network adapter and its settings by
// typing "ipconfig /registerdns" at the command prompt. If problems
// still persist, contact your DNS server or network systems
// administrator. See event details for specific error code information.
//
#define EVENT_DNSAPI_PTR_REGISTRATION_FAILED_OTHER 0x80002B99L

//
// MessageId: EVENT_DNSAPI_REGISTRATION_FAILED_TIMEOUT_PRIMARY_DN
//
// MessageText:
//
// The system failed to register host (A or AAAA) resource records (RRs) for
// network adapter%nwith settings:%n%n
//   Adapter Name : %1%n
//   Host Name : %2%n
//   Primary Domain Suffix : %3%n
//   DNS server list :%n
//     %4%n
//   Sent update to server : %5%n
//   IP Address(es) :%n
//     %6%n%n
// The reason the system could not register these RRs was because the
// update request it sent to the DNS server timed out. The most likely
// cause of this is that the DNS server authoritative for the name it
// was attempting to register or update is not running at this time.%n%n
// You can manually retry DNS registration of the network adapter and
// its settings by typing "ipconfig /registerdns" at the command prompt.
// If problems still persist, contact your DNS server or network systems
// administrator.
//
#define EVENT_DNSAPI_REGISTRATION_FAILED_TIMEOUT_PRIMARY_DN 0x80002B9AL

//
// MessageId: EVENT_DNSAPI_REGISTRATION_FAILED_SERVERFAIL_PRIMARY_DN
//
// MessageText:
//
// The system failed to register host (A or AAAA) resource records (RRs) for
// network adapter%nwith settings:%n%n
//   Adapter Name : %1%n
//   Host Name : %2%n
//   Primary Domain Suffix : %3%n
//   DNS server list :%n
//     %4%n
//   Sent update to server : %5%n
//   IP Address(es) :%n
//     %6%n%n
// The reason the system could not register these RRs was because the
// DNS server failed the update request. The most likely cause of this
// is that the authoritative DNS server required to process this update
// request has a lock in place on the zone, probably because a zone
// transfer is in progress.%n%n
// You can manually retry DNS registration of the network adapter and
// its settings by typing "ipconfig /registerdns" at the command prompt.
// If problems still persist, contact your DNS server or network systems
// administrator.
//
#define EVENT_DNSAPI_REGISTRATION_FAILED_SERVERFAIL_PRIMARY_DN 0x80002B9BL

//
// MessageId: EVENT_DNSAPI_REGISTRATION_FAILED_NOTSUPP_PRIMARY_DN
//
// MessageText:
//
// The system failed to register host (A or AAAA) resource records for 
// network adapter%nwith settings:%n%n
//   Adapter Name : %1%n
//   Host Name : %2%n
//   Primary Domain Suffix : %3%n
//   DNS server list :%n
//     %4%n
//   Sent update to server : %5%n
//   IP Address(es) :%n
//     %6%n%n
// Either the DNS server does not support the DNS dynamic update protocol 
// or the authoritative zone for the specified DNS domain name does not 
// accept dynamic updates.%n%n
// To register the DNS host (A or AAAA) resource records using the specific
// DNS domain name and IP addresses for this adapter, contact your DNS 
// server or network systems administrator.
//
#define EVENT_DNSAPI_REGISTRATION_FAILED_NOTSUPP_PRIMARY_DN 0x80002B9CL

//
// MessageId: EVENT_DNSAPI_REGISTRATION_FAILED_REFUSED_PRIMARY_DN
//
// MessageText:
//
// The system failed to register host (A or AAAA) resource records (RRs) for
// network adapter%nwith settings:%n%n
//   Adapter Name : %1%n
//   Host Name : %2%n
//   Primary Domain Suffix : %3%n
//   DNS server list :%n
//     %4%n
//   Sent update to server : %5%n
//   IP Address(es) :%n
//     %6%n%n
// The reason the system could not register these RRs was because the
// DNS server contacted refused the update request. The reasons for this
// might be (a) you are not allowed to update the specified DNS domain name,
// or (b) because the DNS server authoritative for this name does not support
// the DNS dynamic update protocol.%n%n
// To register the DNS host (A or AAAA) resource records using the specific DNS
// domain name and IP addresses for this adapter, contact your DNS server
// or network systems administrator.
//
#define EVENT_DNSAPI_REGISTRATION_FAILED_REFUSED_PRIMARY_DN 0x80002B9DL

//
// MessageId: EVENT_DNSAPI_REGISTRATION_FAILED_SECURITY_PRIMARY_DN
//
// MessageText:
//
// The system failed to register host (A or AAAA) resource records (RRs) for
// network adapter%nwith settings:%n%n
//   Adapter Name : %1%n
//   Host Name : %2%n
//   Primary Domain Suffix : %3%n
//   DNS server list :%n
//     %4%n
//   Sent update to server : %5%n
//   IP Address(es) :%n
//     %6%n%n
// The reason the system could not register these RRs was because of a
// security related problem. The cause of this could be (a) your computer
// does not have permissions to register and update the specific DNS domain
// name set for this adapter, or (b) there might have been a problem negotiating
// valid credentials with the DNS server during the processing of the update
// request.%n%n
// You can manually retry DNS registration of the network adapter and
// its settings by typing "ipconfig /registerdns" at the command prompt.
// If problems still persist, contact your DNS server or network systems
// administrator. See event details for specific error code information.
//
#define EVENT_DNSAPI_REGISTRATION_FAILED_SECURITY_PRIMARY_DN 0x80002B9EL

//
// MessageId: EVENT_DNSAPI_REGISTRATION_FAILED_OTHER_PRIMARY_DN
//
// MessageText:
//
// The system failed to register host (A or AAAA) resource records (RRs) for
// network adapter%nwith settings:%n%n
//   Adapter Name : %1%n
//   Host Name : %2%n
//   Primary Domain Suffix : %3%n
//   DNS server list :%n
//     %4%n
//   Sent update to server : %5%n
//   IP Address(es) :%n
//     %6%n%n
// The reason the system could not register these RRs during the
// update request was because of a system problem. You can manually
// retry DNS registration of the network adapter and its settings by
// typing "ipconfig /registerdns" at the command prompt. If problems
// still persist, contact your DNS server or network systems
// administrator. See event details for specific error code information.
//
#define EVENT_DNSAPI_REGISTRATION_FAILED_OTHER_PRIMARY_DN 0x80002B9FL


//
// Deregistration update errors
//

//
// MessageId: EVENT_DNSAPI_DEREGISTRATION_FAILED_TIMEOUT
//
// MessageText:
//
// The system failed to update and remove registration for the
// network adapter with settings:%n%n
//   Adapter Name : %1%n
//   Host Name : %2%n
//   Adapter-specific Domain Suffix : %3%n
//   DNS server list :%n
//     %4%n
//   Sent update to server : %5%n
//   IP Address(es) :%n
//     %6%n%n
// The reason for this failure is because the DNS server it sent the update
// request to timed out. The most likely cause of this failure is that the
// DNS server authoritative for the zone where the registration was originally
// made is either not running or unreachable through the network at this time.
//
#define EVENT_DNSAPI_DEREGISTRATION_FAILED_TIMEOUT 0x80002BACL

//
// MessageId: EVENT_DNSAPI_DEREGISTRATION_FAILED_SERVERFAIL
//
// MessageText:
//
// The system failed to update and remove registration for the
// network adapter with settings:%n%n
//   Adapter Name : %1%n
//   Host Name : %2%n
//   Adapter-specific Domain Suffix : %3%n
//   DNS server list :%n
//     %4%n
//   Sent update to server : %5%n
//   IP Address(es) :%n
//     %6%n%n
// The reason for this failure is because the DNS server it sent the update
// to failed the update request. A possible cause of this failure is that
// the DNS server required to process this update request has a lock in place
// on the zone, probably because a zone transfer is in progress.%n%n
//
#define EVENT_DNSAPI_DEREGISTRATION_FAILED_SERVERFAIL 0x80002BADL

//
// MessageId: EVENT_DNSAPI_DEREGISTRATION_FAILED_NOTSUPP
//
// MessageText:
//
// The system failed to update and remove registration for the network
// adapter with settings:%n%n
//   Adapter Name : %1%n
//   Host Name : %2%n
//   Adapter-specific Domain Suffix : %3%n
//   DNS server list :%n
//     %4%n
//   Sent update to server : %5%n
//   IP Address(es) :%n
//     %6%n%n
// The reason for this failure is because the DNS server sent the update
// either (a) does not support the DNS dynamic update protocol, or (b) the
// authoritative zone for the specified DNS domain name does not currently
// accept DNS dynamic updates.
//
#define EVENT_DNSAPI_DEREGISTRATION_FAILED_NOTSUPP 0x80002BAEL

//
// MessageId: EVENT_DNSAPI_DEREGISTRATION_FAILED_REFUSED
//
// MessageText:
//
// The system failed to update and remove registration for the network
// adapter with settings:%n%n
//   Adapter Name : %1%n
//   Host Name : %2%n
//   Adapter-specific Domain Suffix : %3%n
//   DNS server list :%n
//     %4%n
//   Sent update to server : %5%n
//   IP Address(es) :%n
//     %6%n%n
// The reason the system could not perform the update request was the
// DNS server contacted refused update request. The cause of this is
// (a) this computer is not allowed to update the specified DNS domain
// name, or (b) because the DNS server authoritative for the zone that
// requires updating does not support the DNS dynamic update protocol.
//
#define EVENT_DNSAPI_DEREGISTRATION_FAILED_REFUSED 0x80002BAFL

//
// MessageId: EVENT_DNSAPI_DEREGISTRATION_FAILED_SECURITY
//
// MessageText:
//
// The system failed to update and remove registration for the network
// adapter with settings:%n%n
//   Adapter Name : %1%n
//   Host Name : %2%n
//   Adapter-specific Domain Suffix : %3%n
//   DNS server list :%n
//     %4%n
//   Sent update to server : %5%n
//   IP Address(es) :%n
//     %6%n%n
// The reason the system could not perform the update request was because
// of a security related problem. The cause of this could be (a) your computer
// does not have permissions to register and update the specific DNS domain
// name set for this adapter, or (b) there might have been a problem negotiating
// valid credentials with the DNS server during the processing of the update
// request.%n%n
// See event details for specific error code information.
//
#define EVENT_DNSAPI_DEREGISTRATION_FAILED_SECURITY 0x80002BB0L

//
// MessageId: EVENT_DNSAPI_DEREGISTRATION_FAILED_OTHER
//
// MessageText:
//
// The system failed to update and remove the DNS registration for the
// network adapter with settings:%n%n
//   Adapter Name : %1%n
//   Host Name : %2%n
//   Adapter-specific Domain Suffix : %3%n
//   DNS server list :%n
//     %4%n
//   Sent update to server : %5%n
//   IP Address(es) :%n
//     %6%n%n
// The system could not update to remove this DNS registration because of
// a system problem. See event details for specific error code information.
//
#define EVENT_DNSAPI_DEREGISTRATION_FAILED_OTHER 0x80002BB1L

//
// MessageId: EVENT_DNSAPI_PTR_DEREGISTRATION_FAILED_TIMEOUT
//
// MessageText:
//
// The system failed to update and remove pointer (PTR) resource records (RRs)
// for network adapter%nwith settings:%n%n
//   Adapter Name : %1%n
//   Host Name : %2%n
//   Adapter-specific Domain Suffix : %3%n
//   DNS server list :%n
//     %4%n
//   Sent update to server : %5%n
//   IP Address : %6%n%n
// The system could not remove these PTR RRs because the update request
// timed out while awaiting a response from the DNS server. This is probably
// because the DNS server authoritative for the zone that requires update
// is not running.
//
#define EVENT_DNSAPI_PTR_DEREGISTRATION_FAILED_TIMEOUT 0x80002BB2L

//
// MessageId: EVENT_DNSAPI_PTR_DEREGISTRATION_FAILED_SERVERFAIL
//
// MessageText:
//
// The system failed to update and remove pointer (PTR) resource records (RRs)
// for network adapter%nwith settings:%n%n
//   Adapter Name : %1%n
//   Host Name : %2%n
//   Adapter-specific Domain Suffix : %3%n
//   DNS server list :%n
//     %4%n
//   Sent update to server : %5%n
//   IP Address : %6%n%n
// The system could not remove these PTR RRs because the DNS server failed the
// update request. A possible cause is that a zone transfer is in progress,
// causing a lock for the zone at the DNS server authorized to perform the
// updates for these RRs.
//
#define EVENT_DNSAPI_PTR_DEREGISTRATION_FAILED_SERVERFAIL 0x80002BB3L

//
// MessageId: EVENT_DNSAPI_PTR_DEREGISTRATION_FAILED_NOTSUPP
//
// MessageText:
//
// The system failed to update and remove pointer (PTR) resource records (RRs)
// for network adapter%nwith settings:%n%n
//   Adapter Name : %1%n
//   Host Name : %2%n
//   Adapter-specific Domain Suffix : %3%n
//   DNS server list :%n
//     %4%n
//   Sent update to server : %5%n
//   IP Address : %6%n%n
// The system could not remove these PTR RRs because either the DNS server
// does not support the DNS dynamic update protocol or the authoritative zone
// that contains these RRs does not accept dynamic updates.
//
#define EVENT_DNSAPI_PTR_DEREGISTRATION_FAILED_NOTSUPP 0x80002BB4L

//
// MessageId: EVENT_DNSAPI_PTR_DEREGISTRATION_FAILED_REFUSED
//
// MessageText:
//
// The system failed to update and remove pointer (PTR) resource records (RRs)
// for network adapter%nwith settings:%n%n
//   Adapter Name : %1%n
//   Host Name : %2%n
//   Adapter-specific Domain Suffix : %3%n
//   DNS server list :%n
//     %4%n
//   Sent update to server : %5%n
//   IP Address : %6%n%n
// The system could not remove these PTR RRs because the DNS server refused the
// update request. The cause of this might be (a) this computer is not allowed
// to update the specified DNS domain name specified by these settings, or
// (b) because the DNS server authorized to perform updates for the zone that
// contains these RRs does not support the DNS dynamic update protocol.
//
#define EVENT_DNSAPI_PTR_DEREGISTRATION_FAILED_REFUSED 0x80002BB5L

//
// MessageId: EVENT_DNSAPI_PTR_DEREGISTRATION_FAILED_SECURITY
//
// MessageText:
//
// The system failed to update and remove pointer (PTR) resource records (RRs)
// for network adapter%nwith settings:%n%n
//   Adapter Name : %1%n
//   Host Name : %2%n
//   Adapter-specific Domain Suffix : %3%n
//   DNS server list :%n
//     %4%n
//   Sent update to server : %5%n
//   IP Address : %6%n%n
// The system could not remove these PTR RRs because of a security related
// problem. The cause of this could be that (a) your computer does not have
// permissions to remove and update the specific DNS domain name or IP addresses
// configured for this adapter, or (b) there might have been a problem negotiating
// valid credentials with the DNS server during the processing of the update
// request. See event details for specific error code information.
//
#define EVENT_DNSAPI_PTR_DEREGISTRATION_FAILED_SECURITY 0x80002BB6L

//
// MessageId: EVENT_DNSAPI_PTR_DEREGISTRATION_FAILED_OTHER
//
// MessageText:
//
// The system failed to update and remove pointer (PTR) resource records (RRs)
// for network adapter%nwith settings:%n%n
//   Adapter Name : %1%n
//   Host Name : %2%n
//   Adapter-specific Domain Suffix : %3%n
//   DNS server list :%n
//     %4%n
//   Sent update to server : %5%n
//   IP Address : %6%n%n
// The system could not remove these PTR RRs because because of a system
// problem. See event details for specific error code information.
//
#define EVENT_DNSAPI_PTR_DEREGISTRATION_FAILED_OTHER 0x80002BB7L

//
// MessageId: EVENT_DNSAPI_DEREGISTRATION_FAILED_TIMEOUT_PRIMARY_DN
//
// MessageText:
//
// The system failed to update and remove host (A or AAAA) resource records (RRs)
// for network adapter%nwith settings:%n%n
//   Adapter Name : %1%n
//   Host Name : %2%n
//   Primary Domain Suffix : %3%n
//   DNS server list :%n
//     %4%n
//   Sent update to server : %5%n
//   IP Address(es) :%n
//     %6%n%n
// The system could not remove these host (A or AAAA) RRs because the update request 
// timed out while awaiting a response from the DNS server. This is probably because
// the DNS server authoritative for the zone where these RRs need to be updated
// is either not currently running or reachable on the network.
//
#define EVENT_DNSAPI_DEREGISTRATION_FAILED_TIMEOUT_PRIMARY_DN 0x80002BB8L

//
// MessageId: EVENT_DNSAPI_DEREGISTRATION_FAILED_SERVERFAIL_PRIMARY_DN
//
// MessageText:
//
// The system failed to update and remove host (A or AAAA) resource records (RRs)
// for network adapter%nwith settings:%n%n
//   Adapter Name : %1%n
//   Host Name : %2%n
//   Primary Domain Suffix : %3%n
//   DNS server list :%n
//     %4%n
//   Sent update to server : %5%n
//   IP Address(es) :%n
//     %6%n%n
// The system could not remove these host (A or AAAA) RRs because the DNS server
// failed the update request. A possible cause is that a zone transfer is in progress,
// causing a lock for the zone at the DNS server authorized to perform the
// updates for these RRs.
//
#define EVENT_DNSAPI_DEREGISTRATION_FAILED_SERVERFAIL_PRIMARY_DN 0x80002BB9L

//
// MessageId: EVENT_DNSAPI_DEREGISTRATION_FAILED_NOTSUPP_PRIMARY_DN
//
// MessageText:
//
// The system failed to update and remove host (A or AAAA) resource records (RRs)
// for network adapter%nwith settings:%n%n
//   Adapter Name : %1%n
//   Host Name : %2%n
//   Primary Domain Suffix : %3%n
//   DNS server list :%n
//     %4%n
//   Sent update to server : %5%n
//   IP Address(es) :%n
//     %6%n%n
// The reason for this failure is because the DNS server sent the update
// either (a) does not support the DNS dynamic update protocol, or (b) the
// authoritative zone for the DNS domain name specified in these host (A or AAAA)
// RRs does not currently accept DNS dynamic updates.
//
#define EVENT_DNSAPI_DEREGISTRATION_FAILED_NOTSUPP_PRIMARY_DN 0x80002BBAL

//
// MessageId: EVENT_DNSAPI_DEREGISTRATION_FAILED_REFUSED_PRIMARY_DN
//
// MessageText:
//
// The system failed to update and remove host (A or AAAA) resource records (RRs)
// for network adapter%nwith settings:%n%n
//   Adapter Name : %1%n
//   Host Name : %2%n
//   Primary Domain Suffix : %3%n
//   DNS server list :%n
//     %4%n
//   Sent update to server : %5%n
//   IP Address(es) :%n
//     %6%n%n
// The request to remove these records failed because the DNS server refused
// the update request. The cause of this might be that either (a) this
// computer is not allowed to update the DNS domain name specified by these
// settings, or (b) because the DNS server authorized to perform updates for
// the zone that contains these RRs does not support the DNS dynamic update
// protocol.
//
#define EVENT_DNSAPI_DEREGISTRATION_FAILED_REFUSED_PRIMARY_DN 0x80002BBBL

//
// MessageId: EVENT_DNSAPI_DEREGISTRATION_FAILED_SECURITY_PRIMARY_DN
//
// MessageText:
//
// The system failed to update and remove host (A or AAAA) resource records (RRs)
// for network adapter%nwith settings:%n%n
//   Adapter Name : %1%n
//   Host Name : %2%n
//   Primary Domain Suffix : %3%n
//   DNS server list :%n
//     %4%n
//   Sent update to server : %5%n
//   IP Address(es) :%n
//     %6%n%n
// The reason for this failure was because of a security related problem.
// The cause of this could be that (a) your computer does not have permissions
// to remove and update the specific DNS domain name or IP addresses
// configured for this adapter, or (b) there might have been a problem
// negotiating valid credentials with the DNS server during the processing of
// the update request. See event details for specific error code information.
//
#define EVENT_DNSAPI_DEREGISTRATION_FAILED_SECURITY_PRIMARY_DN 0x80002BBCL

//
// MessageId: EVENT_DNSAPI_DEREGISTRATION_FAILED_OTHER_PRIMARY_DN
//
// MessageText:
//
// The system failed to update and remove host (A or AAAA) resource records (RRs)
// for network adapter%nwith settings:%n%n
//   Adapter Name : %1%n
//   Host Name : %2%n
//   Primary Domain Suffix : %3%n
//   DNS server list :%n
//     %4%n
//   Sent update to server : %5%n
//   IP Address(es) :%n
//     %6%n%n
// The reason the update request failed was because of a system problem.
// See event details for specific error code information
//
#define EVENT_DNSAPI_DEREGISTRATION_FAILED_OTHER_PRIMARY_DN 0x80002BBDL


//
// Information
//

//
// MessageId: EVENT_DNSAPI_REGISTERED_ADAPTER
//
// MessageText:
//
// The system registered network adapter with settings :%n%n
//   Adapter Name : %1%n
//   Host Name : %2%n
//   Adapter-specific Domain Suffix : %3%n
//   DNS server list :%n
//     %4%n
//   Sent update to server : %5%n
//   IP Address(es) :%n
//     %6
//
#define EVENT_DNSAPI_REGISTERED_ADAPTER  0x40002BC0L

//
// MessageId: EVENT_DNSAPI_REGISTERED_PTR
//
// MessageText:
//
// The system registered pointer (PTR) resource records (RRs) for network
// adapter%nwith settings:%n%n
//   Adapter Name : %1%n
//   Host Name : %2%n
//   Adapter-specific Domain Suffix : %3%n
//   Primary Domain Suffix : %4%n
//   DNS server list :%n
//     %5%n
//   Sent update to server : %6%n
//   IP Address : %7
//
#define EVENT_DNSAPI_REGISTERED_PTR      0x40002BC1L

//
// MessageId: EVENT_DNSAPI_REGISTERED_ADAPTER_PRIMARY_DN
//
// MessageText:
//
// The system registered host (A or AAAA) resource records (RRs) for network
// adapter%nwith settings :%n%n
//   Adapter Name : %1%n
//   Host Name : %2%n
//   Primary Domain Suffix : %3%n
//   DNS server list :%n
//     %4%n
//   Sent update to server : %5%n
//   IP Address(es) :%n
//     %6
//
#define EVENT_DNSAPI_REGISTERED_ADAPTER_PRIMARY_DN 0x40002BC2L


/////////////////////////////////////////////////////////////////////////
//
// Trk Services Events (12500-12999)
//
/////////////////////////////////////////////////////////////////////////

//
// MessageId: EVENT_TRK_INTERNAL_ERROR
//
// MessageText:
//
// An internal error occured in Distributed Link Tracking.  The error code was %1.
//
#define EVENT_TRK_INTERNAL_ERROR         0xC00030D4L

//
// MessageId: EVENT_TRK_SERVICE_START_SUCCESS
//
// MessageText:
//
// Service started successfully
//
#define EVENT_TRK_SERVICE_START_SUCCESS  0x400030D5L

//
// MessageId: EVENT_TRK_SERVICE_START_FAILURE
//
// MessageText:
//
// Service failed to start.  Error = %1
//
#define EVENT_TRK_SERVICE_START_FAILURE  0xC00030D6L

//
// MessageId: EVENT_TRK_SERVICE_CORRUPT_LOG
//
// MessageText:
//
// The Distributed Link Tracking log was corrupt on volume %1: and has been re-created.  This log is used to automatically repair file links, such as Shell Shortcuts and OLE links, when for some reason those links become broken.
//
#define EVENT_TRK_SERVICE_CORRUPT_LOG    0xC00030D7L

//
// MessageId: EVENT_TRK_SERVICE_VOL_QUOTA_EXCEEDED
//
// MessageText:
//
// The Distributed Link Tracking volume ID quota on this machine has been exceeded.  As a result, it is not possible to create new volume IDs.  Distributed Link Tracking normally uses these volume IDs to automatically repair file links, such as Shell Shortcuts and OLE links, when for some reason those links become broken.
//
#define EVENT_TRK_SERVICE_VOL_QUOTA_EXCEEDED 0x800030D8L

//
// MessageId: EVENT_TRK_SERVICE_VOLUME_CREATE
//
// MessageText:
//
// A new volume ID has been assigned for %1:%n%2%n%n
// This ID is used by Distributed Link Tracking to automatically repair file links, such as Shell Shortcuts and OLE links, when for some reason those links become broken.  If there previously were links to files on this volume that are broken, they might not be automatically repairable.
//
#define EVENT_TRK_SERVICE_VOLUME_CREATE  0x400030D9L

//
// MessageId: EVENT_TRK_SERVICE_VOLUME_CLAIM
//
// MessageText:
//
// Ownership of the volume ID for %1: has been successfully claimed.  This volume ID is used by Distributed Link Tracking to automatically repair file links, such as Shell Shortcuts and OLE links, when for some reason those links become broken.
//
#define EVENT_TRK_SERVICE_VOLUME_CLAIM   0x400030DAL

//
// MessageId: EVENT_TRK_SERVICE_DUPLICATE_VOLIDS
//
// MessageText:
//
// The volume ID for %1: has been reset, since it was a duplicate of that on %2:.  This volume ID is used by Distributed Link Tracking to automatically repair file links, such as Shell Shortcuts and OLE links, when for some reason those links become broken.
//
#define EVENT_TRK_SERVICE_DUPLICATE_VOLIDS 0x400030DBL

//
// MessageId: EVENT_TRK_SERVICE_MOVE_QUOTA_EXCEEDED
//
// MessageText:
//
// The move table quota for Distributed Link Tracking in this domain has been exceeded.  This table is used by Distributed Link Tracking to automatically repair file links, such as Shell Shortcuts and OLE links, when for some reason those links become broken.  While this quota is exceeded, it may not be possible to automatically repair some such broken links.
//
#define EVENT_TRK_SERVICE_MOVE_QUOTA_EXCEEDED 0x800030DCL


/////////////////////////////////////////////////////////////////////////
//
// ATM Protocol Events (13000-13499)
//
/////////////////////////////////////////////////////////////////////////

// ATM is removed from the OS so all strings that related to ATM are removed.

/////////////////////////////////////////////////////////////////////////
//
// File Replication Service (NtFrs) Events (13500-13999)
//
/////////////////////////////////////////////////////////////////////////

//
// MessageId: EVENT_FRS_ERROR
//
// MessageText:
//
// File Replication Service
//
#define EVENT_FRS_ERROR                  0xC00034BCL

//
// MessageId: EVENT_FRS_STARTING
//
// MessageText:
//
// The File Replication Service is starting.
//
#define EVENT_FRS_STARTING               0x400034BDL

//
// MessageId: EVENT_FRS_STOPPING
//
// MessageText:
//
// The File Replication Service is stopping.
//
#define EVENT_FRS_STOPPING               0x400034BEL

//
// MessageId: EVENT_FRS_STOPPED
//
// MessageText:
//
// The File Replication Service has stopped.
//
#define EVENT_FRS_STOPPED                0x400034BFL

//
// MessageId: EVENT_FRS_STOPPED_FORCE
//
// MessageText:
//
// The File Replication Service stopped without cleaning up.
//
#define EVENT_FRS_STOPPED_FORCE          0xC00034C0L

//
// MessageId: EVENT_FRS_STOPPED_ASSERT
//
// MessageText:
//
// The File Replication Service has stopped after taking an assertion failure.
//
#define EVENT_FRS_STOPPED_ASSERT         0xC00034C1L

//
// MessageId: EVENT_FRS_ASSERT
//
// MessageText:
//
// The File Replication Service failed a consistency check
// %n  (%3)
// %nin "%1" at line %2.
// %n
// %nThe File Replication Service will restart automatically at a later time.
// If this problem persists a subsequent entry in this event log describes the
// recovery procedure.
// %n
// For more information about the automatic restart right click on
// My Computer and then click on Manage, System Tools, Services,
// File Replication Service, and Recovery.
//
#define EVENT_FRS_ASSERT                 0xC00034C2L

//
// MessageId: EVENT_FRS_VOLUME_NOT_SUPPORTED
//
// MessageText:
//
// The File Replication Service cannot start replica set %1 on computer %2
// for directory %3 because the type of volume %4 is not NTFS 5.0 or later.
// %n
// %nThe volume's type can be found by typing "chkdsk %4".
// %n
// %nThe volume can be upgraded to NTFS 5.0 or later by typing "chkntfs /E %4".
//
#define EVENT_FRS_VOLUME_NOT_SUPPORTED   0xC00034C3L

//
// MessageId: EVENT_FRS_LONG_JOIN
//
// MessageText:
//
// The File Replication Service is having trouble enabling replication
// from %1 to %2 for %3 using the DNS name %4. FRS will keep retrying.
// %n Following are some of the reasons you would see this warning.
// %n
// %n [1] FRS can not correctly resolve the DNS name %4 from this computer.
// %n [2] FRS is not running on %4.
// %n [3] The topology information in the Active Directory for this replica has not
// yet replicated to all the Domain Controllers.
// %n
// %n This event log message will appear once per connection, After the problem
// is fixed you will see another event log message indicating that the connection
// has been established.
//
#define EVENT_FRS_LONG_JOIN              0x800034C4L

//
// MessageId: EVENT_FRS_LONG_JOIN_DONE
//
// MessageText:
//
// The File Replication Service has enabled replication from %1 to %2 for %3
// after repeated retries.
//
#define EVENT_FRS_LONG_JOIN_DONE         0x800034C5L

//
// MessageId: EVENT_FRS_CANNOT_COMMUNICATE
//
// MessageText:
//
// The File Replication Service on the computer %1 cannot communicate with
// the File Replication Service on the computer %2.
// %n
// %nVerify that the computer %2 is up and running.
// %n
// %nVerify that the File Replication Service is running on %2 by
// typing "net start ntfrs" on %2.
// %n
// %nVerify that the network is functioning between %1 and %2 by
// typing "ping %1" on %2 and "ping %2" on %1.
// If the pings succeed then retry the failed operation.
// If the pings fail then there may be problems with the DNS server.
// %n
// %nThe DNS server is responsible for mapping computer names to IP addresses.
// The commands "ipconfig" and "nslookup" help diagnose problems with the
// DNS server.
// %n
// %nTyping "ipconfig /all" will list the computer's IP address and the IP
// address of the computer's DNS servers. Type "ping <DNS server's IP address>"
// to verify that a DNS server is available. The DNS mapping for %2 or %1
// can be verified by typing "nslookup" and then typing "%2" and then "%1"
// on %1 and %2. Be sure to check out the DNS server on both %1 and %2;
// a DNS problem on either computer will prevent proper communication.
// %n
// %nSome network problems between %1 and %2 can be cleared up by flushing
// the DNS Resolver Cache. Type "ipconfig /flushdns".
// %n
// %nSome network problems between %1 and %2 can be cleared up by renewing
// the IP address. Type "ipconfig /release" followed by "ipconfig /renew".
// %n
// %nSome network problems between %1 and %2 can be cleared up by resetting
// the computer's DNS entry. Type "net stop NetLogon" followed by
// "net start NetLogon".
// %n
// %nSome problems between %1 and %2 can be cleared up by restarting
// the File Replication Service. Type "net stop ntfrs" followed by
// "net start ntfrs".
// %n
// %nSome problems between %1 and %2 can be cleared up by restarting
// the computers %1 and %2 AFTER CLOSING RUNNING APPLIATIONS,
// especially dcpromo. Click on Start, Shutdown, select Restart, and
// click on OK.
// %n
// %nOther network and computer problems are beyond the scope of
// this event log message.
//
#define EVENT_FRS_CANNOT_COMMUNICATE     0xC00034C6L

//
// MessageId: EVENT_FRS_DATABASE_SPACE
//
// MessageText:
//
// The File Replication Service is stopping on computer %1 because there is no free
// space on the volume containing %2.
// %n
// %nThe available space on the volume can be found by typing
// "dir %2".
// %n
// %nOnce free space is made available on the volume containing %2,
// the File Replication Service can be restarted immediately by typing
// "net start ntfrs". Otherwise, the File Replication Service will
// restart automatically at a later time.
// %n
// %nFor more information about the automatic restart right click on
// My Computer and then click on Manage, System Tools, Services, File
// Replication Service, and Recovery.
// %n
// %nFor more information about managing space on a volume type "copy /?",
// "rename /?", "del /?", "rmdir /?", and "dir /?".
//
#define EVENT_FRS_DATABASE_SPACE         0xC00034C7L

//
// MessageId: EVENT_FRS_DISK_WRITE_CACHE_ENABLED
//
// MessageText:
//
// The File Replication Service has detected an enabled disk write cache
// on the drive containing the directory %2 on the computer %1.
// The File Replication Service might not recover when power to the
// drive is interrupted and critical updates are lost.
//
#define EVENT_FRS_DISK_WRITE_CACHE_ENABLED 0x800034C8L

//
// MessageId: EVENT_FRS_JET_1414
//
// MessageText:
//
// The File Replication Service on computer %1 is stopping because the
// database %2 is corrupted.
// %n
// %nThe database can be recovered by typing "esentutl /d %2 /l%3 /s%4".
// %n
// %nOnce the database has been successfully recovered the
// File Replication Service can be restarted by typing "net start ntfrs".
//
#define EVENT_FRS_JET_1414               0xC00034C9L

//
// MessageId: EVENT_FRS_SYSVOL_NOT_READY
//
// MessageText:
//
// The File Replication Service may be preventing the computer %1 from becoming a
// domain controller while the system volume is being initialized with data
// from another domain controller and then shared as SYSVOL.
// %n
// %nType "net share" to check for the SYSVOL share. The File Replication
// Service has stopped preventing the computer from becoming a domain
// controller once the SYSVOL share appears.
// %n
// %nThe initialization of the system volume can take some time.
// The time is dependent on the amount of data in the system volume,
// the availability of other domain controllers, and the replication
// interval between domain controllers.
//
#define EVENT_FRS_SYSVOL_NOT_READY       0x800034CAL

//
// MessageId: EVENT_FRS_SYSVOL_NOT_READY_PRIMARY
//
// MessageText:
//
// The File Replication Service may be preventing the computer %1 from becoming a
// domain controller while the system volume is being initialized and then
// shared as SYSVOL.
// %n
// %nType "net share" to check for the SYSVOL share. The File Replication
// Service has stopped preventing the computer from becoming a domain
// controller once the SYSVOL share appears.
// %n
// %nThe initialization of the system volume can take some time.
// The time is dependent on the amount of data in the system volume.
// %n
// %nThe initialization of the system volume can be bypassed by first typing
// regedt32 and setting the value of SysvolReady to 1 and then restarting
// the Netlogon service.
// %n
// %nWARNING - BYPASSING THE SYSTEM VOLUME INITIALIZATION IS NOT RECOMMENDED.
// Applications may fail in unexpected ways.
// %n
// %nThe value SysvolReady is located by clicking on HKEY_LOCAL_MACHINE
// and then clicking on System, CurrentControlSet, Services, Netlogon,
// and Parameters.
// %n
// %nThe Netlogon service can be restarted by typing "net stop netlogon"
// followed by "net start netlogon".
//
#define EVENT_FRS_SYSVOL_NOT_READY_PRIMARY 0x800034CBL

//
// MessageId: EVENT_FRS_SYSVOL_READY
//
// MessageText:
//
// The File Replication Service is no longer preventing the computer %1 from
// becoming a domain controller. The system volume has been successfully
// initialized and the Netlogon service has been notified that the system
// volume is now ready to be shared as SYSVOL.
// %n
// %nType "net share" to check for the SYSVOL share.
//
#define EVENT_FRS_SYSVOL_READY           0x400034CCL

//
// MessageId: EVENT_FRS_ACCESS_CHECKS_DISABLED
//
// MessageText:
//
// The File Replication Service will not check access to the API "%1".
// %n
// %nAccess checks can be enabled for "%1" by running regedt32.
// %n
// %nClick on Start, Run, and type regedt32.
// %n
// %nClick on the window entitled HKEY_LOCAL_MACHINE. Double click on SYSTEM,
// CurrentControlSet, Services, NtFrs, Parameters, Access Checks, "%1", and "%2".
// Change the string to Enabled.
// %n
// %nPermissions can be changed by highlighting "%1" and then clicking on the
// toolbar option Security and then Permissions...
//
#define EVENT_FRS_ACCESS_CHECKS_DISABLED 0x800034CDL

//
// MessageId: EVENT_FRS_ACCESS_CHECKS_FAILED_USER
//
// MessageText:
//
// The File Replication Service did not grant the user "%3" access to the
// API "%1".
// %n
// %nPermissions for "%1" can be changed by running regedt32.
// %n
// %nClick on Start, Run, and type regedt32.
// %n
// %nClick on the window entitled HKEY_LOCAL_MACHINE. Double click on SYSTEM,
// CurrentControlSet, Services, NtFrs, Parameters, Access Checks, and highlight "%1".
// Click on the toolbar option Security and then Permissions...
// %n
// %nAccess checks can be disabled for "%1". Double click on "%2" and
// change the string to Disabled.
//
#define EVENT_FRS_ACCESS_CHECKS_FAILED_USER 0x800034CEL

//
// MessageId: EVENT_FRS_ACCESS_CHECKS_FAILED_UNKNOWN
//
// MessageText:
//
// The File Replication Service could not grant an unknown user access to the
// API "%1".
// %n
// %nAccess checks can be disabled for "%1" by running regedt32.
// %n
// %nClick on Start, Run, and type regedt32.
// %n
// %nClick on the window entitled HKEY_LOCAL_MACHINE. Double click on SYSTEM,
// CurrentControlSet, Services, NtFrs, Parameters, Access Checks, "%1", and "%2".
// Change the string to Disabled.
// %n
// %nPermissions can be changed by highlighting "%1" and then clicking on the
// toolbar option Security and then Permissions...
//
#define EVENT_FRS_ACCESS_CHECKS_FAILED_UNKNOWN 0xC00034CFL

//
// MessageId: EVENT_FRS_MOVED_PREEXISTING
//
// MessageText:
//
// The File Replication Service moved the preexisting files in %1 to %2.
// %n
// %nThe File Replication Service may delete the files in %2 at any time.
// Files can be saved from deletion by copying them out of %2. Copying
// the files into %1 may lead to name conflicts if the files already exist
// on some other replicating partner.
// %n
// %nIn some cases, the File Replication Service may copy a file
// from %2 into %1 instead of replicating the file from some other
// replicating partner.
// %n
// %nSpace can be recovered at any time by deleting the files in %2.
//
#define EVENT_FRS_MOVED_PREEXISTING      0x800034D0L

//
// MessageId: EVENT_FRS_CANNOT_START_BACKUP_RESTORE_IN_PROGRESS
//
// MessageText:
//
// The File Replication Service cannot enable replication on the comptuer %1
// until a backup/restore application completes.
// %n
// %nA backup/restore application has set a registry key that
// prevents the File Replication Service from starting until the registry
// key is deleted or the system is rebooted.
// %n
// %nThe backup/restore application may still be running. Check with your
// local administrator before proceeding further.
// %n
// %nThe computer can be rebooted by clicking on Start, Shutdown, and
// selecting Restart.
// %n
// %nWARNING - DELETING THE REGISTRY KEY IS NOT RECOMMENDED!
// Applications may fail in unexpected ways.
// %n
// %nThe registry key can be deleted by running regedt32.
// %n
// %nClick on Start, Run, and type regedt32.
// %n
// %nClick on the window entitled HKEY_LOCAL_MACHINE. Double click on SYSTEM,
// CurrentControlSet, Services, NtFrs, Parameters, Backup/Restore,
// "Stop NtFrs from Starting". On the toolbar, click on Edit and select
// Delete. Be careful! Deleting a key other than "Stop NtFrs From Starting"
// can have unexpected sideeffects.
//
#define EVENT_FRS_CANNOT_START_BACKUP_RESTORE_IN_PROGRESS 0xC00034D1L

//
// MessageId: EVENT_FRS_STAGING_AREA_FULL
//
// MessageText:
//
// The File Replication Service paused because the staging area is full.
// Replication will resume if staging space becomes available or if the
// staging space limit is increased.
// %n
// %nThe current value of the staging space limit is %1 KB.
// %n
// %nTo change the staging space limit, run regedt32.
// %n
// %nClick on Start, Run and type regedt32.
// %n
// %nClick on the window entitled HKEY_LOCAL_MACHINE. Double click on SYSTEM,
// CurrentControlSet, Services, NtFrs, Parameters, and the value
// "Staging Space Limit in KB".
//
#define EVENT_FRS_STAGING_AREA_FULL      0x800034D2L

//
// MessageId: EVENT_FRS_HUGE_FILE
//
// MessageText:
//
// The File Replication Service paused because the size of a file exceeds the
// staging space limit. Replication will resume only if the staging space limit
// is increased.
// %n
// %nThe staging space limit is %1 KB and the file size is %2 KB.
// %n
// %nTo change the staging space limit, run regedt32.
// %n
// %nClick on Start, Run and type regedt32.
// %n
// %nClick on the window entitled HKEY_LOCAL_MACHINE. Double click on SYSTEM,
// CurrentControlSet, Services, NtFrs, Parameters, and the value
// "Staging Space Limit in KB".
//
#define EVENT_FRS_HUGE_FILE              0x800034D3L

//
// MessageId: EVENT_FRS_CANNOT_CREATE_UUID
//
// MessageText:
//
// The File Replication Service is stopping on the computer %1 because
// a universally unique ID (UUID) cannot be created.
// %n
// %nThe SDK function UuidCreate() returned the error "%2".
// %n
// %nThe problem may be the lack of an Ethernet address,
// token ring address, or network address. The lack of a network
// address implies an unsupported netcard.
// %n
// %nThe File Replication Service will restart automatically at a later time.
// For more information about the automatic restart right click on
// My Computer and then click on Manage, System Tools, Services,
// File Replication Service, and Recovery.
//
#define EVENT_FRS_CANNOT_CREATE_UUID     0xC00034D4L

//
// MessageId: EVENT_FRS_NO_DNS_ATTRIBUTE
//
// MessageText:
//
// The File Replication Service cannot find the DNS name for the computer %1
// because the "%2" attribute could not be read from the distinguished
// name "%3".
// %n
// %nThe File Replication Service will try using the name "%1" until the
// computer's DNS name appears.
//
#define EVENT_FRS_NO_DNS_ATTRIBUTE       0x800034D5L

//
// MessageId: EVENT_FRS_NO_SID
//
// MessageText:
//
// The File Replication Service cannot replicate %1 with the computer
// %2 because the computer's SID cannot be determined from the distinguished
// name "%3".
// %n
// %nThe File Replication Service will retry later.
//
#define EVENT_FRS_NO_SID                 0xC00034D6L

//
// MessageId: NTFRSPRF_OPEN_RPC_BINDING_ERROR_SET
//
// MessageText:
//
// The RPC binding failed in the Open function of the FileReplicaSet Object. The
// counter data for this object will not be available. The FileReplicaSet object
// contains the performance counters of the Replica sets whose files are being
// replicated by the File Replication Service.
//
#define NTFRSPRF_OPEN_RPC_BINDING_ERROR_SET 0xC00034D7L

//
// MessageId: NTFRSPRF_OPEN_RPC_BINDING_ERROR_CONN
//
// MessageText:
//
// The RPC binding failed in the Open function of the FileReplicaConn Object. The
// counter data for this object will not be available. The FileReplicaConn object
// contains the performance counters of the connections over which files are being
// replicated by the File Replication Service.
//
#define NTFRSPRF_OPEN_RPC_BINDING_ERROR_CONN 0xC00034D8L

//
// MessageId: NTFRSPRF_OPEN_RPC_CALL_ERROR_SET
//
// MessageText:
//
// The RPC call failed in the Open function of the FileReplicaSet Object. The
// counter data for this object will not be available. The FileReplicaSet object
// contains the performance counters of the Replica sets whose files are being
// replicated by the File Replication Service.
//
#define NTFRSPRF_OPEN_RPC_CALL_ERROR_SET 0xC00034D9L

//
// MessageId: NTFRSPRF_OPEN_RPC_CALL_ERROR_CONN
//
// MessageText:
//
// The RPC call failed in the Open function of the FileReplicaConn Object. The
// counter data for this object will not be available. The FileReplicaConn object
// contains the performance counters of the connections over which files are being
// replicated by the File Replication Service.
//
#define NTFRSPRF_OPEN_RPC_CALL_ERROR_CONN 0xC00034DAL

//
// MessageId: NTFRSPRF_COLLECT_RPC_BINDING_ERROR_SET
//
// MessageText:
//
// The RPC binding failed in the Collect function of the FileReplicaSet Object. The
// counter data for this object will not be available till the binding succeeds.
// The FileReplicaSet object contains the performance counters of the Replica sets
// whose files are being replicated by the File Replication Service.
//
#define NTFRSPRF_COLLECT_RPC_BINDING_ERROR_SET 0xC00034DBL

//
// MessageId: NTFRSPRF_COLLECT_RPC_BINDING_ERROR_CONN
//
// MessageText:
//
// The RPC binding failed in the Collect function of the FileReplicaConn Object.
// The counter data for this object will not be available till the binding
// succeeds. The FileReplicaConn object contains the performance counters of the
// connections over which files are being replicated by the File Replication
// Service.
//
#define NTFRSPRF_COLLECT_RPC_BINDING_ERROR_CONN 0xC00034DCL

//
// MessageId: NTFRSPRF_COLLECT_RPC_CALL_ERROR_SET
//
// MessageText:
//
// The RPC call failed in the Collect function of the FileReplicaSet Object. The
// counter data for this object will not be available till the call succeeds. The
// FileReplicaSet object contains the performance counters of the Replica sets
// whose files are being replicated by the File Replication Service.
//
#define NTFRSPRF_COLLECT_RPC_CALL_ERROR_SET 0xC00034DDL

//
// MessageId: NTFRSPRF_COLLECT_RPC_CALL_ERROR_CONN
//
// MessageText:
//
// The RPC call failed in the Collect function of the FileReplicaConn Object. The
// counter data for this object will not be available till the call succeeds. The
// FileReplicaConn object contains the performance counters of the connections over
// which files are being replicated by the File Replication Service.
//
#define NTFRSPRF_COLLECT_RPC_CALL_ERROR_CONN 0xC00034DEL

//
// MessageId: NTFRSPRF_VIRTUALALLOC_ERROR_SET
//
// MessageText:
//
// The call to VirtualAlloc failed in the Open function of the FileReplicaSet
// Object. The counter data for this object will not be available. The
// FileReplicaSet object contains the performance counters of the Replica sets
// whose files are being replicated by the File Replication Service.
//
#define NTFRSPRF_VIRTUALALLOC_ERROR_SET  0xC00034DFL

//
// MessageId: NTFRSPRF_VIRTUALALLOC_ERROR_CONN
//
// MessageText:
//
// The call to VirtualAlloc failed in the Open function of the FileReplicaConn
// Object. The counter data for this object will not be available. The
// FileReplicaConn object contains the performance counters of the connections over
// which files are being replicated by the File Replication Service.
//
#define NTFRSPRF_VIRTUALALLOC_ERROR_CONN 0xC00034E0L

//
// MessageId: NTFRSPRF_REGISTRY_ERROR_SET
//
// MessageText:
//
// The call to the Registry failed in the Open function of the FileReplicaSet
// Object. The counter data for this object will not be available. The
// FileReplicaSet object contains the performance counters of the Replica sets
// whose files are being replicated by the File Replication Service.
//
#define NTFRSPRF_REGISTRY_ERROR_SET      0xC00034E1L

//
// MessageId: NTFRSPRF_REGISTRY_ERROR_CONN
//
// MessageText:
//
// The call to the Registry failed in the Open function of the FileReplicaConn
// Object. The counter data for this object will not be available. The
// FileReplicaConn object contains the performance counters of the connections over
// which files are being replicated by the File Replication Service.
//
#define NTFRSPRF_REGISTRY_ERROR_CONN     0xC00034E2L

//
// MessageId: EVENT_FRS_ROOT_NOT_VALID
//
// MessageText:
//
// The File Replication Service cannot replicate %1 because the
// pathname of the replicated directory is not the fully qualified
// pathname of an existing, accessible local directory.
//
#define EVENT_FRS_ROOT_NOT_VALID         0xC00034E3L

//
// MessageId: EVENT_FRS_STAGE_NOT_VALID
//
// MessageText:
//
// The File Replication Service cannot replicate %1 because the pathname
// of the customer designated staging directory:
// %n    %2
// %n is not the fully qualified pathname of an existing, accessible local directory.
//
#define EVENT_FRS_STAGE_NOT_VALID        0xC00034E4L

//
// MessageId: EVENT_FRS_OVERLAPS_LOGGING
//
// MessageText:
//
// The File Replication Service cannot replicate %1 because it overlaps
// the File Replication Service's logging pathname %2.
//
#define EVENT_FRS_OVERLAPS_LOGGING       0xC00034E5L

//
// MessageId: EVENT_FRS_OVERLAPS_WORKING
//
// MessageText:
//
// The File Replication Service cannot replicate %1 because it overlaps
// the File Replication Service's working directory %2.
//
#define EVENT_FRS_OVERLAPS_WORKING       0xC00034E6L

//
// MessageId: EVENT_FRS_OVERLAPS_STAGE
//
// MessageText:
//
// The File Replication Service cannot replicate %1 because it overlaps
// the staging directory %2.
//
#define EVENT_FRS_OVERLAPS_STAGE         0xC00034E7L

//
// MessageId: EVENT_FRS_OVERLAPS_ROOT
//
// MessageText:
//
// The File Replication Service cannot replicate %1 because it overlaps
// the replicating directory %2.
//
#define EVENT_FRS_OVERLAPS_ROOT          0xC00034E8L

//
// MessageId: EVENT_FRS_OVERLAPS_OTHER_STAGE
//
// MessageText:
//
// The File Replication Service cannot replicate %1 because it overlaps
// the staging directory %2 of the replicating directory %3.
//
#define EVENT_FRS_OVERLAPS_OTHER_STAGE   0xC00034E9L

//
// MessageId: EVENT_FRS_PREPARE_ROOT_FAILED
//
// MessageText:
//
// The File Replication Service could not prepare the root directory
// %1 for replication.  This is likely due to a problem creating the
// root directory or a problem removing preexisting files in the root
// directory.
// %n
// %nCheck that the path leading up to the root directory exists and is
// accessible.
//
#define EVENT_FRS_PREPARE_ROOT_FAILED    0xC00034EAL

//
// MessageId: EVENT_FRS_BAD_REG_DATA
//
// MessageText:
//
// The File Replication Service detected an invalid parameter value in the
// registry.  %1.
// %n
// %nThe expected registry key name is "%2".
// %nThe expected value name is "%3".
// %nThe expected registry data type is %4.
// %nThe allowed range for this parameter is %5
// %nThe data units for this parameter value are %6.
// %nThe File Replication Service is using a default value of "%7".
// %n
// %nTo change this parameter, run regedt32.
// %n
// %nClick on Start, Run and type regedt32.
// %n
// %nClick on the window entitled HKEY_LOCAL_MACHINE.
// %nClick down the key path: "%8"
// %nDouble click on the value name -
// %n    "%9"
// %nand update the value.
// %nIf the value name is not present you may add it with the Add Value function
// under the Edit Menu item. Type the value name exactly as shown above using the
// above registry data type.  Make sure you observe the data units and allowed range
// when entering the value.
//
#define EVENT_FRS_BAD_REG_DATA           0x800034EBL

//
// MessageId: EVENT_FRS_JOIN_FAIL_TIME_SKEW
//
// MessageText:
//
// The File Replication Service is unable to replicate with its partner computer
// because the difference in clock times is outside the range of plus or minus
// %1 minutes.
// %n
// %nThe connection to the partner computer is:
// %n  "%2"
// %nThe detected time difference is:  %3 minutes.
// %n
// %nNote: If this time difference is close to a multiple of 60 minutes then it
// is likely that either this computer or its partner computer was set to the
// incorrect time zone when the computer time was initially set.  Check that
// the time zone and the system time are correctly set on both computers.
// %n
// %nIf necessary, the default value used to test for computer time consistency
// may be changed in the registry on this computer.  (Note: This is not recommended.)
// %n
// %nTo change this parameter, run regedt32.
// %n
// %nClick on Start, Run and type regedt32.
// %n
// %nClick on the window entitled HKEY_LOCAL_MACHINE.
// %nClick down the key path:
// %n   "System\CurrentControlSet\Services\NtFrs\Parameters"
// %nDouble click on the value name
// %n   "Partner Clock Skew In Minutes"
// %nand update the value.
// %n
// %nIf the value name is not present you may add it with the Add Value function
// under the Edit Menu item. Type the value name exactly as shown above using the
// the registry data type REG_DWORD.
//
#define EVENT_FRS_JOIN_FAIL_TIME_SKEW    0xC00034ECL

//
// MessageId: EVENT_FRS_RMTCO_TIME_SKEW
//
// MessageText:
//
// The File Replication Service is unable to replicate from a partner computer
// because the event time associated with the file to be replicated is too far
// into the future.  It is %1 minutes greater than the current time.  This can
// happen if the system time on the partner computer was set incorrectly when
// the file was created or updated.  To preserve the integrity of the replica
// set this file update will not be performed or propagated further.
// %n
// %nThe file name is: "%2"
// %nThe connection to the partner computer is:
// %n  "%3"
// %n
// %nNote: If this time difference is close to a multiple of 60 minutes then it
// is likely that this file may have been created or updated on the partner
// computer while the computer was set to the incorrect time zone when its
// computer time was initially set.  Check that the timezone and time are
// correctly set on the partner computer.
//
#define EVENT_FRS_RMTCO_TIME_SKEW        0xC00034EDL

//
// MessageId: EVENT_FRS_CANT_OPEN_STAGE
//
// MessageText:
//
// The File Replication Service is unable to open the customer designated
// staging directory for replica set %1.  The path used for the staging
// directory is,
// %n    "%2"
// %nThe customer designated root path for this replica set is:
// %n    "%3"
// %n
// The service is unable to start replication on this replica set.  Among the
// possible errors to check are:
// %n  --  an invalid staging path,
// %n  --  a missing directory,
// %n  --  a missing disk volume,
// %n  --  a file system on the volume that does not support ACLs,
// %n  --  a sharing conflict on the staging directory with some other application.
// %n
// %nCorrect the problem and the service will attempt to restart replication
// automatically at a later time.
//
#define EVENT_FRS_CANT_OPEN_STAGE        0xC00034EEL

//
// MessageId: EVENT_FRS_CANT_OPEN_PREINSTALL
//
// MessageText:
//
// The File Replication Service is unable to open (or create) the pre-install
// directory under the customer designated replica tree directory for
// replica set %1.  The path used for the pre-install
// directory is,
// %n    "%2"
// %nThe customer designated root path for this replica set is:
// %n    "%3"
// %n
// The service is unable to start replication on this replica set.  Among the
// possible errors to check are:
// %n  --  an invalid root path,
// %n  --  a missing directory,
// %n  --  a missing disk volume,
// %n  --  a file system on the volume that does not support NTFS 5.0
// %n  --  a sharing conflict on the pre-install directory with some other application.
// %n
// %nCorrect the problem and the service will attempt to restart replication
// automatically at a later time.
//
#define EVENT_FRS_CANT_OPEN_PREINSTALL   0xC00034EFL

//
// MessageId: EVENT_FRS_REPLICA_SET_CREATE_FAIL
//
// MessageText:
//
// The File Replication Service is unable to add this computer to the following
// replica set:
// %n    "%1"
// %n
// %nThis could be caused by a number of problems such as:
// %n  --  an invalid root path,
// %n  --  a missing directory,
// %n  --  a missing disk volume,
// %n  --  a file system on the volume that does not support NTFS 5.0
// %n
// %nThe information below may help to resolve the problem:
// %nComputer DNS name is "%2"
// %nReplica set member name is "%3"
// %nReplica set root path is "%4"
// %nReplica staging directory path is "%5"
// %nReplica working directory path is "%6"
// %nWindows error status code is %7
// %nFRS error status code is %8
// %n
// %nOther event log messages may also help determine the problem.  Correct the
// problem and the service will attempt to restart replication automatically at
// a later time.
//
#define EVENT_FRS_REPLICA_SET_CREATE_FAIL 0xC00034F0L

//
// MessageId: EVENT_FRS_REPLICA_SET_CREATE_OK
//
// MessageText:
//
// The File Replication Service successfully added this computer to the following
// replica set:
// %n    "%1"
// %n
// %nInformation related to this event is shown below:
// %nComputer DNS name is "%2"
// %nReplica set member name is "%3"
// %nReplica set root path is "%4"
// %nReplica staging directory path is "%5"
// %nReplica working directory path is "%6"
//
#define EVENT_FRS_REPLICA_SET_CREATE_OK  0x400034F1L

//
// MessageId: EVENT_FRS_REPLICA_SET_CXTIONS
//
// MessageText:
//
// The File Replication Service successfully added the connections shown below
// to the replica set:
// %n    "%1"
// %n
// %n    %2
// %n    %3
// %n    %4
// %n    %5
// %n    %6
// %n    %7
// %n    %8
// %n    %9
// %n
// %nMore information may appear in subsequent event log messages.
//
#define EVENT_FRS_REPLICA_SET_CXTIONS    0x400034F2L

//
// MessageId: EVENT_FRS_IN_ERROR_STATE
//
// MessageText:
//
// The File Replication Service is in an error state. Files will not replicate
// to or from one or all of the replica sets on his computer until the
// following recovery steps are performed:
// %n
// %n Recovery Steps:
// %n
// %n [1] The error state may clear itself if you stop and restart the FRS service.
// This can be done by performing the following in a command window:
// %n
// %n    net stop ntfrs
// %n    net start ntfrs
// %n
// %nIf this fails to clear up the problem then proceed as follows.
// %n
// %n [2] For Active Directory Domain Controllers that DO NOT host any DFS
// alternates or other replica sets with replication enabled:
// %n
// %nIf there is at least one other Domain Controller in this domain then
// restore the "system state" of this DC from backup (using ntbackup or other
// backup-restore utility) and make it non-authoritative.
// %n
// %nIf there are NO other Domain Controllers in this domain then restore
// the "system state" of this DC from backup (using ntbackup or other
// backup-restore utility) and choose the Advanced option which marks
// the sysvols as primary.
// %n
// %nIf there are other Domain Controllers in this domain but ALL of
// them have this event log message then restore one of them as primary
// (data files from primary will replicate everywhere) and the others as
// non-authoritative.
// %n
// %n
// %n [3] For Active Directory Domain Controllers that host DFS alternates
// or other replica sets with replication enabled:
// %n
// %n (3-a) If the Dfs alternates on this DC do not have any other replication
// partners then copy the data under that Dfs share to a safe location.
// %n (3-b) If this server is the only Active Directory Domain Controller for this
// domain then, before going to (3-c),  make sure this server does not have any
// inbound or outbound connections to other servers that were formerly Domain
// Controllers for this domain but are now off the net (and will never be
// coming back online) or have been fresh installed without being demoted.
// To delete connections use the Sites and Services snapin and look for
// %nSites->NAME_OF_SITE->Servers->NAME_OF_SERVER->NTDS Settings->CONNECTIONS.
// %n (3-c) Restore the "system state" of this DC from backup (using ntbackup
// or other backup-restore utility) and make it non-authoritative.
// %n (3-d) Copy the data from step (3-a) above to the original location
// after the sysvol share is published.
// %n
// %n
// %n [4] For other Windows 2000 servers:
// %n
// %n (4-a)  If any of the DFS alternates or other replica sets hosted by
// this server do not have any other replication partners then copy the
// data under its share or replica tree root to a safe location.
// %n (4-b)  net stop ntfrs
// %n (4-c)  rd /s /q  %1
// %n (4-d)  net start ntfrs
// %n (4-e)  Copy the data from step (4-a) above to the original location after
// the service has initialized (5 minutes is a safe waiting time).
// %n
// %nNote: If this error message is in the eventlog of all the members of a
// particular replica set then perform steps (4-a) and (4-e) above on only
// one of the members.
//
#define EVENT_FRS_IN_ERROR_STATE         0xC00034F3L

//
// MessageId: EVENT_FRS_REPLICA_NO_ROOT_CHANGE
//
// MessageText:
//
// The File Replication Service has detected what appears to be an attempt
// to change the root path for the following replica set:
// %n    "%1"
// %n
// %nThis is not allowed.  To perform this operation you must remove this member
// from the replica set and add the member back with the new root path.
// %n
// %nIt is possible that this is a transient error due to Active Directory
// replication delays associated with updating FRS configuration objects.  If
// file replication does not take place after an appropriate waiting time,
// which could be several hours if cross site Active Directory replication
// is required, you must delete and re-add this member to the replica set.
// %n
// %nInformation related to this event is shown below:
// %nComputer DNS name is "%2"
// %nReplica set member name is "%3"
// %nThe current Replica set root path is "%4"
// %nThe desired new Replica set root path is "%5"
// %nReplica staging directory path is "%6"
//
#define EVENT_FRS_REPLICA_NO_ROOT_CHANGE 0xC00034F4L

//
// MessageId: EVENT_FRS_DUPLICATE_IN_CXTION_SYSVOL
//
// MessageText:
//
// The File Replication Service has detected a duplicate connection object between
// this computer "%6" and a computer named "%1".
// %nThis was detected for the following replica set:
// %n    "%2"
// %n
// %nThis is not allowed and replication will not occur between these two
// computers until the duplicate connection objects are removed.
// %n
// %nIt is possible that this is a transient error due to Active Directory
// replication delays associated with updating FRS configuration objects.  If
// file replication does not take place after an appropriate waiting time,
// which could be several hours if cross site Active Directory replication
// is required, you must manually delete the duplicate connection objects by
// following the steps below:
// %n
// %n [1] Start the Active Directory Sites and Services Snapin.
// %n [2] Click on "%3, %4, %5, %6, %7".
// %n [3] Look for duplicate connections from "%1" in site "%8".
// %n [4] Delete all but one of the connections.
//
#define EVENT_FRS_DUPLICATE_IN_CXTION_SYSVOL 0xC00034F5L

//
// MessageId: EVENT_FRS_DUPLICATE_IN_CXTION
//
// MessageText:
//
// The File Replication Service has detected a duplicate connection object between
// this computer "%7" and a computer named "%1".
// %nThis was detected for the following replica set:
// %n    "%2"
// %n
// %nThis is not allowed and replication will not occur between these two
// computers until the duplicate connection objects are removed.
// %n
// %nIt is possible that this is a transient error due to Active Directory
// replication delays associated with updating FRS configuration objects.  If
// file replication does not take place after an appropriate waiting time,
// which could be several hours if cross site Active Directory replication
// is required, you must manually delete the duplicate connection objects by
// following the steps below:
// %n
// %n [1] Start the Active Directory Users and Computers Snapin.
// %n [2] Click the view button and advanced features to display the system node.
// %n [3] Click on "%3, %4, %5".
// %n [4] Under "%5" you will see one or more DFS related replica set objects.
// Look for the FRS member object "%6" under the subtree for replica set "%2".
// %n [5] Under "%6" look for duplicate connections from "%1".
// %n [6] Delete all but one of the connections.
//
#define EVENT_FRS_DUPLICATE_IN_CXTION    0xC00034F6L

//
// MessageId: EVENT_FRS_ROOT_HAS_MOVED
//
// MessageText:
//
// The File Replication Service has detected that the replica root path has changed
// from "%2" to "%3". If this is an intentional move then a file with the name
// NTFRS_CMD_FILE_MOVE_ROOT needs to be created under the new root path.
// %nThis was detected for the following replica set:
// %n    "%1"
// %n
// %nChanging the replica root path is a two step process which is triggered by
// the creation of the NTFRS_CMD_FILE_MOVE_ROOT file.
// %n
// %n [1] At the first poll which will occur in %4 minutes this computer will be
// deleted from the replica set.
// %n [2] At the poll following the deletion this computer will be re-added to the
// replica set with the new root path. This re-addition will trigger a full tree
// sync for the replica set. At the end of the sync all the files will be at the new
// location. The files may or may not be deleted from the old location depending on whether
// they are needed or not.
//
#define EVENT_FRS_ROOT_HAS_MOVED         0xC00034F7L

//
// MessageId: EVENT_FRS_ERROR_REPLICA_SET_DELETED
//
// MessageText:
//
// The File Replication Service is deleting this computer from the replica set "%1" as an attempt to
// recover from the error state,
// %n Error status = %2
// %n At the next poll, which will occur in %3 minutes, this computer will be re-added to the
// replica set. The re-addition will trigger a full tree sync for the replica set.
//
#define EVENT_FRS_ERROR_REPLICA_SET_DELETED 0x800034F8L

//
// MessageId: EVENT_FRS_REPLICA_IN_JRNL_WRAP_ERROR
//
// MessageText:
//
// The File Replication Service has detected that the replica set "%1" is in JRNL_WRAP_ERROR.
// %n
// %n Replica set name is    : "%1"
// %n Replica root path is   : "%2"
// %n Replica root volume is : "%3"
// %n
// 
// A Replica set hits JRNL_WRAP_ERROR when the record that it is trying to read from the NTFS USN journal is not found.
// This can occur because of one of the following reasons.
// %n
// %n [1] Volume "%3" has been formatted.
// %n [2] The NTFS USN journal on volume "%3" has been deleted.
// %n [3] The NTFS USN journal on volume "%3" has been truncated. Chkdsk can truncate
// the journal if it finds corrupt entries at the end of the journal.
// %n [4] File Replication Service was not running on this computer for a long time.
// %n [5] File Replication Service could not keep up with the rate of Disk IO activity on "%3".
// %n
// %n Following recovery steps will be taken to automatically recover from this error state.
// %n [1] At the first poll which will occur in %4 minutes this computer will be
// deleted from the replica set.
// %n [2] At the poll following the deletion this computer will be re-added to the
// replica set. The re-addition will trigger a full tree sync for the replica set.
//
#define EVENT_FRS_REPLICA_IN_JRNL_WRAP_ERROR 0xC00034F9L

//
// MessageId: EVENT_FRS_DS_POLL_ERROR_SUMMARY
//
// MessageText:
//
// Following is the summary of warnings and errors encountered by File Replication Service
// while polling the Domain Controller %1 for FRS replica set configuration information.
// %n
// %n %2
// %n
//
#define EVENT_FRS_DS_POLL_ERROR_SUMMARY  0x800034FAL

/////////////////////////////////////////////////////////////////////////
//
// PSCHED Events
//
// Codes 14000 - 14299
//
/////////////////////////////////////////////////////////////////////////
//
// Driver wide events (14000 - 14099)
//
//
// MessageId: EVENT_PS_GPC_REGISTER_FAILED
//
// MessageText:
//
// QoS: The Packet Scheduler failed to register with the Generic Packet Classifier (msgpc.sys).
//
#define EVENT_PS_GPC_REGISTER_FAILED     0xC00036B0L

//
// MessageId: EVENT_PS_NO_RESOURCES_FOR_INIT
//
// MessageText:
//
// QoS: The Packet Scheduler was unable to allocate required resources for initialization.
//
#define EVENT_PS_NO_RESOURCES_FOR_INIT   0xC00036B1L

//
// MessageId: EVENT_PS_REGISTER_PROTOCOL_FAILED
//
// MessageText:
//
// QoS: The Packet Scheduler failed to register as a protocol with NDIS.
//
#define EVENT_PS_REGISTER_PROTOCOL_FAILED 0xC00036B2L

//
// MessageId: EVENT_PS_REGISTER_MINIPORT_FAILED
//
// MessageText:
//
// QoS: The Packet Scheduler failed to register as a miniport with NDIS.
//
#define EVENT_PS_REGISTER_MINIPORT_FAILED 0xC00036B3L

//
// Adapter events (14100 - 14199)
//
//
// MessageId: EVENT_PS_BAD_BESTEFFORT_LIMIT
//
// MessageText:
//
// QoS [Adapter %2]:%nThe BestEffortLimit value set in the registry exceeds the LinkSpeed. Defaulting to Unlimited BestEffort.
//
#define EVENT_PS_BAD_BESTEFFORT_LIMIT    0x80003714L

//
// MessageId: EVENT_PS_QUERY_OID_GEN_MAXIMUM_FRAME_SIZE
//
// MessageText:
//
// QoS [Adapter %2]:%nThe network adapter driver failed the query for OID_GEN_MAXIMUM_FRAME_SIZE.
//
#define EVENT_PS_QUERY_OID_GEN_MAXIMUM_FRAME_SIZE 0xC0003715L

//
// MessageId: EVENT_PS_QUERY_OID_GEN_MAXIMUM_TOTAL_SIZE
//
// MessageText:
//
// QoS [Adapter %2]:%nThe network adapter driver failed the query for OID_GEN_MAXIMUM_TOTAL_SIZE.
//
#define EVENT_PS_QUERY_OID_GEN_MAXIMUM_TOTAL_SIZE 0xC0003716L

//
// MessageId: EVENT_PS_QUERY_OID_GEN_LINK_SPEED
//
// MessageText:
//
// QoS [Adapter %2]:%nThe network adapter driver failed the query for OID_GEN_LINK_SPEED.
//
#define EVENT_PS_QUERY_OID_GEN_LINK_SPEED 0xC0003717L

//
// MessageId: EVENT_PS_BINDING_FAILED
//
// MessageText:
//
// QoS [Adapter %2]:%nThe Packet Scheduler failed to bind to the network adapter's miniport driver.
//
#define EVENT_PS_BINDING_FAILED          0xC0003718L

//
// MessageId: EVENT_PS_MISSING_ADAPTER_REGISTRY_DATA
//
// MessageText:
//
// QoS [Adapter %2]:%nThe UpperBindings key is missing from the registry.
//
#define EVENT_PS_MISSING_ADAPTER_REGISTRY_DATA 0xC0003719L

//
// MessageId: EVENT_PS_REGISTER_ADDRESS_FAMILY_FAILED
//
// MessageText:
//
// QoS [Adapter %2]:%nThe Packet Scheduler was unable to register with the NDISWAN Call Manager.
//
#define EVENT_PS_REGISTER_ADDRESS_FAMILY_FAILED 0xC000371AL

//
// MessageId: EVENT_PS_INIT_DEVICE_FAILED
//
// MessageText:
//
// QoS [Adapter %2]:%nThe Packet Scheduler could not initialize the virtual miniport with NDIS.
//
#define EVENT_PS_INIT_DEVICE_FAILED      0xC000371BL

//
// MessageId: EVENT_PS_WMI_INSTANCE_NAME_FAILED
//
// MessageText:
//
// QoS [Adapter %2]:%nThe Packet Scheduler could not obtain the network adapter's friendly name from NDIS.
//
#define EVENT_PS_WMI_INSTANCE_NAME_FAILED 0xC000371CL

//
// MessageId: EVENT_PS_WAN_LIMITED_BESTEFFORT
//
// MessageText:
//
// QoS [Adapter %2]:%nThe registry entry for BestEffortLimit is not supported over WAN links. Defaulting to Unlimited BestEffort mode.
//
#define EVENT_PS_WAN_LIMITED_BESTEFFORT  0x8000371DL

//
// MessageId: EVENT_PS_RESOURCE_POOL
//
// MessageText:
//
// QoS [Adapter %2]:%nCould not initialize due to insufficient nonpaged pool memory.
//
#define EVENT_PS_RESOURCE_POOL           0xC000371EL

//
// MessageId: EVENT_PS_ADMISSIONCONTROL_OVERFLOW
//
// MessageText:
//
// QoS [Adapter %2]:%nTotal bandwidth allocated to flows exceeds the NonBestEffortLimit. This is because of a reduction in the LinkSpeed or because of a change to the NonBestEffortLimit registry key.
//
#define EVENT_PS_ADMISSIONCONTROL_OVERFLOW 0x8000371FL

//
// MessageId: EVENT_PS_NETWORK_ADDRESS_FAIL
//
// MessageText:
//
// QoS [Adapter %2]:%nCould not allocate non-paged pool memory for storing network addresses.
//
#define EVENT_PS_NETWORK_ADDRESS_FAIL    0xC0003720L


/////////////////////////////////////////////////////////////////////////
//
// Distributed File System (Dfs) Events (14300-14599)
//
/////////////////////////////////////////////////////////////////////////

//
// Server-side (dfs.sys) errors (14300-14399)
//
// NOTE: events 14300-14317 are UNUSED as of WS03. They need to remain so that
//       downlevel eventlogs can be parsed by uplevel systems.
//
//
// MessageId: EXTRA_EXIT_POINT
//
// MessageText:
//
// An extra ExitPoint %2 was found at server %3
//
#define EXTRA_EXIT_POINT                 0xC00037DCL

//
// MessageId: MISSING_EXIT_POINT
//
// MessageText:
//
// The ExitPoint %2 was missing at server %3
//
#define MISSING_EXIT_POINT               0xC00037DDL

//
// MessageId: MISSING_VOLUME
//
// MessageText:
//
// The Volume %2 was missing at server %3
//
#define MISSING_VOLUME                   0xC00037DEL

//
// MessageId: EXTRA_VOLUME
//
// MessageText:
//
// The extra Volume %2 was found at server %3
//
#define EXTRA_VOLUME                     0xC00037DFL

//
// MessageId: EXTRA_EXIT_POINT_DELETED
//
// MessageText:
//
// The extra ExitPoint %2 was deleted successfully from the server %3
//
#define EXTRA_EXIT_POINT_DELETED         0xC00037E0L

//
// MessageId: EXTRA_EXIT_POINT_NOT_DELETED
//
// MessageText:
//
// Unable to delete the extra ExitPoint %2 at the server %3
//
#define EXTRA_EXIT_POINT_NOT_DELETED     0xC00037E1L

//
// MessageId: MISSING_EXIT_POINT_CREATED
//
// MessageText:
//
// The missing ExitPoint %2 was created at the server %3 successfully
//
#define MISSING_EXIT_POINT_CREATED       0xC00037E2L

//
// MessageId: MISSING_EXIT_POINT_NOT_CREATED
//
// MessageText:
//
// Unable to create the missing Exit Point %2 at the server %3
//
#define MISSING_EXIT_POINT_NOT_CREATED   0xC00037E3L

//
// MessageId: MISSING_VOLUME_CREATED
//
// MessageText:
//
// Successfully created the missing volume %2 knowledge at the server %3
//
#define MISSING_VOLUME_CREATED           0xC00037E4L

//
// MessageId: MISSING_VOLUME_NOT_CREATED
//
// MessageText:
//
// Unable to create the missing Volume %2 info at server %3
//
#define MISSING_VOLUME_NOT_CREATED       0xC00037E5L

//
// MessageId: EXTRA_VOLUME_DELETED
//
// MessageText:
//
// The extra Volume %2 info was deleted at server %3
//
#define EXTRA_VOLUME_DELETED             0xC00037E6L

//
// MessageId: EXTRA_VOLUME_NOT_DELETED
//
// MessageText:
//
// The extra Volume %2 info was not deleted at server %3
//
#define EXTRA_VOLUME_NOT_DELETED         0xC00037E7L

//
// MessageId: COULD_NOT_VERIFY_VOLUMES
//
// MessageText:
//
// Since the DC %2 was unavailable could not verify volumes knowledge.
//
#define COULD_NOT_VERIFY_VOLUMES         0xC00037E8L

//
// MessageId: KNOWLEDGE_INCONSISTENCY_DETECTED
//
// MessageText:
//
// Detected Knowledge inconsistency with the volume %2 at server %3
//
#define KNOWLEDGE_INCONSISTENCY_DETECTED 0xC00037E9L

//
// MessageId: PREFIX_MISMATCH
//
// MessageText:
//
// The local Prefix %2 was represented as %3 at remote server %4
//
#define PREFIX_MISMATCH                  0xC00037EAL

//
// MessageId: PREFIX_MISMATCH_FIXED
//
// MessageText:
//
// The remote Prefix %3 was corrected to %2 at remote server %4
//
#define PREFIX_MISMATCH_FIXED            0xC00037EBL

//
// MessageId: PREFIX_MISMATCH_NOT_FIXED
//
// MessageText:
//
// The remote Prefix %3 was NOT corrected to %2 at remote server %4
//
#define PREFIX_MISMATCH_NOT_FIXED        0xC00037ECL

//
// MessageId: MACHINE_UNJOINED
//
// MessageText:
//
// The machine %2 has become unlinked from the domain. Re-join the machine the machine to this domain.
//
#define MACHINE_UNJOINED                 0xC00037EDL

//
// MessageId: DFS_REFERRAL_REQUEST
//
// MessageText:
//
// Dfs received a referral request for "%2".  The return code is in the data.
//
#define DFS_REFERRAL_REQUEST             0x400037EEL

//
// Client-side Dfs (mup.sys) errors (14400-14499)
//
// NOTE: events 14400-14407 are UNUSED as of Vista. They need to remain so that
//       downlevel eventlogs can be parsed by uplevel systems.
//
//
// MessageId: NOT_A_DFS_PATH
//
// MessageText:
//
// The path "%2" is not a dfs path
//
#define NOT_A_DFS_PATH                   0x40003840L

//
// MessageId: LM_REDIR_FAILURE
//
// MessageText:
//
// Dfs was unable to open the Lan Redir
//
#define LM_REDIR_FAILURE                 0x40003841L

//
// MessageId: DFS_CONNECTION_FAILURE
//
// MessageText:
//
// Dfs was unable to open a connection to server %2.  The error returned is in the record data.
//
#define DFS_CONNECTION_FAILURE           0x40003842L

//
// MessageId: DFS_REFERRAL_FAILURE
//
// MessageText:
//
// Dfs was unable to obtain a referral for "%2" from %3.  The error returned is in the record data.
//
#define DFS_REFERRAL_FAILURE             0x40003843L

//
// MessageId: DFS_REFERRAL_SUCCESS
//
// MessageText:
//
// Dfs obtained a referral for "%2" from %3
//
#define DFS_REFERRAL_SUCCESS             0x40003844L

//
// MessageId: DFS_MAX_DNR_ATTEMPTS
//
// MessageText:
//
// Dfs reached its limit of attempts of resolution of "%2".
//
#define DFS_MAX_DNR_ATTEMPTS             0x40003845L

//
// MessageId: DFS_SPECIAL_REFERRAL_FAILURE
//
// MessageText:
//
// Dfs was unable to obtain the special referral table from %2.  The error returned is in the record data.
//
#define DFS_SPECIAL_REFERRAL_FAILURE     0x40003846L

//
// MessageId: DFS_OPEN_FAILURE
//
// MessageText:
//
// Dfs failed on open of %2 directed to %3.  The error returned is in the record data.
//
#define DFS_OPEN_FAILURE                 0x40003847L

//
// Dfs service (dfssvc) errors (14500-14599)
//
// NOTE: events 14500-14501 are UNUSED as of WS03.
//       events 14502, 14506-07, 14525, 14527-28 were defined in WS03 development
//             but never issued in retail, and have been removed.
//
//
// MessageId: NET_DFS_ENUM
//
// MessageText:
//
// NetrDfsEnum received an enumeration.  The return code is in the record data.
//
#define NET_DFS_ENUM                     0x400038A4L

//
// MessageId: NET_DFS_ENUMEX
//
// MessageText:
//
// NetrDfsEnumEx received an enumeration.  The return code is in the record data.
//
#define NET_DFS_ENUMEX                   0x400038A5L

//
// MessageId: DFS_ERROR_CREATE_REPARSEPOINT_FAILURE
//
// MessageText:
//
// Dfs could not create reparse point for directory %1 under directory %2. The return code is in the record data.
//
#define DFS_ERROR_CREATE_REPARSEPOINT_FAILURE 0xC00038A7L

//
// MessageId: DFS_ERROR_UNSUPPORTED_FILESYSTEM
//
// MessageText:
//
// Share %1 mapped to %2 does not support reparse points. Upgrade Filesystem and retry.
//
#define DFS_ERROR_UNSUPPORTED_FILESYSTEM 0xC00038A8L

//
// MessageId: DFS_ERROR_OVERLAPPING_DIRECTORIES
//
// MessageText:
//
// Share %1 mapped to %2 directory overlaps an existing root. The DFS Root will not be created.
//
#define DFS_ERROR_OVERLAPPING_DIRECTORIES 0xC00038A9L

//
// MessageId: DFS_INFO_ACTIVEDIRECTORY_ONLINE
//
// MessageText:
//
// DFS re-established a connection to the PDC to initiate Domain DFS operations.
//
#define DFS_INFO_ACTIVEDIRECTORY_ONLINE  0x400038ACL

//
// MessageId: DFS_ERROR_TOO_MANY_ERRORS
//
// MessageText:
//
// Root %1 has too many errors. No further eventlogs will be logged on this root.
//
#define DFS_ERROR_TOO_MANY_ERRORS        0xC00038ADL

//
// MessageId: DFS_ERROR_WINSOCKINIT_FAILED
//
// MessageText:
//
// DFS could not initialize winsock library. The return code is in the record data.
//
#define DFS_ERROR_WINSOCKINIT_FAILED     0xC00038AEL

//
// MessageId: DFS_ERROR_SECURITYINIT_FAILED
//
// MessageText:
//
// DFS could not initialize security library. The return code is in the record data.
//
#define DFS_ERROR_SECURITYINIT_FAILED    0xC00038AFL

//
// MessageId: DFS_ERROR_THREADINIT_FAILED
//
// MessageText:
//
// DFS could not create DFS support thread. The return code is in the record data.
//
#define DFS_ERROR_THREADINIT_FAILED      0xC00038B0L

//
// MessageId: DFS_ERROR_SITECACHEINIT_FAILED
//
// MessageText:
//
// DFS could not initialize IP site cache. The return code is in the record data.
//
#define DFS_ERROR_SITECACHEINIT_FAILED   0xC00038B1L

//
// MessageId: DFS_ERROR_ROOTSYNCINIT_FAILED
//
// MessageText:
//
// DFS could not synchronize all DFS roots. The return code is in the record data.
//
#define DFS_ERROR_ROOTSYNCINIT_FAILED    0xC00038B2L

//
// MessageId: DFS_ERROR_CREATEEVENT_FAILED
//
// MessageText:
//
// DFS could not create event handle. The return code is in the record data.
//
#define DFS_ERROR_CREATEEVENT_FAILED     0xC00038B3L

//
// MessageId: DFS_ERROR_COMPUTERINFO_FAILED
//
// MessageText:
//
// DFS could not get required computer information. The return code is in the record data.
//
#define DFS_ERROR_COMPUTERINFO_FAILED    0xC00038B4L

//
// MessageId: DFS_ERROR_CLUSTERINFO_FAILED
//
// MessageText:
//
// DFS could not get required cluster information. The return code is in the record data.
//
#define DFS_ERROR_CLUSTERINFO_FAILED     0xC00038B5L

//
// MessageId: DFS_ERROR_DCINFO_FAILED
//
// MessageText:
//
// DFS could not get required DC information. The return code is in the record data.
//
#define DFS_ERROR_DCINFO_FAILED          0xC00038B6L

//
// MessageId: DFS_ERROR_PREFIXTABLE_FAILED
//
// MessageText:
//
// DFS could not initialize prefix table. The return code is in the record data.
//
#define DFS_ERROR_PREFIXTABLE_FAILED     0xC00038B7L

//
// MessageId: DFS_ERROR_HANDLENAMESPACE_FAILED
//
// MessageText:
//
// DFS could not initialize DFS namespace.The return code is in the record data.
//
#define DFS_ERROR_HANDLENAMESPACE_FAILED 0xC00038B8L

//
// MessageId: DFS_ERROR_REGISTERSTORE_FAILED
//
// MessageText:
//
// DFS could not Register DFS Namespaces. The return code is in the record data.
//
#define DFS_ERROR_REGISTERSTORE_FAILED   0xC00038B9L

//
// MessageId: DFS_ERROR_REFLECTIONENGINE_FAILED
//
// MessageText:
//
// DFS could not initialize User/kernel communication package. The return code is in the record data.
//
#define DFS_ERROR_REFLECTIONENGINE_FAILED 0xC00038BAL

//
// MessageId: DFS_ERROR_ACTIVEDIRECTORY_OFFLINE
//
// MessageText:
//
// DFS could not contact any DC for Domain DFS operations. This operation will be retried periodically.
//
#define DFS_ERROR_ACTIVEDIRECTORY_OFFLINE 0xC00038BBL

//
// MessageId: DFS_ERROR_SITESUPPOR_FAILED
//
// MessageText:
//
// DFS could not initialize site support table. The return code is in the record data.
//
#define DFS_ERROR_SITESUPPOR_FAILED      0xC00038BCL

//
// MessageId: DFS_ERROR_DSCONNECT_FAILED
//
// MessageText:
//
// DFS could not contact the %1 Active Directory. DFS will be using cached data. The return code is in the record data.
//
#define DFS_ERROR_DSCONNECT_FAILED       0x800038BEL

//
// MessageId: DFS_INFO_DS_RECONNECTED
//
// MessageText:
//
// DFS has connected to the %1 Active Directory.
//
#define DFS_INFO_DS_RECONNECTED          0x400038C1L

//
// MessageId: DFS_ERROR_NO_DFS_DATA
//
// MessageText:
//
// DFS could not access its private data from the Active Directory. Please manually check
// network connectivity, security access, and/or consistency of DFS information
// in the Active Directory. This error occurred on root %1.
//
#define DFS_ERROR_NO_DFS_DATA            0xC00038C2L

//
// MessageId: DFS_INFO_FINISH_INIT
//
// MessageText:
//
// DFS server has finished initializing.
//
#define DFS_INFO_FINISH_INIT             0x400038C3L

//
// MessageId: DFS_INFO_RECONNECT_DATA
//
// MessageText:
//
// DFS has recovered from an error and is able to read its private data from
// the Active Directory. Root %1 is now able to read information from the Active Directory.
//
#define DFS_INFO_RECONNECT_DATA          0x400038C4L

//
// MessageId: DFS_INFO_FINISH_BUILDING_NAMESPACE
//
// MessageText:
//
// DFS has finished building all namespaces.
//
#define DFS_INFO_FINISH_BUILDING_NAMESPACE 0x400038C5L

//
// MessageId: DFS_ERROR_ON_ROOT
//
// MessageText:
//
// DFS Root %1 failed during initialization. The root will not be available.
//
#define DFS_ERROR_ON_ROOT                0x800038C6L

//
// MessageId: DFS_ERROR_MUTLIPLE_ROOTS_NOT_SUPPORTED
//
// MessageText:
//
// DFS does not support multiple roots on Standard server SKU. Please cleanup the roots or upgrade.
//
#define DFS_ERROR_MUTLIPLE_ROOTS_NOT_SUPPORTED 0xC00038C7L

//
// MessageId: DFS_WARN_DOMAIN_REFERRAL_OVERFLOW
//
// MessageText:
//
// DFS is unable to return the entire list of trusted domains to the client. There are too many trusted domains.
//
#define DFS_WARN_DOMAIN_REFERRAL_OVERFLOW 0x800038C8L

//
// MessageId: DFS_INFO_DOMAIN_REFERRAL_MIN_OVERFLOW
//
// MessageText:
//
// DFS is requesting the client for a larger buffer for trusted domain information. Some Win98 clients may not be able to access DFS namespaces.
//
#define DFS_INFO_DOMAIN_REFERRAL_MIN_OVERFLOW 0x400038C9L

//
// MessageId: DFS_WARN_INCOMPLETE_MOVE
//
// MessageText:
//
// DFS was unable to move all matching links of root: %1 for path %2 to new path %3
//
#define DFS_WARN_INCOMPLETE_MOVE         0x800038CAL

//
// MessageId: DFS_ERROR_RESYNCHRONIZE_FAILED
//
// MessageText:
//
// DFS was unable to resynchronize this root target for root: %1. This may lead to inaccessability of portions of the DFS namespace. 
// Please verify the share %1 has all the link directories created for the DFS links. This error may occur if there are directories 
// on this share that may be preventing creation of links.
//
#define DFS_ERROR_RESYNCHRONIZE_FAILED   0xC00038CBL

//
// MessageId: DFS_ERROR_REMOVE_LINK_FAILED
//
// MessageText:
//
// DFS was unable to delete link: %2  for root: %1 during a link move operation. 
//
#define DFS_ERROR_REMOVE_LINK_FAILED     0xC00038CCL

//
// MessageId: DFS_WARN_METADATA_LINK_TYPE_INCORRECT
//
// MessageText:
//
// DFS link %1 was marked incorrectly as a DFS root. The DFS namespace is operational on this server. If this namespace is hosted on servers running Windows Server 2003 prior to Service Pack 2 (SP2), or if the server is running Windows 2000 Server, the namespace might not be fully functional on those servers.
// 
// Please consult the Microsoft Knowledge Base for more information on correcting this issue.
//
#define DFS_WARN_METADATA_LINK_TYPE_INCORRECT 0x800038CDL

//
// MessageId: DFS_WARN_METADATA_LINK_INFO_INVALID
//
// MessageText:
//
// DFS metadata object %1 is empty in the metadata for DFS root %2. The DFS namespace is operational on this server. If this namespace is hosted on servers running Windows Server 2003 prior to Service Pack 2 (SP2), or if the server is running Windows 2000 Server, the namespace might not be fully functional on those servers.
// 
// Please consult the Microsoft Knowledge Base for more information on correcting this issue.
//
#define DFS_WARN_METADATA_LINK_INFO_INVALID 0x800038CEL

//
// MessageId: DFS_ERROR_TARGET_LIST_INCORRECT
//
// MessageText:
//
// The list of folder targets for the following Distributed File System (DFS) folder is corrupt. DFS folder: %1
//
#define DFS_ERROR_TARGET_LIST_INCORRECT  0xC00038CFL

//
// MessageId: DFS_ERROR_LINKS_OVERLAP
//
// MessageText:
//
// A Distributed File System (DFS) folder with folder targets was created that contains other DFS folders. This can occur if two administrators on different namespace servers create conflicting folder structures at approximately the same time. Namespace: %1 DFS folder 1: %2 DFS folder 2: %3
//
#define DFS_ERROR_LINKS_OVERLAP          0xC00038D0L

//
// MessageId: DFS_ERROR_LINK_OVERLAP
//
// MessageText:
//
// A Distributed File System (DFS) folder with folder targets was created that contains other DFS folders. This can occur if two administrators on different namespace servers create conflicting folder structures at approximately the same time. Namespace: %1 DFS folder: %2
//
#define DFS_ERROR_LINK_OVERLAP           0xC00038D1L

//
// MessageId: DFS_ERROR_CREATE_REPARSEPOINT_SUCCESS
//
// MessageText:
//
// Dfs successfully created the reparse point for directory %1 under directory %2. This operation had previously failed.
//
#define DFS_ERROR_CREATE_REPARSEPOINT_SUCCESS 0x400038D2L

//
// MessageId: DFS_ERROR_DUPLICATE_LINK
//
// MessageText:
//
// A Distributed File System (DFS) folder was created with conflicting descriptions. This can occur if two administrators on different namespace servers create conflicting folder structures at approximately the same time. Namespace: %1 DFS folder path: %2 DFS folder 1: %3 DFS folder 2: %4
//
#define DFS_ERROR_DUPLICATE_LINK         0xC00038D3L

//
// MessageId: DFS_ERROR_TRUSTED_DOMAIN_INFO_FAILED
//
// MessageText:
//
// The DFS Namespace service could not initialize the trusted domain information on this domain controller, but it will periodically retry the operation. The return code is in the record data.
//
#define DFS_ERROR_TRUSTED_DOMAIN_INFO_FAILED 0xC00038D4L

//
// MessageId: DFS_INFO_TRUSTED_DOMAIN_INFO_SUCCESS
//
// MessageText:
//
// The DFS Namespace service successfully initialized the trusted domain information on this domain controller.
//
#define DFS_INFO_TRUSTED_DOMAIN_INFO_SUCCESS 0x400038D5L

//
// MessageId: DFS_ERROR_CROSS_FOREST_TRUST_INFO_FAILED
//
// MessageText:
//
// The DFS Namespace service could not initialize cross forest trust information on this domain controller, but it will periodically retry the operation. The return code is in the record data.
//
#define DFS_ERROR_CROSS_FOREST_TRUST_INFO_FAILED 0xC00038D6L

//
// MessageId: DFS_INFO_CROSS_FOREST_TRUST_INFO_SUCCESS
//
// MessageText:
//
// The DFS Namespace service successfully initialized cross forest trust information on this domain controller.
//
#define DFS_INFO_CROSS_FOREST_TRUST_INFO_SUCCESS 0x400038D7L

//
// MessageId: DFS_INIT_SUCCESS
//
// MessageText:
//
// The DFS Namespaces service has successfully initialized the following namespace: %1
//
#define DFS_INIT_SUCCESS                 0x400038D8L

//
// MessageId: DFS_ROOT_SHARE_ACQUIRE_FAILED
//
// MessageText:
//
// The DFS Namespaces service failed to initialize the shared folder that hosts the namespace root. Shared folder: %1
//
#define DFS_ROOT_SHARE_ACQUIRE_FAILED    0x800038D9L

//
// MessageId: DFS_ROOT_SHARE_ACQUIRE_SUCCESS
//
// MessageText:
//
// The DFS Namespaces service has successfully initialized the shared folder that hosts the namespace root. Shared folder: %1
//
#define DFS_ROOT_SHARE_ACQUIRE_SUCCESS   0x400038DAL

/////////////////////////////////////////////////////////////////////////
//
// BRIDGE Events
//
// Codes 14600 - 14899
//
/////////////////////////////////////////////////////////////////////////
//
// Driver-wide events (14600 - 14699)
//
//
// MessageId: EVENT_BRIDGE_PROTOCOL_REGISTER_FAILED
//
// MessageText:
//
// Bridge: The bridge could not be initialized because the bridge failed to register as a protocol with NDIS.
//
#define EVENT_BRIDGE_PROTOCOL_REGISTER_FAILED 0xC0003908L

//
// MessageId: EVENT_BRIDGE_MINIPROT_DEVNAME_MISSING
//
// MessageText:
//
// Bridge: The bridge could not be initialized because the bridge's miniport device name is missing from the registry.
//
#define EVENT_BRIDGE_MINIPROT_DEVNAME_MISSING 0xC0003909L

//
// MessageId: EVENT_BRIDGE_MINIPORT_REGISTER_FAILED
//
// MessageText:
//
// Bridge: The bridge could not be initialized because the bridge failed to register as a miniport with NDIS.
//
#define EVENT_BRIDGE_MINIPORT_REGISTER_FAILED 0xC000390AL

//
// MessageId: EVENT_BRIDGE_DEVICE_CREATION_FAILED
//
// MessageText:
//
// Bridge: The bridge could not be initialized because the bridge failed to create a device object.
//
#define EVENT_BRIDGE_DEVICE_CREATION_FAILED 0xC000390BL

//
// MessageId: EVENT_BRIDGE_NO_BRIDGE_MAC_ADDR
//
// MessageText:
//
// Bridge: The bridge could not be initialized because the bridge failed to determine a MAC address for itself.
//
#define EVENT_BRIDGE_NO_BRIDGE_MAC_ADDR  0xC000390CL

//
// MessageId: EVENT_BRIDGE_MINIPORT_INIT_FAILED
//
// MessageText:
//
// Bridge: The bridge failed to create its virtual miniport.
//
#define EVENT_BRIDGE_MINIPORT_INIT_FAILED 0xC000390DL

//
// MessageId: EVENT_BRIDGE_ETHERNET_NOT_OFFERED
//
// MessageText:
//
// Bridge: The bridge could not initialize its miniport because Ethernet was not offered as a supported medium.
//
#define EVENT_BRIDGE_ETHERNET_NOT_OFFERED 0xC000390EL

//
// MessageId: EVENT_BRIDGE_THREAD_CREATION_FAILED
//
// MessageText:
//
// Bridge: The bridge could not initialize because it failed to create a system thread.
//
#define EVENT_BRIDGE_THREAD_CREATION_FAILED 0xC000390FL

//
// MessageId: EVENT_BRIDGE_THREAD_REF_FAILED
//
// MessageText:
//
// Bridge: The bridge could not initialize because it failed to reference its system thread.
//
#define EVENT_BRIDGE_THREAD_REF_FAILED   0xC0003910L

//
// MessageId: EVENT_BRIDGE_PACKET_POOL_CREATION_FAILED
//
// MessageText:
//
// Bridge: The bridge could not initialize because it failed to create a packet pool.
//
#define EVENT_BRIDGE_PACKET_POOL_CREATION_FAILED 0xC0003911L

//
// MessageId: EVENT_BRIDGE_BUFFER_POOL_CREATION_FAILED
//
// MessageText:
//
// Bridge: The bridge could not initialize because it failed to create a buffer pool.
//
#define EVENT_BRIDGE_BUFFER_POOL_CREATION_FAILED 0xC0003912L

//
// MessageId: EVENT_BRIDGE_INIT_MALLOC_FAILED
//
// MessageText:
//
// Bridge: The bridge could not initialize because it failed to allocate memory.
//
#define EVENT_BRIDGE_INIT_MALLOC_FAILED  0xC0003913L

//
// Adapter-specific events (14700 - 14799)
//
//
// MessageId: EVENT_BRIDGE_ADAPTER_LINK_SPEED_QUERY_FAILED
//
// MessageText:
//
// Bridge [Adapter %2]:%nThe bridge could not determine the network adapter's link speed. The network adapter will not be used.
//
#define EVENT_BRIDGE_ADAPTER_LINK_SPEED_QUERY_FAILED 0xC000396CL

//
// MessageId: EVENT_BRIDGE_ADAPTER_MAC_ADDR_QUERY_FAILED
//
// MessageText:
//
// Bridge [Adapter %2]:%nThe bridge could not determine the network adapter's MAC address. The network adapter will not be used.
//
#define EVENT_BRIDGE_ADAPTER_MAC_ADDR_QUERY_FAILED 0xC000396DL

//
// MessageId: EVENT_BRIDGE_ADAPTER_FILTER_FAILED
//
// MessageText:
//
// Bridge [Adapter %2]:%nThe bridge could not modify the network adapter's packet filter. The network adapter will not function correctly.
//
#define EVENT_BRIDGE_ADAPTER_FILTER_FAILED 0xC000396EL

//
// MessageId: EVENT_BRIDGE_ADAPTER_NAME_QUERY_FAILED
//
// MessageText:
//
// Bridge [Adapter %2]:%nThe bridge could not retrieve the network adapter's description string. The network adapter will not be used.
//
#define EVENT_BRIDGE_ADAPTER_NAME_QUERY_FAILED 0xC000396FL

//
// MessageId: EVENT_BRIDGE_ADAPTER_BIND_FAILED
//
// MessageText:
//
// Bridge [Adapter %2]:%nThe bridge failed to bind to the network adapter. The network adapter will not be used.
//
#define EVENT_BRIDGE_ADAPTER_BIND_FAILED 0xC0003970L

//
// DAV Redir Events (14800 - 14899)
//
//
// MessageId: EVENT_DAV_REDIR_DELAYED_WRITE_FAILED
//
// MessageText:
//
// Windows was unable to save data for file %2. The data has been lost. This error may be caused by a failure of your computer hardware or network connection. Please try to save this file elsewhere.
//
#define EVENT_DAV_REDIR_DELAYED_WRITE_FAILED 0x800039D0L

//
// WebClient Service Events (14900 - 14999)
//
//
// MessageId: EVENT_WEBCLIENT_CLOSE_PUT_FAILED
//
// MessageText:
//
// PUT failed for file %1 on Close. ErrorStatus: %2.
//
#define EVENT_WEBCLIENT_CLOSE_PUT_FAILED 0x80003A35L

//
// MessageId: EVENT_WEBCLIENT_CLOSE_DELETE_FAILED
//
// MessageText:
//
// DELETE failed for file %1 on Close. ErrorStatus: %2.
//
#define EVENT_WEBCLIENT_CLOSE_DELETE_FAILED 0x80003A36L

//
// MessageId: EVENT_WEBCLIENT_CLOSE_PROPPATCH_FAILED
//
// MessageText:
//
// PROPPATCH failed for file %1 on Close. ErrorStatus: %2.
//
#define EVENT_WEBCLIENT_CLOSE_PROPPATCH_FAILED 0x80003A37L

//
// MessageId: EVENT_WEBCLIENT_SETINFO_PROPPATCH_FAILED
//
// MessageText:
//
// PROPPATCH failed for file %1 on SetFileInfo. ErrorStatus: %2.
//
#define EVENT_WEBCLIENT_SETINFO_PROPPATCH_FAILED 0x80003A38L


/////////////////////////////////////////////////////////////////////////
//
// Winsock/WSK Events (16000-16199)
//
/////////////////////////////////////////////////////////////////////////

//
// MessageId: EVENT_WSK_OWNINGTHREAD_PARAMETER_IGNORED
//
// MessageText:
//
// WSK provider has ignored the OwningThread parameter passed to a WSK socket creation request. This happens when the socket needs to be created over a TDI transport provider either because a TDI filter driver is installed or because a client-specified TDI mapping exists that matches the AddressFamily, socketType, and Protocol specified in the socket creation request.
//
#define EVENT_WSK_OWNINGTHREAD_PARAMETER_IGNORED 0xC0003E80L

//
// MessageId: EVENT_WINSOCK_TDI_FILTER_DETECTED
//
// MessageText:
//
// A TDI filter (%2) was detected. This filter has not been certified by Microsoft and may cause system instability.
//
#define EVENT_WINSOCK_TDI_FILTER_DETECTED 0x80003E81L

//
// MessageId: EVENT_WINSOCK_CLOSESOCKET_STUCK
//
// MessageText:
//
// Closing a %2 socket with local port number %3 in process %4 is taking longer than expected. The local port number may not be available until the close operation is completed. This happens typically due to misbehaving network drivers. Ensure latest updates are installed for Windows and any third-party networking software including NIC drivers, firewalls, or other security products.  
//
#define EVENT_WINSOCK_CLOSESOCKET_STUCK  0x80003E82L


/////////////////////////////////////////////////////////////////////////
//
// eQoS Events (16500 -16999)
//
/////////////////////////////////////////////////////////////////////////


//
// Informational
//

//
// MessageId: EVENT_EQOS_INFO_MACHINE_POLICY_REFRESH_NO_CHANGE
//
// MessageText:
//
// Computer QoS policies successfully refreshed. No changes detected.
//
#define EVENT_EQOS_INFO_MACHINE_POLICY_REFRESH_NO_CHANGE 0x40004074L

//
// MessageId: EVENT_EQOS_INFO_MACHINE_POLICY_REFRESH_WITH_CHANGE
//
// MessageText:
//
// Computer QoS policies successfully refreshed. Policy changes detected.
//
#define EVENT_EQOS_INFO_MACHINE_POLICY_REFRESH_WITH_CHANGE 0x40004075L

//
// MessageId: EVENT_EQOS_INFO_USER_POLICY_REFRESH_NO_CHANGE
//
// MessageText:
//
// User QoS policies successfully refreshed. No changes detected.
//
#define EVENT_EQOS_INFO_USER_POLICY_REFRESH_NO_CHANGE 0x40004076L

//
// MessageId: EVENT_EQOS_INFO_USER_POLICY_REFRESH_WITH_CHANGE
//
// MessageText:
//
// User QoS policies successfully refreshed. Policy changes detected.
//
#define EVENT_EQOS_INFO_USER_POLICY_REFRESH_WITH_CHANGE 0x40004077L

//
// MessageId: EVENT_EQOS_INFO_TCP_AUTOTUNING_NOT_CONFIGURED
//
// MessageText:
//
// The Advanced QoS Setting for inbound TCP throughput level successfully refreshed. 
// Setting value is not specified by any QoS policy. Local computer default will be applied.
//
#define EVENT_EQOS_INFO_TCP_AUTOTUNING_NOT_CONFIGURED 0x40004078L

//
// MessageId: EVENT_EQOS_INFO_TCP_AUTOTUNING_OFF
//
// MessageText:
//
// The Advanced QoS Setting for inbound TCP throughput level successfully refreshed. 
// Setting value is Level 0 (minimum throughput).
//
#define EVENT_EQOS_INFO_TCP_AUTOTUNING_OFF 0x40004079L

//
// MessageId: EVENT_EQOS_INFO_TCP_AUTOTUNING_HIGHLY_RESTRICTED
//
// MessageText:
//
// The Advanced QoS Setting for inbound TCP throughput level successfully refreshed. 
// Setting value is Level 1.
//
#define EVENT_EQOS_INFO_TCP_AUTOTUNING_HIGHLY_RESTRICTED 0x4000407AL

//
// MessageId: EVENT_EQOS_INFO_TCP_AUTOTUNING_RESTRICTED
//
// MessageText:
//
// The Advanced QoS Setting for inbound TCP throughput level successfully refreshed. 
// Setting value is Level 2.
//
#define EVENT_EQOS_INFO_TCP_AUTOTUNING_RESTRICTED 0x4000407BL

//
// MessageId: EVENT_EQOS_INFO_TCP_AUTOTUNING_NORMAL
//
// MessageText:
//
// The Advanced QoS Setting for inbound TCP throughput level successfully refreshed. 
// Setting value is Level 3 (maximum throughput).
//
#define EVENT_EQOS_INFO_TCP_AUTOTUNING_NORMAL 0x4000407CL

//
// MessageId: EVENT_EQOS_INFO_APP_MARKING_NOT_CONFIGURED
//
// MessageText:
//
// The Advanced QoS Setting for DSCP marking overrides successfully refreshed. 
// Setting value is not specified by any QoS policy. Local computer default will be applied. By default, applications can set DSCP values independently of QoS policies.
//
#define EVENT_EQOS_INFO_APP_MARKING_NOT_CONFIGURED 0x4000407DL

//
// MessageId: EVENT_EQOS_INFO_APP_MARKING_IGNORED
//
// MessageText:
//
// The Advanced QoS Setting for DSCP marking overrides successfully refreshed. 
// Application DSCP marking requests will be ignored. Only QoS policies can set DSCP values.
//
#define EVENT_EQOS_INFO_APP_MARKING_IGNORED 0x4000407EL

//
// MessageId: EVENT_EQOS_INFO_APP_MARKING_ALLOWED
//
// MessageText:
//
// The Advanced QoS Setting for DSCP marking overrides successfully refreshed. 
// Applications can set DSCP values independently of QoS policies.
//
#define EVENT_EQOS_INFO_APP_MARKING_ALLOWED 0x4000407FL

//
// MessageId: EVENT_EQOS_INFO_LOCAL_SETTING_DONT_USE_NLA
//
// MessageText:
//
// Selective application of QoS policies based on domain or non-domain network category has been disabled on this machine.
// QoS policies will be applied to all network interfaces.    
//
#define EVENT_EQOS_INFO_LOCAL_SETTING_DONT_USE_NLA 0x40004080L

//
// MessageId: EVENT_EQOS_URL_QOS_APPLICATION_CONFLICT
//
// MessageText:
//
// In the past %1 hour(s) and %2 minute(s), %3 HTTP.SYS responses have had their application requested QoS conflict with URL QoS policies.
//
#define EVENT_EQOS_URL_QOS_APPLICATION_CONFLICT 0x40004081L


//
// Warnings
//

//
// MessageId: EVENT_EQOS_WARNING_TEST_1
//
// MessageText:
//
// EQOS: ***Testing***, with one string %2.
//
#define EVENT_EQOS_WARNING_TEST_1        0x800040D8L

//
// MessageId: EVENT_EQOS_WARNING_TEST_2
//
// MessageText:
//
// EQOS: ***Testing***, with two strings, string1 is %2, string2 is %3.
//
#define EVENT_EQOS_WARNING_TEST_2        0x800040D9L

//
// MessageId: EVENT_EQOS_WARNING_MACHINE_POLICY_VERSION
//
// MessageText:
//
// A computer QoS policy "%2" has an invalid version number. This policy will not be applied.
//
#define EVENT_EQOS_WARNING_MACHINE_POLICY_VERSION 0x800040DAL

//
// MessageId: EVENT_EQOS_WARNING_USER_POLICY_VERSION
//
// MessageText:
//
// A user QoS policy "%2" has an invalid version number. This policy will not be applied.
//
#define EVENT_EQOS_WARNING_USER_POLICY_VERSION 0x800040DBL

//
// MessageId: EVENT_EQOS_WARNING_MACHINE_POLICY_PROFILE_NOT_SPECIFIED
//
// MessageText:
//
// A computer QoS policy "%2" does not specify a DSCP value or throttle rate. This policy will not be applied.
//
#define EVENT_EQOS_WARNING_MACHINE_POLICY_PROFILE_NOT_SPECIFIED 0x800040DCL

//
// MessageId: EVENT_EQOS_WARNING_USER_POLICY_PROFILE_NOT_SPECIFIED
//
// MessageText:
//
// A user QoS policy "%2" does not specify a DSCP value or throttle rate. This policy will not be applied.
//
#define EVENT_EQOS_WARNING_USER_POLICY_PROFILE_NOT_SPECIFIED 0x800040DDL

//
// MessageId: EVENT_EQOS_WARNING_MACHINE_POLICY_QUOTA_EXCEEDED
//
// MessageText:
//
// Exceeded the maximum number of computer QoS policies. 
// The computer QoS policy "%2" and subsequent computer QoS policies will not be applied.
//
#define EVENT_EQOS_WARNING_MACHINE_POLICY_QUOTA_EXCEEDED 0x800040DEL

//
// MessageId: EVENT_EQOS_WARNING_USER_POLICY_QUOTA_EXCEEDED
//
// MessageText:
//
// Exceeded the maximum number of user QoS policies. 
// The user QoS policy "%2" and subsequent user QoS policies will not be applied.
//
#define EVENT_EQOS_WARNING_USER_POLICY_QUOTA_EXCEEDED 0x800040DFL

//
// MessageId: EVENT_EQOS_WARNING_MACHINE_POLICY_CONFLICT
//
// MessageText:
//
// A computer QoS policy "%2" potentially conflicts with other QoS policies. 
// See documentation for rules about which policy will be applied at packet send time.
//
#define EVENT_EQOS_WARNING_MACHINE_POLICY_CONFLICT 0x800040E0L

//
// MessageId: EVENT_EQOS_WARNING_USER_POLICY_CONFLICT
//
// MessageText:
//
// A user QoS policy "%2" potentially conflicts with other QoS policies. 
// See documentation for rules about which policy will be applied at packet send time.
//
#define EVENT_EQOS_WARNING_USER_POLICY_CONFLICT 0x800040E1L

//
// MessageId: EVENT_EQOS_WARNING_MACHINE_POLICY_NO_FULLPATH_APPNAME
//
// MessageText:
//
// A computer QoS policy "%2" was ignored because the application path cannot be processed.  
// The application path may be totally invalid, or has an invalid drive letter, or contains network-mapped drive letter.
//
#define EVENT_EQOS_WARNING_MACHINE_POLICY_NO_FULLPATH_APPNAME 0x800040E2L

//
// MessageId: EVENT_EQOS_WARNING_USER_POLICY_NO_FULLPATH_APPNAME
//
// MessageText:
//
// A user QoS policy "%2" was ignored because the application path cannot be processed.  
// The application path may be totally invalid, or has an invalid drive letter, or contains network-mapped drive letter.
//
#define EVENT_EQOS_WARNING_USER_POLICY_NO_FULLPATH_APPNAME 0x800040E3L


//
// Errors
//

//
// MessageId: EVENT_EQOS_ERROR_MACHINE_POLICY_REFERESH
//
// MessageText:
//
// Computer QoS policies failed to refresh. Error code: %2.
//
#define EVENT_EQOS_ERROR_MACHINE_POLICY_REFERESH 0xC000413CL

//
// MessageId: EVENT_EQOS_ERROR_USER_POLICY_REFERESH
//
// MessageText:
//
// User QoS policies failed to refresh. Error code: %2.
//
#define EVENT_EQOS_ERROR_USER_POLICY_REFERESH 0xC000413DL

//
// MessageId: EVENT_EQOS_ERROR_OPENING_MACHINE_POLICY_ROOT_KEY
//
// MessageText:
//
// QoS failed to open the computer-level root key for QoS policies. Error code: %2.
//
#define EVENT_EQOS_ERROR_OPENING_MACHINE_POLICY_ROOT_KEY 0xC000413EL

//
// MessageId: EVENT_EQOS_ERROR_OPENING_USER_POLICY_ROOT_KEY
//
// MessageText:
//
// QoS failed to open the user-level root key for QoS policies. Error code: %2.
//
#define EVENT_EQOS_ERROR_OPENING_USER_POLICY_ROOT_KEY 0xC000413FL

//
// MessageId: EVENT_EQOS_ERROR_MACHINE_POLICY_KEYNAME_TOO_LONG
//
// MessageText:
//
// A computer QoS policy exceeds the maximum allowed name length. 
// The offending policy is listed under the computer-level QoS policy root key, with index %2. 
//
#define EVENT_EQOS_ERROR_MACHINE_POLICY_KEYNAME_TOO_LONG 0xC0004140L

//
// MessageId: EVENT_EQOS_ERROR_USER_POLICY_KEYNAME_TOO_LONG
//
// MessageText:
//
// A user QoS policy exceeds the maximum allowed name length. 
// The offending policy is listed under the user-level QoS policy root key, with index %2. 
//
#define EVENT_EQOS_ERROR_USER_POLICY_KEYNAME_TOO_LONG 0xC0004141L

//
// MessageId: EVENT_EQOS_ERROR_MACHINE_POLICY_KEYNAME_SIZE_ZERO
//
// MessageText:
//
// A computer QoS policy has a zero length name. 
// The offending policy is listed under the computer-level QoS policy root key, with index %2.
//
#define EVENT_EQOS_ERROR_MACHINE_POLICY_KEYNAME_SIZE_ZERO 0xC0004142L

//
// MessageId: EVENT_EQOS_ERROR_USER_POLICY_KEYNAME_SIZE_ZERO
//
// MessageText:
//
// A user QoS policy has a zero length name. 
// The offending policy is listed under the user-level QoS policy root key, with index %2.
//
#define EVENT_EQOS_ERROR_USER_POLICY_KEYNAME_SIZE_ZERO 0xC0004143L

//
// MessageId: EVENT_EQOS_ERROR_OPENING_MACHINE_POLICY_SUBKEY
//
// MessageText:
//
// QoS failed to open the registry subkey for a computer QoS policy. 
// The policy is listed under the computer-level QoS policy root key, with index %2. 
//
#define EVENT_EQOS_ERROR_OPENING_MACHINE_POLICY_SUBKEY 0xC0004144L

//
// MessageId: EVENT_EQOS_ERROR_OPENING_USER_POLICY_SUBKEY
//
// MessageText:
//
// QoS failed to open the registry subkey for a user QoS policy. 
// The policy is listed under the user-level QoS policy root key, with index %2. 
//
#define EVENT_EQOS_ERROR_OPENING_USER_POLICY_SUBKEY 0xC0004145L

//
// MessageId: EVENT_EQOS_ERROR_PROCESSING_MACHINE_POLICY_FIELD
//
// MessageText:
//
// QoS failed to read or validate the "%2" field for the computer QoS policy "%3".
//
#define EVENT_EQOS_ERROR_PROCESSING_MACHINE_POLICY_FIELD 0xC0004146L

//
// MessageId: EVENT_EQOS_ERROR_PROCESSING_USER_POLICY_FIELD
//
// MessageText:
//
// QoS failed to read or validate the "%2" field for the user QoS policy "%3".
//
#define EVENT_EQOS_ERROR_PROCESSING_USER_POLICY_FIELD 0xC0004147L

//
// MessageId: EVENT_EQOS_ERROR_SETTING_TCP_AUTOTUNING
//
// MessageText:
//
// QoS failed to read or set inbound TCP throughput level, error code: "%2".
//
#define EVENT_EQOS_ERROR_SETTING_TCP_AUTOTUNING 0xC0004148L

//
// MessageId: EVENT_EQOS_ERROR_SETTING_APP_MARKING
//
// MessageText:
//
// QoS failed to read or set the DSCP marking override setting, error code: "%2".
//
#define EVENT_EQOS_ERROR_SETTING_APP_MARKING 0xC0004149L


/////////////////////////////////////////////////////////////////////////
//
// WinNat Events (17000 - 17100)
//
/////////////////////////////////////////////////////////////////////////


//
// Warnings
//

//
// MessageId: EVENT_WINNAT_SESSION_LIMIT_REACHED
//
// MessageText:
//
// WinNat session limit has been reached. 
//
#define EVENT_WINNAT_SESSION_LIMIT_REACHED 0x80004268L


#endif // _NETEVENT

