/*++ BUILD Version: 0001    // Increment this if a change has global effects

Copyright (c) Microsoft Corporation. All rights reserved.

Module Name:

    ntddmodm.h

Abstract:

    This is the include file that defines all constants and types for
    accessing the modem device.


--*/

#ifndef _NTDDMODM_
#define _NTDDMODM_

#if _MSC_VER > 1000
#pragma once
#endif
#include <winapifamily.h>

#pragma region Desktop Family
#if WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_DESKTOP)


#ifdef __cplusplus
extern "C" {
#endif

//
// NtDeviceIoControlFile IoControlCode values for this device.
//

#define IOCTL_MODEM_GET_PASSTHROUGH      CTL_CODE(FILE_DEVICE_MODEM, 1,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_MODEM_SET_PASSTHROUGH      CTL_CODE(FILE_DEVICE_MODEM, 2,METHOD_BUFFERED,FILE_ANY_ACCESS)

#define IOCTL_MODEM_SET_DLE_MONITORING   CTL_CODE(FILE_DEVICE_MODEM, 3,METHOD_BUFFERED,FILE_ANY_ACCESS)

#define IOCTL_MODEM_GET_DLE              CTL_CODE(FILE_DEVICE_MODEM, 4,METHOD_BUFFERED,FILE_ANY_ACCESS)

#define IOCTL_MODEM_SET_DLE_SHIELDING    CTL_CODE(FILE_DEVICE_MODEM, 5,METHOD_BUFFERED,FILE_ANY_ACCESS)

#define IOCTL_MODEM_STOP_WAVE_RECEIVE    CTL_CODE(FILE_DEVICE_MODEM, 6,METHOD_BUFFERED,FILE_ANY_ACCESS)

#define IOCTL_MODEM_SEND_MESSAGE         CTL_CODE(FILE_DEVICE_MODEM, 7,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_MODEM_GET_MESSAGE          CTL_CODE(FILE_DEVICE_MODEM, 8,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_MODEM_SEND_GET_MESSAGE     CTL_CODE(FILE_DEVICE_MODEM, 9,METHOD_BUFFERED,FILE_ANY_ACCESS)

#define IOCTL_MODEM_SEND_LOOPBACK_MESSAGE CTL_CODE(FILE_DEVICE_MODEM, 10,METHOD_BUFFERED,FILE_ANY_ACCESS)

#define IOCTL_MODEM_CHECK_FOR_MODEM      CTL_CODE(FILE_DEVICE_MODEM, 11,METHOD_BUFFERED,FILE_ANY_ACCESS)

#define IOCTL_MODEM_SET_MIN_POWER        CTL_CODE(FILE_DEVICE_MODEM, 12,METHOD_BUFFERED,FILE_ANY_ACCESS)

#define IOCTL_MODEM_WATCH_FOR_RESUME     CTL_CODE(FILE_DEVICE_MODEM, 13,METHOD_BUFFERED,FILE_ANY_ACCESS)

#define IOCTL_CANCEL_GET_SEND_MESSAGE    CTL_CODE(FILE_DEVICE_MODEM, 14,METHOD_BUFFERED,FILE_ANY_ACCESS)

#define IOCTL_SET_SERVER_STATE           CTL_CODE(FILE_DEVICE_MODEM, 15,METHOD_BUFFERED,FILE_ANY_ACCESS)

#define MODEM_NOPASSTHROUGH 0x00000000U
#define MODEM_PASSTHROUGH   0x00000001U
#define MODEM_DCDSNIFF      0x00000002U
#define MODEM_NOPASSTHROUGH_INC_SESSION_COUNT 0x00000003U

#define MODEM_DLE_MONITORING_OFF  0x00000000
#define MODEM_DLE_MONITORING_ON   0x00000001

#define MODEM_DLE_SHIELDING_OFF   0x00000000
#define MODEM_DLE_SHIELDING_ON    0x00000001

#define MODEM_OPEN_TYPE_TSP       0
#define MODEM_OPEN_TYPE_CLIENT    1
#define MODEM_OPEN_TYPE_WAVE      2

typedef struct _MODEM_MESSAGE {

    ULONG    TotalSize;
    ULONG    Flags;
    ULONG    SessionId;
    ULONG    RequestId;
    ULONG    Reserved[2];

} MODEM_MESSAGE, *PMODEM_MESSAGE;

#ifdef DEFINE_GUID

//
// Declare the GUID that represents the device interface for modems.
//

DEFINE_GUID(GUID_DEVINTERFACE_MODEM, 0x2c7089aa, 0x2e0e, 0x11d1, 0xb1, 0x14, 0x00, 0xc0, 0x4f, 0xc2, 0xaa, 0xe4);

//
// Obsolete device interface class GUID name.
// (use of above GUID_DEVINTERFACE_* name is recommended).
//

#define GUID_CLASS_MODEM  GUID_DEVINTERFACE_MODEM

#endif //DEFINE_GUID

#ifdef __cplusplus
}
#endif


#endif /* WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_DESKTOP) */
#pragma endregion

#endif  // _NTDDMODM_
