/*
 * Decompiled with CFR 0.152.
 */
package io.vlinx.jarxlauncher;

import io.vlinx.jarxlauncher.Launcher;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class UDPServer {
    private static long lastDataReceivedTime = 0L;
    private static int lostCount = 0;

    public static void daemon(int port) {
        if (Launcher.DEBUG) {
            System.out.println("[VLX] Start launcher daemon");
        }
        UDPServer.checkStatus();
        Runnable runnable = () -> {
            try {
                InetAddress ia = InetAddress.getByName("127.0.0.1");
                DatagramSocket ds = new DatagramSocket(port, ia);
                while (true) {
                    byte[] buffer = new byte[1024];
                    DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                    ds.receive(packet);
                    lastDataReceivedTime = System.currentTimeMillis();
                    if (Launcher.DEBUG && lostCount > 0) {
                        System.out.println("[VLX-" + System.currentTimeMillis() + "] set lostCount to 0 at " + System.currentTimeMillis());
                    }
                    lostCount = 0;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        };
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        thread.start();
    }

    private static void checkStatus() {
        Runnable runnable = () -> {
            while (true) {
                if (lastDataReceivedTime > 0L) {
                    if (lostCount >= 20) {
                        System.exit(143);
                    }
                    if (System.currentTimeMillis() - lastDataReceivedTime > 100L) {
                        if (Launcher.DEBUG) {
                            System.out.println("[VLX-" + System.currentTimeMillis() + "] Not data recv in 0.1 seconds, last packet at " + lastDataReceivedTime);
                        }
                        ++lostCount;
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        thread.start();
    }
}

