/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import sun.nio.cs.ArrayEncoder;
import sun.nio.cs.StandardCharsets;
import sun.nio.cs.Surrogate;
import sun.nio.cs.Unicode;

class UTF_8
extends Unicode {
    public UTF_8() {
        super("UTF-8", StandardCharsets.aliases_UTF_8);
    }

    @Override
    public String historicalName() {
        return "UTF8";
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder((Charset)this, null);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static final void updatePositions(Buffer buffer, int n, Buffer buffer2, int n2) {
        buffer.position(n - buffer.arrayOffset());
        buffer2.position(n2 - buffer2.arrayOffset());
    }

    private static final class Encoder
    extends CharsetEncoder
    implements ArrayEncoder {
        private Surrogate.Parser sgp;
        private byte repl = (byte)63;

        private Encoder(Charset charset) {
            super(charset, 1.1f, 3.0f);
        }

        @Override
        public boolean canEncode(char c) {
            return !Character.isSurrogate(c);
        }

        @Override
        public boolean isLegalReplacement(byte[] byArray) {
            return byArray.length == 1 && byArray[0] >= 0 || super.isLegalReplacement(byArray);
        }

        private static CoderResult overflow(CharBuffer charBuffer, int n, ByteBuffer byteBuffer, int n2) {
            UTF_8.updatePositions(charBuffer, n, byteBuffer, n2);
            return CoderResult.OVERFLOW;
        }

        private static CoderResult overflow(CharBuffer charBuffer, int n) {
            charBuffer.position(n);
            return CoderResult.OVERFLOW;
        }

        private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            char[] cArray = charBuffer.array();
            int n = charBuffer.arrayOffset() + charBuffer.position();
            int n2 = charBuffer.arrayOffset() + charBuffer.limit();
            byte[] byArray = byteBuffer.array();
            int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
            int n5 = n3 + Math.min(n2 - n, n4 - n3);
            while (n3 < n5 && cArray[n] < '\u0080') {
                byArray[n3++] = (byte)cArray[n++];
            }
            while (n < n2) {
                char c = cArray[n];
                if (c < '\u0080') {
                    if (n3 >= n4) {
                        return Encoder.overflow(charBuffer, n, byteBuffer, n3);
                    }
                    byArray[n3++] = (byte)c;
                } else if (c < '\u0800') {
                    if (n4 - n3 < 2) {
                        return Encoder.overflow(charBuffer, n, byteBuffer, n3);
                    }
                    byArray[n3++] = (byte)(0xC0 | c >> 6);
                    byArray[n3++] = (byte)(0x80 | c & 0x3F);
                } else if (Character.isSurrogate(c)) {
                    int n6;
                    if (this.sgp == null) {
                        this.sgp = new Surrogate.Parser();
                    }
                    if ((n6 = this.sgp.parse(c, cArray, n, n2)) < 0) {
                        UTF_8.updatePositions(charBuffer, n, byteBuffer, n3);
                        return this.sgp.error();
                    }
                    if (n4 - n3 < 4) {
                        return Encoder.overflow(charBuffer, n, byteBuffer, n3);
                    }
                    byArray[n3++] = (byte)(0xF0 | n6 >> 18);
                    byArray[n3++] = (byte)(0x80 | n6 >> 12 & 0x3F);
                    byArray[n3++] = (byte)(0x80 | n6 >> 6 & 0x3F);
                    byArray[n3++] = (byte)(0x80 | n6 & 0x3F);
                    ++n;
                } else {
                    if (n4 - n3 < 3) {
                        return Encoder.overflow(charBuffer, n, byteBuffer, n3);
                    }
                    byArray[n3++] = (byte)(0xE0 | c >> 12);
                    byArray[n3++] = (byte)(0x80 | c >> 6 & 0x3F);
                    byArray[n3++] = (byte)(0x80 | c & 0x3F);
                }
                ++n;
            }
            UTF_8.updatePositions(charBuffer, n, byteBuffer, n3);
            return CoderResult.UNDERFLOW;
        }

        private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            int n = charBuffer.position();
            while (charBuffer.hasRemaining()) {
                char c = charBuffer.get();
                if (c < '\u0080') {
                    if (!byteBuffer.hasRemaining()) {
                        return Encoder.overflow(charBuffer, n);
                    }
                    byteBuffer.put((byte)c);
                } else if (c < '\u0800') {
                    if (byteBuffer.remaining() < 2) {
                        return Encoder.overflow(charBuffer, n);
                    }
                    byteBuffer.put((byte)(0xC0 | c >> 6));
                    byteBuffer.put((byte)(0x80 | c & 0x3F));
                } else if (Character.isSurrogate(c)) {
                    int n2;
                    if (this.sgp == null) {
                        this.sgp = new Surrogate.Parser();
                    }
                    if ((n2 = this.sgp.parse(c, charBuffer)) < 0) {
                        charBuffer.position(n);
                        return this.sgp.error();
                    }
                    if (byteBuffer.remaining() < 4) {
                        return Encoder.overflow(charBuffer, n);
                    }
                    byteBuffer.put((byte)(0xF0 | n2 >> 18));
                    byteBuffer.put((byte)(0x80 | n2 >> 12 & 0x3F));
                    byteBuffer.put((byte)(0x80 | n2 >> 6 & 0x3F));
                    byteBuffer.put((byte)(0x80 | n2 & 0x3F));
                    ++n;
                } else {
                    if (byteBuffer.remaining() < 3) {
                        return Encoder.overflow(charBuffer, n);
                    }
                    byteBuffer.put((byte)(0xE0 | c >> 12));
                    byteBuffer.put((byte)(0x80 | c >> 6 & 0x3F));
                    byteBuffer.put((byte)(0x80 | c & 0x3F));
                }
                ++n;
            }
            charBuffer.position(n);
            return CoderResult.UNDERFLOW;
        }

        @Override
        protected final CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            if (charBuffer.hasArray() && byteBuffer.hasArray()) {
                return this.encodeArrayLoop(charBuffer, byteBuffer);
            }
            return this.encodeBufferLoop(charBuffer, byteBuffer);
        }

        @Override
        protected void implReplaceWith(byte[] byArray) {
            this.repl = byArray[0];
        }

        @Override
        public int encode(char[] cArray, int n, int n2, byte[] byArray) {
            int n3 = n + n2;
            int n4 = 0;
            int n5 = n4 + Math.min(n2, byArray.length);
            while (n4 < n5 && cArray[n] < '\u0080') {
                byArray[n4++] = (byte)cArray[n++];
            }
            while (n < n3) {
                char c;
                if ((c = cArray[n++]) < '\u0080') {
                    byArray[n4++] = (byte)c;
                    continue;
                }
                if (c < '\u0800') {
                    byArray[n4++] = (byte)(0xC0 | c >> 6);
                    byArray[n4++] = (byte)(0x80 | c & 0x3F);
                    continue;
                }
                if (Character.isSurrogate(c)) {
                    int n6;
                    if (this.sgp == null) {
                        this.sgp = new Surrogate.Parser();
                    }
                    if ((n6 = this.sgp.parse(c, cArray, n - 1, n3)) < 0) {
                        if (this.malformedInputAction() != CodingErrorAction.REPLACE) {
                            return -1;
                        }
                        byArray[n4++] = this.repl;
                        continue;
                    }
                    byArray[n4++] = (byte)(0xF0 | n6 >> 18);
                    byArray[n4++] = (byte)(0x80 | n6 >> 12 & 0x3F);
                    byArray[n4++] = (byte)(0x80 | n6 >> 6 & 0x3F);
                    byArray[n4++] = (byte)(0x80 | n6 & 0x3F);
                    ++n;
                    continue;
                }
                byArray[n4++] = (byte)(0xE0 | c >> 12);
                byArray[n4++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n4++] = (byte)(0x80 | c & 0x3F);
            }
            return n4;
        }
    }

    private static class Decoder
    extends CharsetDecoder {
        private Decoder(Charset cs) {
            super(cs, 1.0f, 1.0f);
        }

        private static boolean isNotContinuation(int b) {
            return (b & 0xC0) != 128;
        }

        private static boolean isMalformed3(int b1, int b2, int b3) {
            return b1 == -32 && (b2 & 0xE0) == 128 || (b2 & 0xC0) != 128 || (b3 & 0xC0) != 128;
        }

        private static boolean isMalformed3_2(int b1, int b2) {
            return b1 == -32 && (b2 & 0xE0) == 128 || (b2 & 0xC0) != 128;
        }

        private static boolean isMalformed4(int b2, int b3, int b4) {
            return (b2 & 0xC0) != 128 || (b3 & 0xC0) != 128 || (b4 & 0xC0) != 128;
        }

        private static boolean isMalformed4_2(int b1, int b2) {
            return b1 == 240 && (b2 < 144 || b2 > 191) || b1 == 244 && (b2 & 0xF0) != 128 || (b2 & 0xC0) != 128;
        }

        private static boolean isMalformed4_3(int b3) {
            return (b3 & 0xC0) != 128;
        }

        private static CoderResult malformedN(ByteBuffer src, int nb) {
            switch (nb) {
                case 1: 
                case 2: {
                    return CoderResult.malformedForLength(1);
                }
                case 3: {
                    byte b1 = src.get();
                    byte b2 = src.get();
                    return CoderResult.malformedForLength(b1 == -32 && (b2 & 0xE0) == 128 || Decoder.isNotContinuation(b2) ? 1 : 2);
                }
                case 4: {
                    int b1 = src.get() & 0xFF;
                    int b2 = src.get() & 0xFF;
                    if (b1 > 244 || b1 == 240 && (b2 < 144 || b2 > 191) || b1 == 244 && (b2 & 0xF0) != 128 || Decoder.isNotContinuation(b2)) {
                        return CoderResult.malformedForLength(1);
                    }
                    if (Decoder.isNotContinuation(src.get())) {
                        return CoderResult.malformedForLength(2);
                    }
                    return CoderResult.malformedForLength(3);
                }
            }
            assert (false);
            return null;
        }

        private static CoderResult malformed(ByteBuffer src, int sp, CharBuffer dst, int dp, int nb) {
            src.position(sp - src.arrayOffset());
            CoderResult cr = Decoder.malformedN(src, nb);
            UTF_8.updatePositions(src, sp, dst, dp);
            return cr;
        }

        private static CoderResult malformed(ByteBuffer src, int mark, int nb) {
            src.position(mark);
            CoderResult cr = Decoder.malformedN(src, nb);
            src.position(mark);
            return cr;
        }

        private static CoderResult malformedForLength(ByteBuffer src, int sp, CharBuffer dst, int dp, int malformedNB) {
            UTF_8.updatePositions(src, sp, dst, dp);
            return CoderResult.malformedForLength(malformedNB);
        }

        private static CoderResult malformedForLength(ByteBuffer src, int mark, int malformedNB) {
            src.position(mark);
            return CoderResult.malformedForLength(malformedNB);
        }

        private static CoderResult xflow(Buffer src, int sp, int sl, Buffer dst, int dp, int nb) {
            UTF_8.updatePositions(src, sp, dst, dp);
            return nb == 0 || sl - sp < nb ? CoderResult.UNDERFLOW : CoderResult.OVERFLOW;
        }

        private static CoderResult xflow(Buffer src, int mark, int nb) {
            src.position(mark);
            return nb == 0 || src.remaining() < nb ? CoderResult.UNDERFLOW : CoderResult.OVERFLOW;
        }

        private CoderResult decodeArrayLoop(ByteBuffer src, CharBuffer dst) {
            byte[] sa = src.array();
            int soff = src.arrayOffset();
            int sp = soff + src.position();
            int sl = soff + src.limit();
            char[] da = dst.array();
            int doff = dst.arrayOffset();
            int dp = doff + dst.position();
            int dl = doff + dst.limit();
            int n = JLA.decodeASCII(sa, sp, da, dp, Math.min(sl - sp, dl - dp));
            sp += n;
            dp += n;
            while (sp < sl) {
                byte b3;
                byte b2;
                int srcRemaining;
                int b1 = sa[sp];
                if (b1 >= 0) {
                    if (dp >= dl) {
                        return Decoder.xflow(src, sp, sl, dst, dp, 1);
                    }
                    da[dp++] = (char)b1;
                    ++sp;
                    continue;
                }
                if (b1 >> 5 == -2 && (b1 & 0x1E) != 0) {
                    if (sl - sp < 2 || dp >= dl) {
                        return Decoder.xflow(src, sp, sl, dst, dp, 2);
                    }
                    byte b22 = sa[sp + 1];
                    if (Decoder.isNotContinuation(b22)) {
                        return Decoder.malformedForLength(src, sp, dst, dp, 1);
                    }
                    da[dp++] = (char)(b1 << 6 ^ b22 ^ 0xF80);
                    sp += 2;
                    continue;
                }
                if (b1 >> 4 == -2) {
                    srcRemaining = sl - sp;
                    if (srcRemaining < 3 || dp >= dl) {
                        if (srcRemaining > 1 && Decoder.isMalformed3_2(b1, sa[sp + 1])) {
                            return Decoder.malformedForLength(src, sp, dst, dp, 1);
                        }
                        return Decoder.xflow(src, sp, sl, dst, dp, 3);
                    }
                    b2 = sa[sp + 1];
                    b3 = sa[sp + 2];
                    if (Decoder.isMalformed3(b1, b2, b3)) {
                        return Decoder.malformed(src, sp, dst, dp, 3);
                    }
                    char c = (char)(b1 << 12 ^ b2 << 6 ^ (b3 ^ 0xFFFE1F80));
                    if (Character.isSurrogate(c)) {
                        return Decoder.malformedForLength(src, sp, dst, dp, 3);
                    }
                    da[dp++] = c;
                    sp += 3;
                    continue;
                }
                if (b1 >> 3 == -2) {
                    srcRemaining = sl - sp;
                    if (srcRemaining < 4 || dl - dp < 2) {
                        if ((b1 &= 0xFF) > 244 || srcRemaining > 1 && Decoder.isMalformed4_2(b1, sa[sp + 1] & 0xFF)) {
                            return Decoder.malformedForLength(src, sp, dst, dp, 1);
                        }
                        if (srcRemaining > 2 && Decoder.isMalformed4_3(sa[sp + 2])) {
                            return Decoder.malformedForLength(src, sp, dst, dp, 2);
                        }
                        return Decoder.xflow(src, sp, sl, dst, dp, 4);
                    }
                    b2 = sa[sp + 1];
                    b3 = sa[sp + 2];
                    byte b4 = sa[sp + 3];
                    int uc = b1 << 18 ^ b2 << 12 ^ b3 << 6 ^ (b4 ^ 0x381F80);
                    if (Decoder.isMalformed4(b2, b3, b4) || !Character.isSupplementaryCodePoint(uc)) {
                        return Decoder.malformed(src, sp, dst, dp, 4);
                    }
                    da[dp++] = Character.highSurrogate(uc);
                    da[dp++] = Character.lowSurrogate(uc);
                    sp += 4;
                    continue;
                }
                return Decoder.malformed(src, sp, dst, dp, 1);
            }
            return Decoder.xflow(src, sp, sl, dst, dp, 0);
        }

        private CoderResult decodeBufferLoop(ByteBuffer src, CharBuffer dst) {
            int mark = src.position();
            int limit = src.limit();
            while (mark < limit) {
                byte b3;
                byte b2;
                int srcRemaining;
                int b1 = src.get();
                if (b1 >= 0) {
                    if (dst.remaining() < 1) {
                        return Decoder.xflow(src, mark, 1);
                    }
                    dst.put((char)b1);
                    ++mark;
                    continue;
                }
                if (b1 >> 5 == -2 && (b1 & 0x1E) != 0) {
                    if (limit - mark < 2 || dst.remaining() < 1) {
                        return Decoder.xflow(src, mark, 2);
                    }
                    byte b22 = src.get();
                    if (Decoder.isNotContinuation(b22)) {
                        return Decoder.malformedForLength(src, mark, 1);
                    }
                    dst.put((char)(b1 << 6 ^ b22 ^ 0xF80));
                    mark += 2;
                    continue;
                }
                if (b1 >> 4 == -2) {
                    srcRemaining = limit - mark;
                    if (srcRemaining < 3 || dst.remaining() < 1) {
                        if (srcRemaining > 1 && Decoder.isMalformed3_2(b1, src.get())) {
                            return Decoder.malformedForLength(src, mark, 1);
                        }
                        return Decoder.xflow(src, mark, 3);
                    }
                    b2 = src.get();
                    if (Decoder.isMalformed3(b1, b2, b3 = src.get())) {
                        return Decoder.malformed(src, mark, 3);
                    }
                    char c = (char)(b1 << 12 ^ b2 << 6 ^ (b3 ^ 0xFFFE1F80));
                    if (Character.isSurrogate(c)) {
                        return Decoder.malformedForLength(src, mark, 3);
                    }
                    dst.put(c);
                    mark += 3;
                    continue;
                }
                if (b1 >> 3 == -2) {
                    srcRemaining = limit - mark;
                    if (srcRemaining < 4 || dst.remaining() < 2) {
                        if ((b1 &= 0xFF) > 244 || srcRemaining > 1 && Decoder.isMalformed4_2(b1, src.get() & 0xFF)) {
                            return Decoder.malformedForLength(src, mark, 1);
                        }
                        if (srcRemaining > 2 && Decoder.isMalformed4_3(src.get())) {
                            return Decoder.malformedForLength(src, mark, 2);
                        }
                        return Decoder.xflow(src, mark, 4);
                    }
                    b2 = src.get();
                    b3 = src.get();
                    byte b4 = src.get();
                    int uc = b1 << 18 ^ b2 << 12 ^ b3 << 6 ^ (b4 ^ 0x381F80);
                    if (Decoder.isMalformed4(b2, b3, b4) || !Character.isSupplementaryCodePoint(uc)) {
                        return Decoder.malformed(src, mark, 4);
                    }
                    dst.put(Character.highSurrogate(uc));
                    dst.put(Character.lowSurrogate(uc));
                    mark += 4;
                    continue;
                }
                return Decoder.malformed(src, mark, 1);
            }
            return Decoder.xflow(src, mark, 0);
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer src, CharBuffer dst) {
            if (src.hasArray() && dst.hasArray()) {
                return this.decodeArrayLoop(src, dst);
            }
            return this.decodeBufferLoop(src, dst);
        }
    }
}

