/*
 * Decompiled with CFR 0.152.
 */
package io.vlinx.javax;

import io.vlinx.javax.PidChecker;
import io.vlinx.javax.ResourceUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class Main {
    public static void main(String[] args) {
        try {
            String jarFilePath = System.getProperty("VlxJarFile");
            String classpath = System.getProperty("VlxClassPath");
            String mainClass = System.getProperty("VlxMainClass");
            try {
                int vlxPid = Integer.parseInt(System.getProperty("VlxPid"));
                if (System.getProperty("DisableParentCheck") == null) {
                    PidChecker.startCheck(vlxPid);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (jarFilePath != null && !jarFilePath.isEmpty()) {
                Main.runWithJarFile(jarFilePath, args);
            } else {
                Main.runWithClassPath(classpath, mainClass, args);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void runWithJarFile(String jarFilePath, String[] args) throws Exception {
        String mainClass;
        JarFile jarFile = new JarFile(jarFilePath);
        Manifest manifest = jarFile.getManifest();
        if (manifest == null) {
            System.err.println("[VLX] Can't read manifest from jar file: " + jarFilePath);
            System.exit(1);
        }
        if ((mainClass = manifest.getMainAttributes().getValue("Main-Class")) == null || mainClass.isEmpty()) {
            System.err.println("[VLX] Can't read Main-Class from jar file: " + jarFilePath);
            System.exit(1);
        }
        Main.runWithClassPath(jarFilePath, mainClass, args);
    }

    private static void runWithClassPath(String classpath, String mainClass, String[] args) throws Exception {
        String javaVersion;
        if (classpath == null || classpath.isEmpty()) {
            System.err.println("[VLX] No classpath specified");
            System.exit(1);
        }
        if (mainClass == null || mainClass.isEmpty()) {
            System.err.println("[VLX] No main class specified");
            System.exit(1);
        }
        String separator = ":";
        String osName = System.getProperties().getProperty("os.name");
        if (osName.toLowerCase().startsWith("win")) {
            separator = ";";
        }
        String[] entries = classpath.split(separator);
        ArrayList<URL> cpUrls = new ArrayList<URL>();
        StringBuilder cpBuilder = new StringBuilder();
        for (String entry : entries) {
            try {
                if (entry.endsWith("*")) {
                    File entryDir = new File(entry = entry.substring(0, entry.length() - 1));
                    if (!entryDir.exists() || !entryDir.isDirectory()) continue;
                    for (File file : entryDir.listFiles()) {
                        if (!file.getName().toLowerCase().endsWith(".jar") && !file.getName().toLowerCase().endsWith(".zip") && !file.getName().toLowerCase().endsWith(".jarx")) continue;
                        cpBuilder.append(separator + file.getAbsolutePath());
                        cpUrls.add(file.toURI().toURL());
                    }
                    continue;
                }
                cpBuilder.append(separator + new File(entry).getAbsolutePath());
                cpUrls.add(new File(entry).toURI().toURL());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        classpath = cpBuilder.toString();
        if (classpath.length() > 1) {
            classpath = classpath.substring(1);
        }
        if ((javaVersion = Main.getJavaVersion()).startsWith("1.8")) {
            URL[] cpUrlsArr = cpUrls.toArray(new URL[0]);
            URLClassLoader classLoader = new URLClassLoader(cpUrlsArr, Main.class.getClassLoader());
            Thread.currentThread().setContextClassLoader(classLoader);
            Class<?> c = Class.forName(mainClass, true, classLoader);
            Method main = c.getMethod("main", args.getClass());
            main.invoke(null, new Object[]{args});
        } else {
            classpath = classpath + separator + ResourceUtils.getResourcePath("javax.jarx");
            System.setProperty("$vlxcp", classpath);
            System.setProperty("java.class.path", classpath);
            Class<?> c = Class.forName(mainClass, true, Main.class.getClassLoader());
            Method main = c.getMethod("main", args.getClass());
            main.invoke(null, new Object[]{args});
        }
    }

    private static String getJavaVersion() {
        String javaVersion = System.getProperty("java.version");
        return javaVersion;
    }
}

