/*
 * Decompiled with CFR 0.152.
 */
package io.vlinx.logging;

import io.vlinx.utils.DateUtil;
import io.vlinx.utils.ExceptionUtil;
import io.vlinx.utils.FileUtil;
import java.io.File;
import java.io.IOException;

public class Logger {
    private static String LOG_DIR = "";

    public static void SET_LOG_DIR(String path) {
        if (new File(path).isFile()) {
            Logger.ERROR(path + " is a file");
            return;
        }
        boolean result = true;
        if (!new File(path).exists()) {
            result = FileUtil.mkdirs(path);
        }
        if (!result) {
            Logger.ERROR("Could not create log dir: " + path);
            return;
        }
        LOG_DIR = path;
    }

    public static String GET_LOG_DIR() {
        return new File(LOG_DIR).getAbsolutePath();
    }

    public static String INFO(String tag, Object msg) {
        String msgStr = tag + ": " + msg;
        return Logger.INFO(msgStr);
    }

    public static String INFO(Object msg) {
        String INFO_PATH = new File(LOG_DIR).getAbsolutePath() + File.separator + "info.log";
        String log = DateUtil.getCurrentDateTimeStr() + " [INFO] " + msg;
        System.out.println(log);
        try {
            FileUtil.appendFile(log, INFO_PATH);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return log;
    }

    public static String STDOUT(String tag, Object msg) {
        String msgStr = tag + ": " + msg;
        return Logger.STDOUT(msgStr);
    }

    public static String STDOUT(Object msg) {
        String INFO_PATH = new File(LOG_DIR).getAbsolutePath() + File.separator + "info.log";
        String log = DateUtil.getCurrentDateTimeStr() + " [STDOUT] " + msg;
        System.out.println(log);
        try {
            FileUtil.appendFile(log, INFO_PATH);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return log;
    }

    public static String STDERR(String tag, Object msg) {
        String msgStr = tag + ": " + msg;
        return Logger.STDOUT(msgStr);
    }

    public static String STDERR(Object msg) {
        String INFO_PATH = new File(LOG_DIR).getAbsolutePath() + File.separator + "info.log";
        String log = DateUtil.getCurrentDateTimeStr() + " [STDERR] " + msg;
        System.out.println(log);
        try {
            FileUtil.appendFile(log, INFO_PATH);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return log;
    }

    public static String DEBUG(String tag, Object msg) {
        String msgStr = tag + ": " + msg;
        return Logger.DEBUG(msgStr);
    }

    public static String DEBUG(Object msg) {
        String log = DateUtil.getCurrentDateTimeStr() + " [DEBUG] " + msg;
        System.out.println(log);
        return log;
    }

    public static String VERBOSE(String tag, Object msg) {
        String msgStr = tag + ": " + msg;
        return Logger.DEBUG(msgStr);
    }

    public static String VERBOSE(Object msg) {
        String log = DateUtil.getCurrentDateTimeStr() + " [VERBOSE] " + msg;
        System.out.println(log);
        return log;
    }

    public static String ERROR(String tag, Object msg) {
        String msgStr = tag + ": " + msg;
        return Logger.ERROR(msgStr);
    }

    public static String WARN(String tag, Object msg) {
        String msgStr = tag + ": " + msg;
        return Logger.WARN(msgStr);
    }

    public static String FATAL(String tag, Object msg) {
        String msgStr = tag + ": " + msg;
        return Logger.FATAL(msgStr);
    }

    public static String WARN(Object msg) {
        String INFO_PATH = new File(LOG_DIR).getAbsolutePath() + File.separator + "info.log";
        String ERROR_PATH = new File(LOG_DIR).getAbsolutePath() + File.separator + "error.log";
        String log = DateUtil.getCurrentDateTimeStr() + " [WARN] " + msg;
        System.out.println(log);
        try {
            FileUtil.appendFile(log, ERROR_PATH);
            FileUtil.appendFile(log, INFO_PATH);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return log;
    }

    public static String WARN(Exception e) {
        String INFO_PATH = new File(LOG_DIR).getAbsolutePath() + File.separator + "info.log";
        String ERROR_PATH = new File(LOG_DIR).getAbsolutePath() + File.separator + "error.log";
        String log = DateUtil.getCurrentDateTimeStr() + " [WARN] " + ExceptionUtil.getStackTrace(e);
        System.out.println(log);
        try {
            FileUtil.appendFile(log, ERROR_PATH);
            FileUtil.appendFile(log, INFO_PATH);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return log;
    }

    public static String ERROR(Object msg) {
        String INFO_PATH = new File(LOG_DIR).getAbsolutePath() + File.separator + "info.log";
        String ERROR_PATH = new File(LOG_DIR).getAbsolutePath() + File.separator + "error.log";
        String log = DateUtil.getCurrentDateTimeStr() + " [ERROR] " + msg;
        System.err.println(log);
        try {
            FileUtil.appendFile(log, ERROR_PATH);
            FileUtil.appendFile(log, INFO_PATH);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return log;
    }

    public static String ERROR(Exception e) {
        String INFO_PATH = new File(LOG_DIR).getAbsolutePath() + File.separator + "info.log";
        String ERROR_PATH = new File(LOG_DIR).getAbsolutePath() + File.separator + "error.log";
        String log = DateUtil.getCurrentDateTimeStr() + " [ERROR] " + ExceptionUtil.getStackTrace(e);
        System.err.println(log);
        try {
            FileUtil.appendFile(log, ERROR_PATH);
            FileUtil.appendFile(log, INFO_PATH);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return log;
    }

    public static String FATAL(Object msg) {
        String INFO_PATH = new File(LOG_DIR).getAbsolutePath() + File.separator + "info.log";
        String ERROR_PATH = new File(LOG_DIR).getAbsolutePath() + File.separator + "error.log";
        String log = DateUtil.getCurrentDateTimeStr() + " [FATAL] " + msg;
        System.err.println(log);
        try {
            FileUtil.appendFile(log, ERROR_PATH);
            FileUtil.appendFile(log, INFO_PATH);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return log;
    }

    public static String FATAL(Exception e) {
        String INFO_PATH = new File(LOG_DIR).getAbsolutePath() + File.separator + "info.log";
        String ERROR_PATH = new File(LOG_DIR).getAbsolutePath() + File.separator + "error.log";
        String log = DateUtil.getCurrentDateTimeStr() + " [FATAL] " + ExceptionUtil.getStackTrace(e);
        System.err.println(log);
        try {
            FileUtil.appendFile(log, ERROR_PATH);
            FileUtil.appendFile(log, INFO_PATH);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return log;
    }
}

