// __msvc_format_ucd_tables.hpp internal header

// Copyright (c) Microsoft Corporation.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception

// WARNING, this entire header is generated by
// tools/unicode_properties_parse/grapheme_break_property_data_gen.py
// DO NOT MODIFY!

// UNICODE, INC. LICENSE AGREEMENT - DATA FILES AND SOFTWARE
//
// See Terms of Use <https://www.unicode.org/copyright.html>
// for definitions of Unicode Inc.'s Data Files and Software.
//
// NOTICE TO USER: Carefully read the following legal agreement.
// BY DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING UNICODE INC.'S
// DATA FILES ("DATA FILES"), AND/OR SOFTWARE ("SOFTWARE"),
// YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
// TERMS AND CONDITIONS OF THIS AGREEMENT.
// IF YOU DO NOT AGREE, DO NOT DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE
// THE DATA FILES OR SOFTWARE.
//
// COPYRIGHT AND PERMISSION NOTICE
//
// Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
// Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of the Unicode data files and any associated documentation
// (the "Data Files") or Unicode software and any associated documentation
// (the "Software") to deal in the Data Files or Software
// without restriction, including without limitation the rights to use,
// copy, modify, merge, publish, distribute, and/or sell copies of
// the Data Files or Software, and to permit persons to whom the Data Files
// or Software are furnished to do so, provided that either
// (a) this copyright and permission notice appear with all copies
// of the Data Files or Software, or
// (b) this copyright and permission notice appear in associated
// Documentation.
//
// THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
// ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT OF THIRD PARTY RIGHTS.
// IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
// NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
// DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
// DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
// TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
// PERFORMANCE OF THE DATA FILES OR SOFTWARE.
//
// Except as contained in this notice, the name of a copyright holder
// shall not be used in advertising or otherwise to promote the sale,
// use or other dealings in these Data Files or Software without prior
// written authorization of the copyright holder.

#pragma once
#ifndef __MSVC_FORMAT_UCD_TABLES_HPP
#define __MSVC_FORMAT_UCD_TABLES_HPP
#include <yvals_core.h>
#if _STL_COMPILER_PREPROCESSOR

#include <cstdint>
#include <limits>
#include <xutility>

#pragma pack(push, _CRT_PACKING)
#pragma warning(push, _STL_WARNING_LEVEL)
#pragma warning(disable : _STL_DISABLED_WARNINGS)
_STL_DISABLE_CLANG_WARNINGS
#pragma push_macro("new")
#undef new

_STD_BEGIN

template <class _ValueEnum, size_t _NumRanges, bool _Is_binary_property>
struct _Unicode_property_data {
    uint32_t _Lower_bounds[_NumRanges];
    uint16_t _Props_and_size[_NumRanges];
    _NODISCARD constexpr _ValueEnum _Get_property_for_codepoint(const uint32_t _Code_point) const noexcept {
        ptrdiff_t _Upper_idx = _STD upper_bound(_Lower_bounds, _STD end(_Lower_bounds), _Code_point) - _Lower_bounds;
        constexpr auto _No_value_constant = static_cast<_ValueEnum>((numeric_limits<uint8_t>::max)());
        if (_Upper_idx == 0) {
            return _No_value_constant;
        }
        --_Upper_idx;
        const uint32_t _Lower_bound = _Lower_bounds[_Upper_idx];
        const uint16_t _Data        = _Props_and_size[_Upper_idx];
        _STL_INTERNAL_CHECK(_Code_point >= _Lower_bound);
        if constexpr (_Is_binary_property) {
            if (_Code_point < _Lower_bound + _Data) {
                return static_cast<_ValueEnum>(0);
            }
        } else {
            const uint16_t _Size   = static_cast<uint16_t>(_Data & 0x0FFF);
            const _ValueEnum _Prop = static_cast<_ValueEnum>((_Data & 0xF000) >> 12);
            if (_Code_point < _Lower_bound + _Size) {
                return _Prop;
            }
        }
        return _No_value_constant;
    }
};

// The following static data tables are generated from the Unicode character database.
// _Grapheme_Break_property_data comes from ucd/auxiliary/GraphemeBreakProperty.txt.
//
// _Extended_Pictographic_property_data comes from ucd/emoji/emoji-data.txt.
//
// __printable_property_data comes from ucd/extracted/DerivedGeneralCategory.txt.
//
// _Grapheme_Extend_property_data comes from ucd/DerivedCoreProperties.txt.
//
// The enums containing the values for the properties are also generated, in order to ensure they match
// up correctly with how we're parsing them.
//
// All sets of data tables are generated by tools/unicode_properties_parse/grapheme_break_property_data_gen.py in the
// https://github.com/microsoft/stl repository.
//
// The data format is a set of arrays for each character property. The first is an array of uint32_t encoding
// the lower bound of each range of codepoints that has the given property.
// The second is an array of uint16_t.
// - For enumerated properties, this array encodes both the range size and property value as follows:
//   16               12                                   0
//   +-----------------------------------------------------+
//   | property_value  |              range_size           |
//   +-----------------------------------------------------+
//   that is: the size is stored in the least significant 12 bits
//   (leading to a max size of 4095), and the property value is stored in the most significant 4 bits,
//   leading to a maximum of 16 property values.
// - For binary properties, this array simply stores the range size.
//
// Codepoint ranges may not overlap, and, within one property, a codepoint may only appear once. Furthermore the
// codepoint lower bounds appear in sorted (ascending) order.

// GraphemeBreakProperty-15.0.0.txt
// Date: 2022-04-27, 17:07:38 GMT
enum class _Grapheme_Break_property_values : uint8_t {
    _CR_value,
    _Control_value,
    _Extend_value,
    _L_value,
    _LF_value,
    _LV_value,
    _LVT_value,
    _Prepend_value,
    _Regional_Indicator_value,
    _SpacingMark_value,
    _T_value,
    _V_value,
    _ZWJ_value,
    _No_value = 255
};

// GraphemeBreakProperty-15.0.0.txt
// Date: 2022-04-27, 17:07:38 GMT
inline constexpr _Unicode_property_data<_Grapheme_Break_property_values, 1371, false> _Grapheme_Break_property_data{
    {0x0, 0xa, 0xb, 0xd, 0xe, 0x7f, 0xad, 0x300, 0x483, 0x591, 0x5bf, 0x5c1, 0x5c4, 0x5c7, 0x600, 0x610, 0x61c, 0x64b,
        0x670, 0x6d6, 0x6dd, 0x6df, 0x6e7, 0x6ea, 0x70f, 0x711, 0x730, 0x7a6, 0x7eb, 0x7fd, 0x816, 0x81b, 0x825, 0x829,
        0x859, 0x890, 0x898, 0x8ca, 0x8e2, 0x8e3, 0x903, 0x93a, 0x93b, 0x93c, 0x93e, 0x941, 0x949, 0x94d, 0x94e, 0x951,
        0x962, 0x981, 0x982, 0x9bc, 0x9be, 0x9bf, 0x9c1, 0x9c7, 0x9cb, 0x9cd, 0x9d7, 0x9e2, 0x9fe, 0xa01, 0xa03, 0xa3c,
        0xa3e, 0xa41, 0xa47, 0xa4b, 0xa51, 0xa70, 0xa75, 0xa81, 0xa83, 0xabc, 0xabe, 0xac1, 0xac7, 0xac9, 0xacb, 0xacd,
        0xae2, 0xafa, 0xb01, 0xb02, 0xb3c, 0xb3e, 0xb40, 0xb41, 0xb47, 0xb4b, 0xb4d, 0xb55, 0xb62, 0xb82, 0xbbe, 0xbbf,
        0xbc0, 0xbc1, 0xbc6, 0xbca, 0xbcd, 0xbd7, 0xc00, 0xc01, 0xc04, 0xc3c, 0xc3e, 0xc41, 0xc46, 0xc4a, 0xc55, 0xc62,
        0xc81, 0xc82, 0xcbc, 0xcbe, 0xcbf, 0xcc0, 0xcc2, 0xcc3, 0xcc6, 0xcc7, 0xcca, 0xccc, 0xcd5, 0xce2, 0xcf3, 0xd00,
        0xd02, 0xd3b, 0xd3e, 0xd3f, 0xd41, 0xd46, 0xd4a, 0xd4d, 0xd4e, 0xd57, 0xd62, 0xd81, 0xd82, 0xdca, 0xdcf, 0xdd0,
        0xdd2, 0xdd6, 0xdd8, 0xddf, 0xdf2, 0xe31, 0xe33, 0xe34, 0xe47, 0xeb1, 0xeb3, 0xeb4, 0xec8, 0xf18, 0xf35, 0xf37,
        0xf39, 0xf3e, 0xf71, 0xf7f, 0xf80, 0xf86, 0xf8d, 0xf99, 0xfc6, 0x102d, 0x1031, 0x1032, 0x1039, 0x103b, 0x103d,
        0x1056, 0x1058, 0x105e, 0x1071, 0x1082, 0x1084, 0x1085, 0x108d, 0x109d, 0x1100, 0x1160, 0x11a8, 0x135d, 0x1712,
        0x1715, 0x1732, 0x1734, 0x1752, 0x1772, 0x17b4, 0x17b6, 0x17b7, 0x17be, 0x17c6, 0x17c7, 0x17c9, 0x17dd, 0x180b,
        0x180e, 0x180f, 0x1885, 0x18a9, 0x1920, 0x1923, 0x1927, 0x1929, 0x1930, 0x1932, 0x1933, 0x1939, 0x1a17, 0x1a19,
        0x1a1b, 0x1a55, 0x1a56, 0x1a57, 0x1a58, 0x1a60, 0x1a62, 0x1a65, 0x1a6d, 0x1a73, 0x1a7f, 0x1ab0, 0x1b00, 0x1b04,
        0x1b34, 0x1b3b, 0x1b3c, 0x1b3d, 0x1b42, 0x1b43, 0x1b6b, 0x1b80, 0x1b82, 0x1ba1, 0x1ba2, 0x1ba6, 0x1ba8, 0x1baa,
        0x1bab, 0x1be6, 0x1be7, 0x1be8, 0x1bea, 0x1bed, 0x1bee, 0x1bef, 0x1bf2, 0x1c24, 0x1c2c, 0x1c34, 0x1c36, 0x1cd0,
        0x1cd4, 0x1ce1, 0x1ce2, 0x1ced, 0x1cf4, 0x1cf7, 0x1cf8, 0x1dc0, 0x200b, 0x200c, 0x200d, 0x200e, 0x2028, 0x2060,
        0x20d0, 0x2cef, 0x2d7f, 0x2de0, 0x302a, 0x3099, 0xa66f, 0xa674, 0xa69e, 0xa6f0, 0xa802, 0xa806, 0xa80b, 0xa823,
        0xa825, 0xa827, 0xa82c, 0xa880, 0xa8b4, 0xa8c4, 0xa8e0, 0xa8ff, 0xa926, 0xa947, 0xa952, 0xa960, 0xa980, 0xa983,
        0xa9b3, 0xa9b4, 0xa9b6, 0xa9ba, 0xa9bc, 0xa9be, 0xa9e5, 0xaa29, 0xaa2f, 0xaa31, 0xaa33, 0xaa35, 0xaa43, 0xaa4c,
        0xaa4d, 0xaa7c, 0xaab0, 0xaab2, 0xaab7, 0xaabe, 0xaac1, 0xaaeb, 0xaaec, 0xaaee, 0xaaf5, 0xaaf6, 0xabe3, 0xabe5,
        0xabe6, 0xabe8, 0xabe9, 0xabec, 0xabed, 0xac00, 0xac01, 0xac1c, 0xac1d, 0xac38, 0xac39, 0xac54, 0xac55, 0xac70,
        0xac71, 0xac8c, 0xac8d, 0xaca8, 0xaca9, 0xacc4, 0xacc5, 0xace0, 0xace1, 0xacfc, 0xacfd, 0xad18, 0xad19, 0xad34,
        0xad35, 0xad50, 0xad51, 0xad6c, 0xad6d, 0xad88, 0xad89, 0xada4, 0xada5, 0xadc0, 0xadc1, 0xaddc, 0xaddd, 0xadf8,
        0xadf9, 0xae14, 0xae15, 0xae30, 0xae31, 0xae4c, 0xae4d, 0xae68, 0xae69, 0xae84, 0xae85, 0xaea0, 0xaea1, 0xaebc,
        0xaebd, 0xaed8, 0xaed9, 0xaef4, 0xaef5, 0xaf10, 0xaf11, 0xaf2c, 0xaf2d, 0xaf48, 0xaf49, 0xaf64, 0xaf65, 0xaf80,
        0xaf81, 0xaf9c, 0xaf9d, 0xafb8, 0xafb9, 0xafd4, 0xafd5, 0xaff0, 0xaff1, 0xb00c, 0xb00d, 0xb028, 0xb029, 0xb044,
        0xb045, 0xb060, 0xb061, 0xb07c, 0xb07d, 0xb098, 0xb099, 0xb0b4, 0xb0b5, 0xb0d0, 0xb0d1, 0xb0ec, 0xb0ed, 0xb108,
        0xb109, 0xb124, 0xb125, 0xb140, 0xb141, 0xb15c, 0xb15d, 0xb178, 0xb179, 0xb194, 0xb195, 0xb1b0, 0xb1b1, 0xb1cc,
        0xb1cd, 0xb1e8, 0xb1e9, 0xb204, 0xb205, 0xb220, 0xb221, 0xb23c, 0xb23d, 0xb258, 0xb259, 0xb274, 0xb275, 0xb290,
        0xb291, 0xb2ac, 0xb2ad, 0xb2c8, 0xb2c9, 0xb2e4, 0xb2e5, 0xb300, 0xb301, 0xb31c, 0xb31d, 0xb338, 0xb339, 0xb354,
        0xb355, 0xb370, 0xb371, 0xb38c, 0xb38d, 0xb3a8, 0xb3a9, 0xb3c4, 0xb3c5, 0xb3e0, 0xb3e1, 0xb3fc, 0xb3fd, 0xb418,
        0xb419, 0xb434, 0xb435, 0xb450, 0xb451, 0xb46c, 0xb46d, 0xb488, 0xb489, 0xb4a4, 0xb4a5, 0xb4c0, 0xb4c1, 0xb4dc,
        0xb4dd, 0xb4f8, 0xb4f9, 0xb514, 0xb515, 0xb530, 0xb531, 0xb54c, 0xb54d, 0xb568, 0xb569, 0xb584, 0xb585, 0xb5a0,
        0xb5a1, 0xb5bc, 0xb5bd, 0xb5d8, 0xb5d9, 0xb5f4, 0xb5f5, 0xb610, 0xb611, 0xb62c, 0xb62d, 0xb648, 0xb649, 0xb664,
        0xb665, 0xb680, 0xb681, 0xb69c, 0xb69d, 0xb6b8, 0xb6b9, 0xb6d4, 0xb6d5, 0xb6f0, 0xb6f1, 0xb70c, 0xb70d, 0xb728,
        0xb729, 0xb744, 0xb745, 0xb760, 0xb761, 0xb77c, 0xb77d, 0xb798, 0xb799, 0xb7b4, 0xb7b5, 0xb7d0, 0xb7d1, 0xb7ec,
        0xb7ed, 0xb808, 0xb809, 0xb824, 0xb825, 0xb840, 0xb841, 0xb85c, 0xb85d, 0xb878, 0xb879, 0xb894, 0xb895, 0xb8b0,
        0xb8b1, 0xb8cc, 0xb8cd, 0xb8e8, 0xb8e9, 0xb904, 0xb905, 0xb920, 0xb921, 0xb93c, 0xb93d, 0xb958, 0xb959, 0xb974,
        0xb975, 0xb990, 0xb991, 0xb9ac, 0xb9ad, 0xb9c8, 0xb9c9, 0xb9e4, 0xb9e5, 0xba00, 0xba01, 0xba1c, 0xba1d, 0xba38,
        0xba39, 0xba54, 0xba55, 0xba70, 0xba71, 0xba8c, 0xba8d, 0xbaa8, 0xbaa9, 0xbac4, 0xbac5, 0xbae0, 0xbae1, 0xbafc,
        0xbafd, 0xbb18, 0xbb19, 0xbb34, 0xbb35, 0xbb50, 0xbb51, 0xbb6c, 0xbb6d, 0xbb88, 0xbb89, 0xbba4, 0xbba5, 0xbbc0,
        0xbbc1, 0xbbdc, 0xbbdd, 0xbbf8, 0xbbf9, 0xbc14, 0xbc15, 0xbc30, 0xbc31, 0xbc4c, 0xbc4d, 0xbc68, 0xbc69, 0xbc84,
        0xbc85, 0xbca0, 0xbca1, 0xbcbc, 0xbcbd, 0xbcd8, 0xbcd9, 0xbcf4, 0xbcf5, 0xbd10, 0xbd11, 0xbd2c, 0xbd2d, 0xbd48,
        0xbd49, 0xbd64, 0xbd65, 0xbd80, 0xbd81, 0xbd9c, 0xbd9d, 0xbdb8, 0xbdb9, 0xbdd4, 0xbdd5, 0xbdf0, 0xbdf1, 0xbe0c,
        0xbe0d, 0xbe28, 0xbe29, 0xbe44, 0xbe45, 0xbe60, 0xbe61, 0xbe7c, 0xbe7d, 0xbe98, 0xbe99, 0xbeb4, 0xbeb5, 0xbed0,
        0xbed1, 0xbeec, 0xbeed, 0xbf08, 0xbf09, 0xbf24, 0xbf25, 0xbf40, 0xbf41, 0xbf5c, 0xbf5d, 0xbf78, 0xbf79, 0xbf94,
        0xbf95, 0xbfb0, 0xbfb1, 0xbfcc, 0xbfcd, 0xbfe8, 0xbfe9, 0xc004, 0xc005, 0xc020, 0xc021, 0xc03c, 0xc03d, 0xc058,
        0xc059, 0xc074, 0xc075, 0xc090, 0xc091, 0xc0ac, 0xc0ad, 0xc0c8, 0xc0c9, 0xc0e4, 0xc0e5, 0xc100, 0xc101, 0xc11c,
        0xc11d, 0xc138, 0xc139, 0xc154, 0xc155, 0xc170, 0xc171, 0xc18c, 0xc18d, 0xc1a8, 0xc1a9, 0xc1c4, 0xc1c5, 0xc1e0,
        0xc1e1, 0xc1fc, 0xc1fd, 0xc218, 0xc219, 0xc234, 0xc235, 0xc250, 0xc251, 0xc26c, 0xc26d, 0xc288, 0xc289, 0xc2a4,
        0xc2a5, 0xc2c0, 0xc2c1, 0xc2dc, 0xc2dd, 0xc2f8, 0xc2f9, 0xc314, 0xc315, 0xc330, 0xc331, 0xc34c, 0xc34d, 0xc368,
        0xc369, 0xc384, 0xc385, 0xc3a0, 0xc3a1, 0xc3bc, 0xc3bd, 0xc3d8, 0xc3d9, 0xc3f4, 0xc3f5, 0xc410, 0xc411, 0xc42c,
        0xc42d, 0xc448, 0xc449, 0xc464, 0xc465, 0xc480, 0xc481, 0xc49c, 0xc49d, 0xc4b8, 0xc4b9, 0xc4d4, 0xc4d5, 0xc4f0,
        0xc4f1, 0xc50c, 0xc50d, 0xc528, 0xc529, 0xc544, 0xc545, 0xc560, 0xc561, 0xc57c, 0xc57d, 0xc598, 0xc599, 0xc5b4,
        0xc5b5, 0xc5d0, 0xc5d1, 0xc5ec, 0xc5ed, 0xc608, 0xc609, 0xc624, 0xc625, 0xc640, 0xc641, 0xc65c, 0xc65d, 0xc678,
        0xc679, 0xc694, 0xc695, 0xc6b0, 0xc6b1, 0xc6cc, 0xc6cd, 0xc6e8, 0xc6e9, 0xc704, 0xc705, 0xc720, 0xc721, 0xc73c,
        0xc73d, 0xc758, 0xc759, 0xc774, 0xc775, 0xc790, 0xc791, 0xc7ac, 0xc7ad, 0xc7c8, 0xc7c9, 0xc7e4, 0xc7e5, 0xc800,
        0xc801, 0xc81c, 0xc81d, 0xc838, 0xc839, 0xc854, 0xc855, 0xc870, 0xc871, 0xc88c, 0xc88d, 0xc8a8, 0xc8a9, 0xc8c4,
        0xc8c5, 0xc8e0, 0xc8e1, 0xc8fc, 0xc8fd, 0xc918, 0xc919, 0xc934, 0xc935, 0xc950, 0xc951, 0xc96c, 0xc96d, 0xc988,
        0xc989, 0xc9a4, 0xc9a5, 0xc9c0, 0xc9c1, 0xc9dc, 0xc9dd, 0xc9f8, 0xc9f9, 0xca14, 0xca15, 0xca30, 0xca31, 0xca4c,
        0xca4d, 0xca68, 0xca69, 0xca84, 0xca85, 0xcaa0, 0xcaa1, 0xcabc, 0xcabd, 0xcad8, 0xcad9, 0xcaf4, 0xcaf5, 0xcb10,
        0xcb11, 0xcb2c, 0xcb2d, 0xcb48, 0xcb49, 0xcb64, 0xcb65, 0xcb80, 0xcb81, 0xcb9c, 0xcb9d, 0xcbb8, 0xcbb9, 0xcbd4,
        0xcbd5, 0xcbf0, 0xcbf1, 0xcc0c, 0xcc0d, 0xcc28, 0xcc29, 0xcc44, 0xcc45, 0xcc60, 0xcc61, 0xcc7c, 0xcc7d, 0xcc98,
        0xcc99, 0xccb4, 0xccb5, 0xccd0, 0xccd1, 0xccec, 0xcced, 0xcd08, 0xcd09, 0xcd24, 0xcd25, 0xcd40, 0xcd41, 0xcd5c,
        0xcd5d, 0xcd78, 0xcd79, 0xcd94, 0xcd95, 0xcdb0, 0xcdb1, 0xcdcc, 0xcdcd, 0xcde8, 0xcde9, 0xce04, 0xce05, 0xce20,
        0xce21, 0xce3c, 0xce3d, 0xce58, 0xce59, 0xce74, 0xce75, 0xce90, 0xce91, 0xceac, 0xcead, 0xcec8, 0xcec9, 0xcee4,
        0xcee5, 0xcf00, 0xcf01, 0xcf1c, 0xcf1d, 0xcf38, 0xcf39, 0xcf54, 0xcf55, 0xcf70, 0xcf71, 0xcf8c, 0xcf8d, 0xcfa8,
        0xcfa9, 0xcfc4, 0xcfc5, 0xcfe0, 0xcfe1, 0xcffc, 0xcffd, 0xd018, 0xd019, 0xd034, 0xd035, 0xd050, 0xd051, 0xd06c,
        0xd06d, 0xd088, 0xd089, 0xd0a4, 0xd0a5, 0xd0c0, 0xd0c1, 0xd0dc, 0xd0dd, 0xd0f8, 0xd0f9, 0xd114, 0xd115, 0xd130,
        0xd131, 0xd14c, 0xd14d, 0xd168, 0xd169, 0xd184, 0xd185, 0xd1a0, 0xd1a1, 0xd1bc, 0xd1bd, 0xd1d8, 0xd1d9, 0xd1f4,
        0xd1f5, 0xd210, 0xd211, 0xd22c, 0xd22d, 0xd248, 0xd249, 0xd264, 0xd265, 0xd280, 0xd281, 0xd29c, 0xd29d, 0xd2b8,
        0xd2b9, 0xd2d4, 0xd2d5, 0xd2f0, 0xd2f1, 0xd30c, 0xd30d, 0xd328, 0xd329, 0xd344, 0xd345, 0xd360, 0xd361, 0xd37c,
        0xd37d, 0xd398, 0xd399, 0xd3b4, 0xd3b5, 0xd3d0, 0xd3d1, 0xd3ec, 0xd3ed, 0xd408, 0xd409, 0xd424, 0xd425, 0xd440,
        0xd441, 0xd45c, 0xd45d, 0xd478, 0xd479, 0xd494, 0xd495, 0xd4b0, 0xd4b1, 0xd4cc, 0xd4cd, 0xd4e8, 0xd4e9, 0xd504,
        0xd505, 0xd520, 0xd521, 0xd53c, 0xd53d, 0xd558, 0xd559, 0xd574, 0xd575, 0xd590, 0xd591, 0xd5ac, 0xd5ad, 0xd5c8,
        0xd5c9, 0xd5e4, 0xd5e5, 0xd600, 0xd601, 0xd61c, 0xd61d, 0xd638, 0xd639, 0xd654, 0xd655, 0xd670, 0xd671, 0xd68c,
        0xd68d, 0xd6a8, 0xd6a9, 0xd6c4, 0xd6c5, 0xd6e0, 0xd6e1, 0xd6fc, 0xd6fd, 0xd718, 0xd719, 0xd734, 0xd735, 0xd750,
        0xd751, 0xd76c, 0xd76d, 0xd788, 0xd789, 0xd7b0, 0xd7cb, 0xfb1e, 0xfe00, 0xfe20, 0xfeff, 0xff9e, 0xfff0, 0x101fd,
        0x102e0, 0x10376, 0x10a01, 0x10a05, 0x10a0c, 0x10a38, 0x10a3f, 0x10ae5, 0x10d24, 0x10eab, 0x10efd, 0x10f46,
        0x10f82, 0x11000, 0x11001, 0x11002, 0x11038, 0x11070, 0x11073, 0x1107f, 0x11082, 0x110b0, 0x110b3, 0x110b7,
        0x110b9, 0x110bd, 0x110c2, 0x110cd, 0x11100, 0x11127, 0x1112c, 0x1112d, 0x11145, 0x11173, 0x11180, 0x11182,
        0x111b3, 0x111b6, 0x111bf, 0x111c2, 0x111c9, 0x111ce, 0x111cf, 0x1122c, 0x1122f, 0x11232, 0x11234, 0x11235,
        0x11236, 0x1123e, 0x11241, 0x112df, 0x112e0, 0x112e3, 0x11300, 0x11302, 0x1133b, 0x1133e, 0x1133f, 0x11340,
        0x11341, 0x11347, 0x1134b, 0x11357, 0x11362, 0x11366, 0x11370, 0x11435, 0x11438, 0x11440, 0x11442, 0x11445,
        0x11446, 0x1145e, 0x114b0, 0x114b1, 0x114b3, 0x114b9, 0x114ba, 0x114bb, 0x114bd, 0x114be, 0x114bf, 0x114c1,
        0x114c2, 0x115af, 0x115b0, 0x115b2, 0x115b8, 0x115bc, 0x115be, 0x115bf, 0x115dc, 0x11630, 0x11633, 0x1163b,
        0x1163d, 0x1163e, 0x1163f, 0x116ab, 0x116ac, 0x116ad, 0x116ae, 0x116b0, 0x116b6, 0x116b7, 0x1171d, 0x11722,
        0x11726, 0x11727, 0x1182c, 0x1182f, 0x11838, 0x11839, 0x11930, 0x11931, 0x11937, 0x1193b, 0x1193d, 0x1193e,
        0x1193f, 0x11940, 0x11941, 0x11942, 0x11943, 0x119d1, 0x119d4, 0x119da, 0x119dc, 0x119e0, 0x119e4, 0x11a01,
        0x11a33, 0x11a39, 0x11a3a, 0x11a3b, 0x11a47, 0x11a51, 0x11a57, 0x11a59, 0x11a84, 0x11a8a, 0x11a97, 0x11a98,
        0x11c2f, 0x11c30, 0x11c38, 0x11c3e, 0x11c3f, 0x11c92, 0x11ca9, 0x11caa, 0x11cb1, 0x11cb2, 0x11cb4, 0x11cb5,
        0x11d31, 0x11d3a, 0x11d3c, 0x11d3f, 0x11d46, 0x11d47, 0x11d8a, 0x11d90, 0x11d93, 0x11d95, 0x11d96, 0x11d97,
        0x11ef3, 0x11ef5, 0x11f00, 0x11f02, 0x11f03, 0x11f34, 0x11f36, 0x11f3e, 0x11f40, 0x11f41, 0x11f42, 0x13430,
        0x13440, 0x13447, 0x16af0, 0x16b30, 0x16f4f, 0x16f51, 0x16f8f, 0x16fe4, 0x16ff0, 0x1bc9d, 0x1bca0, 0x1cf00,
        0x1cf30, 0x1d165, 0x1d166, 0x1d167, 0x1d16d, 0x1d16e, 0x1d173, 0x1d17b, 0x1d185, 0x1d1aa, 0x1d242, 0x1da00,
        0x1da3b, 0x1da75, 0x1da84, 0x1da9b, 0x1daa1, 0x1e000, 0x1e008, 0x1e01b, 0x1e023, 0x1e026, 0x1e08f, 0x1e130,
        0x1e2ae, 0x1e2ec, 0x1e4ec, 0x1e8d0, 0x1e944, 0x1f1e6, 0x1f3fb, 0xe0000, 0xe0020, 0xe0080, 0xe0100, 0xe01f0},
    {0x100a, 0x4001, 0x1002, 0x1, 0x1012, 0x1021, 0x1001, 0x2070, 0x2007, 0x202d, 0x2001, 0x2002, 0x2002, 0x2001,
        0x7006, 0x200b, 0x1001, 0x2015, 0x2001, 0x2007, 0x7001, 0x2006, 0x2002, 0x2004, 0x7001, 0x2001, 0x201b, 0x200b,
        0x2009, 0x2001, 0x2004, 0x2009, 0x2003, 0x2005, 0x2003, 0x7002, 0x2008, 0x2018, 0x7001, 0x2020, 0x9001, 0x2001,
        0x9001, 0x2001, 0x9003, 0x2008, 0x9004, 0x2001, 0x9002, 0x2007, 0x2002, 0x2001, 0x9002, 0x2001, 0x2001, 0x9002,
        0x2004, 0x9002, 0x9002, 0x2001, 0x2001, 0x2002, 0x2001, 0x2002, 0x9001, 0x2001, 0x9003, 0x2002, 0x2002, 0x2003,
        0x2001, 0x2002, 0x2001, 0x2002, 0x9001, 0x2001, 0x9003, 0x2005, 0x2002, 0x9001, 0x9002, 0x2001, 0x2002, 0x2006,
        0x2001, 0x9002, 0x2001, 0x2002, 0x9001, 0x2004, 0x9002, 0x9002, 0x2001, 0x2003, 0x2002, 0x2001, 0x2001, 0x9001,
        0x2001, 0x9002, 0x9003, 0x9003, 0x2001, 0x2001, 0x2001, 0x9003, 0x2001, 0x2001, 0x2003, 0x9004, 0x2003, 0x2004,
        0x2002, 0x2002, 0x2001, 0x9002, 0x2001, 0x9001, 0x2001, 0x9002, 0x2001, 0x9002, 0x2001, 0x9002, 0x9002, 0x2002,
        0x2002, 0x2002, 0x9001, 0x2002, 0x9002, 0x2002, 0x2001, 0x9002, 0x2004, 0x9003, 0x9003, 0x2001, 0x7001, 0x2001,
        0x2002, 0x2001, 0x9002, 0x2001, 0x2001, 0x9002, 0x2003, 0x2001, 0x9007, 0x2001, 0x9002, 0x2001, 0x9001, 0x2007,
        0x2008, 0x2001, 0x9001, 0x2009, 0x2007, 0x2002, 0x2001, 0x2001, 0x2001, 0x9002, 0x200e, 0x9001, 0x2005, 0x2002,
        0x200b, 0x2024, 0x2001, 0x2004, 0x9001, 0x2006, 0x2002, 0x9002, 0x2002, 0x9002, 0x2002, 0x2003, 0x2004, 0x2001,
        0x9001, 0x2002, 0x2001, 0x2001, 0x3060, 0xb048, 0xa058, 0x2003, 0x2003, 0x9001, 0x2002, 0x9001, 0x2002, 0x2002,
        0x2002, 0x9001, 0x2007, 0x9008, 0x2001, 0x9002, 0x200b, 0x2001, 0x2003, 0x1001, 0x2001, 0x2002, 0x2001, 0x2003,
        0x9004, 0x2002, 0x9003, 0x9002, 0x2001, 0x9006, 0x2003, 0x2002, 0x9002, 0x2001, 0x9001, 0x2001, 0x9001, 0x2007,
        0x2001, 0x2001, 0x2008, 0x9006, 0x200a, 0x2001, 0x201f, 0x2004, 0x9001, 0x2007, 0x9001, 0x2001, 0x9005, 0x2001,
        0x9002, 0x2009, 0x2002, 0x9001, 0x9001, 0x2004, 0x9002, 0x2002, 0x9001, 0x2003, 0x2001, 0x9001, 0x2002, 0x9003,
        0x2001, 0x9001, 0x2003, 0x9002, 0x9008, 0x2008, 0x9002, 0x2002, 0x2003, 0x200d, 0x9001, 0x2007, 0x2001, 0x2001,
        0x9001, 0x2002, 0x2040, 0x1001, 0x2001, 0xc001, 0x1002, 0x1007, 0x1010, 0x2021, 0x2003, 0x2001, 0x2020, 0x2006,
        0x2002, 0x2004, 0x200a, 0x2002, 0x2002, 0x2001, 0x2001, 0x2001, 0x9002, 0x2002, 0x9001, 0x2001, 0x9002, 0x9010,
        0x2002, 0x2012, 0x2001, 0x2008, 0x200b, 0x9002, 0x301d, 0x2003, 0x9001, 0x2001, 0x9002, 0x2004, 0x9002, 0x2002,
        0x9003, 0x2001, 0x2006, 0x9002, 0x2002, 0x9002, 0x2002, 0x2001, 0x2001, 0x9001, 0x2001, 0x2001, 0x2003, 0x2002,
        0x2002, 0x2001, 0x9001, 0x2002, 0x9002, 0x9001, 0x2001, 0x9002, 0x2001, 0x9002, 0x2001, 0x9002, 0x9001, 0x2001,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b, 0x5001, 0x601b,
        0xb017, 0xa031, 0x2001, 0x2010, 0x2010, 0x1001, 0x2002, 0x100c, 0x2001, 0x2001, 0x2005, 0x2003, 0x2002, 0x2004,
        0x2003, 0x2001, 0x2002, 0x2004, 0x2002, 0x2003, 0x200b, 0x2004, 0x9001, 0x2001, 0x9001, 0x200f, 0x2001, 0x2002,
        0x2003, 0x9001, 0x9003, 0x2004, 0x9002, 0x2002, 0x7001, 0x2001, 0x7001, 0x2003, 0x2005, 0x9001, 0x2008, 0x9002,
        0x2001, 0x2002, 0x9001, 0x9003, 0x2009, 0x9002, 0x7002, 0x2004, 0x9001, 0x2001, 0x9003, 0x2003, 0x9002, 0x2001,
        0x9001, 0x2002, 0x2001, 0x2001, 0x2001, 0x9003, 0x2008, 0x2002, 0x9002, 0x2002, 0x2001, 0x9001, 0x2001, 0x9004,
        0x9002, 0x9003, 0x2001, 0x9002, 0x2007, 0x2005, 0x9003, 0x2008, 0x9002, 0x2003, 0x9001, 0x2001, 0x2001, 0x2001,
        0x9002, 0x2006, 0x9001, 0x2001, 0x9002, 0x2001, 0x9001, 0x2002, 0x9001, 0x2002, 0x2001, 0x9002, 0x2004, 0x9004,
        0x2002, 0x9001, 0x2002, 0x2002, 0x9003, 0x2008, 0x9002, 0x2001, 0x9001, 0x2002, 0x2001, 0x9001, 0x2001, 0x9002,
        0x2006, 0x9001, 0x2001, 0x2003, 0x2004, 0x9001, 0x2005, 0x9003, 0x2009, 0x9001, 0x2002, 0x2001, 0x9005, 0x9002,
        0x2002, 0x9001, 0x2001, 0x7001, 0x9001, 0x7001, 0x9001, 0x2001, 0x9003, 0x2004, 0x2002, 0x9004, 0x2001, 0x9001,
        0x200a, 0x2006, 0x9001, 0x7001, 0x2004, 0x2001, 0x2006, 0x9002, 0x2003, 0x7006, 0x200d, 0x9001, 0x2002, 0x9001,
        0x2007, 0x2006, 0x9001, 0x2001, 0x2016, 0x9001, 0x2007, 0x9001, 0x2002, 0x9001, 0x2002, 0x2006, 0x2001, 0x2002,
        0x2007, 0x7001, 0x2001, 0x9005, 0x2002, 0x9002, 0x2001, 0x9001, 0x2001, 0x2002, 0x9002, 0x2002, 0x7001, 0x9001,
        0x9002, 0x2005, 0x9002, 0x2001, 0x9001, 0x2001, 0x1010, 0x2001, 0x200f, 0x2005, 0x2007, 0x2001, 0x9037, 0x2004,
        0x2001, 0x9002, 0x2002, 0x1004, 0x202e, 0x2017, 0x2001, 0x9001, 0x2003, 0x9001, 0x2005, 0x1008, 0x2008, 0x2007,
        0x2004, 0x2003, 0x2037, 0x2032, 0x2001, 0x2001, 0x2005, 0x200f, 0x2007, 0x2011, 0x2007, 0x2002, 0x2005, 0x2001,
        0x2007, 0x2001, 0x2004, 0x2004, 0x2007, 0x2007, 0x801a, 0x2005, 0x1020, 0x2060, 0x1080, 0x20f0, 0x1e10}};

// emoji-data.txt
// Date: 2022-08-02, 00:26:10 GMT
enum class _Extended_Pictographic_property_values : uint8_t { _Extended_Pictographic_value, _No_value = 255 };

// emoji-data.txt
// Date: 2022-08-02, 00:26:10 GMT
inline constexpr _Unicode_property_data<_Extended_Pictographic_property_values, 78, true>
    _Extended_Pictographic_property_data{
        {0xa9, 0xae, 0x203c, 0x2049, 0x2122, 0x2139, 0x2194, 0x21a9, 0x231a, 0x2328, 0x2388, 0x23cf, 0x23e9, 0x23f8,
            0x24c2, 0x25aa, 0x25b6, 0x25c0, 0x25fb, 0x2600, 0x2607, 0x2614, 0x2690, 0x2708, 0x2714, 0x2716, 0x271d,
            0x2721, 0x2728, 0x2733, 0x2744, 0x2747, 0x274c, 0x274e, 0x2753, 0x2757, 0x2763, 0x2795, 0x27a1, 0x27b0,
            0x27bf, 0x2934, 0x2b05, 0x2b1b, 0x2b50, 0x2b55, 0x3030, 0x303d, 0x3297, 0x3299, 0x1f000, 0x1f10d, 0x1f12f,
            0x1f16c, 0x1f17e, 0x1f18e, 0x1f191, 0x1f1ad, 0x1f201, 0x1f21a, 0x1f22f, 0x1f232, 0x1f23c, 0x1f249, 0x1f400,
            0x1f546, 0x1f680, 0x1f774, 0x1f7d5, 0x1f80c, 0x1f848, 0x1f85a, 0x1f888, 0x1f8ae, 0x1f90c, 0x1f93c, 0x1f947,
            0x1fc00},
        {0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x6, 0x2, 0x2, 0x1, 0x1, 0x1, 0xb, 0x3, 0x1, 0x2, 0x1, 0x1, 0x4, 0x6, 0xc, 0x72,
            0x76, 0xb, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 0x5, 0x3, 0x1, 0x1, 0x1, 0x2, 0x3,
            0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x100, 0x3, 0x1, 0x6, 0x2, 0x1, 0xa, 0x39, 0xf, 0x1, 0x1, 0x9, 0x4,
            0x1b2, 0x13e, 0x10a, 0x80, 0xc, 0x2b, 0x4, 0x8, 0x6, 0x8, 0x52, 0x2f, 0xa, 0x1b9, 0x3fe}};

// DerivedGeneralCategory-15.0.0.txt
// Date: 2022-04-26, 23:14:35 GMT
enum class __printable_property_values : uint8_t { _Yes_value, _No_value = 255 };

// DerivedGeneralCategory-15.0.0.txt
// Date: 2022-04-26, 23:14:35 GMT
inline constexpr _Unicode_property_data<__printable_property_values, 711, true> __printable_property_data{
    {0x20, 0xa1, 0xae, 0x37a, 0x384, 0x38c, 0x38e, 0x3a3, 0x531, 0x559, 0x58d, 0x591, 0x5d0, 0x5ef, 0x606, 0x61d, 0x6de,
        0x710, 0x74d, 0x7c0, 0x7fd, 0x830, 0x840, 0x85e, 0x860, 0x870, 0x898, 0x8e3, 0x985, 0x98f, 0x993, 0x9aa, 0x9b2,
        0x9b6, 0x9bc, 0x9c7, 0x9cb, 0x9d7, 0x9dc, 0x9df, 0x9e6, 0xa01, 0xa05, 0xa0f, 0xa13, 0xa2a, 0xa32, 0xa35, 0xa38,
        0xa3c, 0xa3e, 0xa47, 0xa4b, 0xa51, 0xa59, 0xa5e, 0xa66, 0xa81, 0xa85, 0xa8f, 0xa93, 0xaaa, 0xab2, 0xab5, 0xabc,
        0xac7, 0xacb, 0xad0, 0xae0, 0xae6, 0xaf9, 0xb01, 0xb05, 0xb0f, 0xb13, 0xb2a, 0xb32, 0xb35, 0xb3c, 0xb47, 0xb4b,
        0xb55, 0xb5c, 0xb5f, 0xb66, 0xb82, 0xb85, 0xb8e, 0xb92, 0xb99, 0xb9c, 0xb9e, 0xba3, 0xba8, 0xbae, 0xbbe, 0xbc6,
        0xbca, 0xbd0, 0xbd7, 0xbe6, 0xc00, 0xc0e, 0xc12, 0xc2a, 0xc3c, 0xc46, 0xc4a, 0xc55, 0xc58, 0xc5d, 0xc60, 0xc66,
        0xc77, 0xc8e, 0xc92, 0xcaa, 0xcb5, 0xcbc, 0xcc6, 0xcca, 0xcd5, 0xcdd, 0xce0, 0xce6, 0xcf1, 0xd00, 0xd0e, 0xd12,
        0xd46, 0xd4a, 0xd54, 0xd66, 0xd81, 0xd85, 0xd9a, 0xdb3, 0xdbd, 0xdc0, 0xdca, 0xdcf, 0xdd6, 0xdd8, 0xde6, 0xdf2,
        0xe01, 0xe3f, 0xe81, 0xe84, 0xe86, 0xe8c, 0xea5, 0xea7, 0xec0, 0xec6, 0xec8, 0xed0, 0xedc, 0xf00, 0xf49, 0xf71,
        0xf99, 0xfbe, 0xfce, 0x1000, 0x10c7, 0x10cd, 0x10d0, 0x124a, 0x1250, 0x1258, 0x125a, 0x1260, 0x128a, 0x1290,
        0x12b2, 0x12b8, 0x12c0, 0x12c2, 0x12c8, 0x12d8, 0x1312, 0x1318, 0x135d, 0x1380, 0x13a0, 0x13f8, 0x1400, 0x1681,
        0x16a0, 0x1700, 0x171f, 0x1740, 0x1760, 0x176e, 0x1772, 0x1780, 0x17e0, 0x17f0, 0x1800, 0x180f, 0x1820, 0x1880,
        0x18b0, 0x1900, 0x1920, 0x1930, 0x1940, 0x1944, 0x1970, 0x1980, 0x19b0, 0x19d0, 0x19de, 0x1a1e, 0x1a60, 0x1a7f,
        0x1a90, 0x1aa0, 0x1ab0, 0x1b00, 0x1b50, 0x1b80, 0x1bfc, 0x1c3b, 0x1c4d, 0x1c90, 0x1cbd, 0x1cd0, 0x1d00, 0x1f18,
        0x1f20, 0x1f48, 0x1f50, 0x1f59, 0x1f5b, 0x1f5d, 0x1f5f, 0x1f80, 0x1fb6, 0x1fc6, 0x1fd6, 0x1fdd, 0x1ff2, 0x1ff6,
        0x2010, 0x2030, 0x2070, 0x2074, 0x2090, 0x20a0, 0x20d0, 0x2100, 0x2190, 0x2440, 0x2460, 0x2b76, 0x2b97, 0x2cf9,
        0x2d27, 0x2d2d, 0x2d30, 0x2d6f, 0x2d7f, 0x2da0, 0x2da8, 0x2db0, 0x2db8, 0x2dc0, 0x2dc8, 0x2dd0, 0x2dd8, 0x2de0,
        0x2e80, 0x2e9b, 0x2f00, 0x2ff0, 0x3001, 0x3041, 0x3099, 0x3105, 0x3131, 0x3190, 0x31f0, 0x3220, 0xa490, 0xa4d0,
        0xa640, 0xa700, 0xa7d0, 0xa7d3, 0xa7d5, 0xa7f2, 0xa830, 0xa840, 0xa880, 0xa8ce, 0xa8e0, 0xa95f, 0xa980, 0xa9cf,
        0xa9de, 0xaa00, 0xaa40, 0xaa50, 0xaa5c, 0xaadb, 0xab01, 0xab09, 0xab11, 0xab20, 0xab28, 0xab30, 0xab70, 0xabf0,
        0xac00, 0xd7b0, 0xd7cb, 0xf900, 0xfa70, 0xfb00, 0xfb13, 0xfb1d, 0xfb38, 0xfb3e, 0xfb40, 0xfb43, 0xfb46, 0xfbd3,
        0xfd92, 0xfdcf, 0xfdf0, 0xfe20, 0xfe54, 0xfe68, 0xfe70, 0xfe76, 0xff01, 0xffc2, 0xffca, 0xffd2, 0xffda, 0xffe0,
        0xffe8, 0xfffc, 0x10000, 0x1000d, 0x10028, 0x1003c, 0x1003f, 0x10050, 0x10080, 0x10100, 0x10107, 0x10137,
        0x10190, 0x101a0, 0x101d0, 0x10280, 0x102a0, 0x102e0, 0x10300, 0x1032d, 0x10350, 0x10380, 0x1039f, 0x103c8,
        0x10400, 0x104a0, 0x104b0, 0x104d8, 0x10500, 0x10530, 0x1056f, 0x1057c, 0x1058c, 0x10594, 0x10597, 0x105a3,
        0x105b3, 0x105bb, 0x10600, 0x10740, 0x10760, 0x10780, 0x10787, 0x107b2, 0x10800, 0x10808, 0x1080a, 0x10837,
        0x1083c, 0x1083f, 0x10857, 0x108a7, 0x108e0, 0x108f4, 0x108fb, 0x1091f, 0x1093f, 0x10980, 0x109bc, 0x109d2,
        0x10a05, 0x10a0c, 0x10a15, 0x10a19, 0x10a38, 0x10a3f, 0x10a50, 0x10a60, 0x10ac0, 0x10aeb, 0x10b00, 0x10b39,
        0x10b58, 0x10b78, 0x10b99, 0x10ba9, 0x10c00, 0x10c80, 0x10cc0, 0x10cfa, 0x10d30, 0x10e60, 0x10e80, 0x10eab,
        0x10eb0, 0x10efd, 0x10f30, 0x10f70, 0x10fb0, 0x10fe0, 0x11000, 0x11052, 0x1107f, 0x110be, 0x110d0, 0x110f0,
        0x11100, 0x11136, 0x11150, 0x11180, 0x111e1, 0x11200, 0x11213, 0x11280, 0x11288, 0x1128a, 0x1128f, 0x1129f,
        0x112b0, 0x112f0, 0x11300, 0x11305, 0x1130f, 0x11313, 0x1132a, 0x11332, 0x11335, 0x1133b, 0x11347, 0x1134b,
        0x11350, 0x11357, 0x1135d, 0x11366, 0x11370, 0x11400, 0x1145d, 0x11480, 0x114d0, 0x11580, 0x115b8, 0x11600,
        0x11650, 0x11660, 0x11680, 0x116c0, 0x11700, 0x1171d, 0x11730, 0x11800, 0x118a0, 0x118ff, 0x11909, 0x1190c,
        0x11915, 0x11918, 0x11937, 0x1193b, 0x11950, 0x119a0, 0x119aa, 0x119da, 0x11a00, 0x11a50, 0x11ab0, 0x11b00,
        0x11c00, 0x11c0a, 0x11c38, 0x11c50, 0x11c70, 0x11c92, 0x11ca9, 0x11d00, 0x11d08, 0x11d0b, 0x11d3a, 0x11d3c,
        0x11d3f, 0x11d50, 0x11d60, 0x11d67, 0x11d6a, 0x11d90, 0x11d93, 0x11da0, 0x11ee0, 0x11f00, 0x11f12, 0x11f3e,
        0x11fb0, 0x11fc0, 0x11fff, 0x12400, 0x12470, 0x12480, 0x12f90, 0x13000, 0x13440, 0x14400, 0x16800, 0x16a40,
        0x16a60, 0x16a6e, 0x16ac0, 0x16ad0, 0x16af0, 0x16b00, 0x16b50, 0x16b5b, 0x16b63, 0x16b7d, 0x16e40, 0x16f00,
        0x16f4f, 0x16f8f, 0x16fe0, 0x16ff0, 0x17000, 0x18800, 0x18d00, 0x1aff0, 0x1aff5, 0x1affd, 0x1b000, 0x1b132,
        0x1b150, 0x1b155, 0x1b164, 0x1b170, 0x1bc00, 0x1bc70, 0x1bc80, 0x1bc90, 0x1bc9c, 0x1cf00, 0x1cf30, 0x1cf50,
        0x1d000, 0x1d100, 0x1d129, 0x1d17b, 0x1d200, 0x1d2c0, 0x1d2e0, 0x1d300, 0x1d360, 0x1d400, 0x1d456, 0x1d49e,
        0x1d4a2, 0x1d4a5, 0x1d4a9, 0x1d4ae, 0x1d4bb, 0x1d4bd, 0x1d4c5, 0x1d507, 0x1d50d, 0x1d516, 0x1d51e, 0x1d53b,
        0x1d540, 0x1d546, 0x1d54a, 0x1d552, 0x1d6a8, 0x1d7ce, 0x1da9b, 0x1daa1, 0x1df00, 0x1df25, 0x1e000, 0x1e008,
        0x1e01b, 0x1e023, 0x1e026, 0x1e030, 0x1e08f, 0x1e100, 0x1e130, 0x1e140, 0x1e14e, 0x1e290, 0x1e2c0, 0x1e2ff,
        0x1e4d0, 0x1e7e0, 0x1e7e8, 0x1e7ed, 0x1e7f0, 0x1e800, 0x1e8c7, 0x1e900, 0x1e950, 0x1e95e, 0x1ec71, 0x1ed01,
        0x1ee00, 0x1ee05, 0x1ee21, 0x1ee24, 0x1ee27, 0x1ee29, 0x1ee34, 0x1ee39, 0x1ee3b, 0x1ee42, 0x1ee47, 0x1ee49,
        0x1ee4b, 0x1ee4d, 0x1ee51, 0x1ee54, 0x1ee57, 0x1ee59, 0x1ee5b, 0x1ee5d, 0x1ee5f, 0x1ee61, 0x1ee64, 0x1ee67,
        0x1ee6c, 0x1ee74, 0x1ee79, 0x1ee7e, 0x1ee80, 0x1ee8b, 0x1eea1, 0x1eea5, 0x1eeab, 0x1eef0, 0x1f000, 0x1f030,
        0x1f0a0, 0x1f0b1, 0x1f0c1, 0x1f0d1, 0x1f100, 0x1f1e6, 0x1f210, 0x1f240, 0x1f250, 0x1f260, 0x1f300, 0x1f6dc,
        0x1f6f0, 0x1f700, 0x1f77b, 0x1f7e0, 0x1f7f0, 0x1f800, 0x1f810, 0x1f850, 0x1f860, 0x1f890, 0x1f8b0, 0x1f900,
        0x1fa60, 0x1fa70, 0x1fa80, 0x1fa90, 0x1fabf, 0x1face, 0x1fae0, 0x1faf0, 0x1fb00, 0x1fb94, 0x1fbf0, 0x20000,
        0x2a700, 0x2b740, 0x2b820, 0x2ceb0, 0x2f800, 0x30000, 0x31350, 0xe0100},
    {0x5f, 0xc, 0x2ca, 0x6, 0x7, 0x1, 0x14, 0x18d, 0x26, 0x32, 0x3, 0x37, 0x1b, 0x6, 0x16, 0xc0, 0x30, 0x3b, 0x65, 0x3b,
        0x31, 0xf, 0x1c, 0x1, 0xb, 0x1f, 0x4a, 0xa1, 0x8, 0x2, 0x16, 0x7, 0x1, 0x4, 0x9, 0x2, 0x4, 0x1, 0x2, 0x5, 0x19,
        0x3, 0x6, 0x2, 0x16, 0x7, 0x2, 0x2, 0x2, 0x1, 0x5, 0x2, 0x3, 0x1, 0x4, 0x1, 0x11, 0x3, 0x9, 0x3, 0x16, 0x7, 0x2,
        0x5, 0xa, 0x3, 0x3, 0x1, 0x4, 0xc, 0x7, 0x3, 0x8, 0x2, 0x16, 0x7, 0x2, 0x5, 0x9, 0x2, 0x3, 0x3, 0x2, 0x5, 0x12,
        0x2, 0x6, 0x3, 0x4, 0x2, 0x1, 0x2, 0x2, 0x3, 0xc, 0x5, 0x3, 0x4, 0x1, 0x1, 0x15, 0xd, 0x3, 0x17, 0x10, 0x9, 0x3,
        0x4, 0x2, 0x3, 0x1, 0x4, 0xa, 0x16, 0x3, 0x17, 0xa, 0x5, 0x9, 0x3, 0x4, 0x2, 0x2, 0x4, 0xa, 0x3, 0xd, 0x3, 0x33,
        0x3, 0x6, 0x10, 0x1a, 0x3, 0x12, 0x18, 0x9, 0x1, 0x7, 0x1, 0x6, 0x1, 0x8, 0xa, 0x3, 0x3a, 0x1d, 0x2, 0x1, 0x5,
        0x18, 0x1, 0x17, 0x5, 0x1, 0x7, 0xa, 0x4, 0x48, 0x24, 0x27, 0x24, 0xf, 0xd, 0xc6, 0x1, 0x1, 0x179, 0x4, 0x7,
        0x1, 0x4, 0x29, 0x4, 0x21, 0x4, 0x7, 0x1, 0x4, 0xf, 0x39, 0x4, 0x43, 0x20, 0x1a, 0x56, 0x6, 0x280, 0x1c, 0x59,
        0x16, 0x18, 0x14, 0xd, 0x3, 0x2, 0x5e, 0xa, 0xa, 0xe, 0xb, 0x59, 0x2b, 0x46, 0x1f, 0xc, 0xc, 0x1, 0x2a, 0x5,
        0x2c, 0x1a, 0xb, 0x3e, 0x41, 0x1d, 0xb, 0xa, 0xe, 0x1f, 0x4d, 0x2f, 0x74, 0x3c, 0xf, 0x3c, 0x2b, 0xb, 0x2b,
        0x216, 0x6, 0x26, 0x6, 0x8, 0x1, 0x1, 0x1, 0x1f, 0x35, 0xf, 0xe, 0x6, 0x13, 0x3, 0x9, 0x18, 0x2f, 0x2, 0x1b,
        0xd, 0x21, 0x21, 0x8c, 0x297, 0xb, 0x714, 0x20, 0x15d, 0x2d, 0x1, 0x1, 0x38, 0x2, 0x18, 0x7, 0x7, 0x7, 0x7, 0x7,
        0x7, 0x7, 0x7, 0x7e, 0x1a, 0x59, 0xd6, 0xc, 0x3f, 0x56, 0x67, 0x2b, 0x5e, 0x54, 0x2f, 0x726d, 0x37, 0x15c, 0xb8,
        0xcb, 0x2, 0x1, 0x5, 0x3b, 0xa, 0x38, 0x46, 0xc, 0x74, 0x1e, 0x4e, 0xb, 0x21, 0x37, 0xe, 0xa, 0x67, 0x1c, 0x6,
        0x6, 0x6, 0x7, 0x7, 0x3c, 0x7e, 0xa, 0x2ba4, 0x17, 0x31, 0x16e, 0x6a, 0x7, 0x5, 0x1a, 0x5, 0x1, 0x2, 0x2, 0x7d,
        0x1bd, 0x36, 0x1, 0x2a, 0x33, 0x13, 0x4, 0x5, 0x87, 0xbe, 0x6, 0x6, 0x6, 0x3, 0x7, 0x7, 0x2, 0xc, 0x1a, 0x13,
        0x2, 0xf, 0xe, 0x7b, 0x3, 0x2d, 0x58, 0xd, 0x1, 0x2e, 0x1d, 0x31, 0x1c, 0x24, 0x1e, 0x2b, 0x1e, 0x25, 0xe, 0x9e,
        0xa, 0x24, 0x24, 0x28, 0x34, 0xc, 0xf, 0x7, 0x2, 0xb, 0xf, 0x7, 0x2, 0x137, 0x16, 0x8, 0x6, 0x2a, 0x9, 0x6, 0x1,
        0x2c, 0x2, 0x1, 0x17, 0x48, 0x9, 0x13, 0x2, 0x21, 0x1b, 0x1, 0x38, 0x14, 0x32, 0x2, 0x8, 0x3, 0x1d, 0x3, 0xa,
        0x9, 0x40, 0x27, 0xc, 0x36, 0x1d, 0x1b, 0x1a, 0x4, 0x7, 0x49, 0x33, 0x33, 0x2e, 0xa, 0x1f, 0x2a, 0x3, 0x2, 0x2b,
        0x2a, 0x1a, 0x1c, 0x17, 0x4e, 0x24, 0x3e, 0x5, 0x19, 0xa, 0x35, 0x12, 0x27, 0x60, 0x14, 0x12, 0x2f, 0x7, 0x1,
        0x4, 0xf, 0xb, 0x3b, 0xa, 0x4, 0x8, 0x2, 0x16, 0x7, 0x2, 0x5, 0xa, 0x2, 0x3, 0x1, 0x1, 0x7, 0x7, 0x5, 0x5c, 0x5,
        0x48, 0xa, 0x36, 0x26, 0x45, 0xa, 0xd, 0x3a, 0xa, 0x1b, 0xf, 0x17, 0x3c, 0x53, 0x8, 0x1, 0x8, 0x2, 0x1e, 0x2,
        0xc, 0xa, 0x8, 0x2e, 0xb, 0x48, 0x53, 0x49, 0xa, 0x9, 0x2d, 0xe, 0x1d, 0x20, 0x16, 0xe, 0x7, 0x2, 0x2c, 0x1,
        0x2, 0x9, 0xa, 0x6, 0x2, 0x25, 0x2, 0x6, 0xa, 0x19, 0x11, 0x29, 0x1c, 0x1, 0x32, 0x39b, 0x6f, 0x5, 0xc4, 0x63,
        0x430, 0x16, 0x247, 0x239, 0x1f, 0xa, 0x51, 0xa, 0x1e, 0x6, 0x46, 0xa, 0x7, 0x15, 0x13, 0x5b, 0x4b, 0x39, 0x11,
        0x5, 0x2, 0x17f8, 0x4d6, 0x9, 0x4, 0x7, 0x2, 0x123, 0x1, 0x3, 0x1, 0x4, 0x18c, 0x6b, 0xd, 0x9, 0xa, 0x4, 0x2e,
        0x17, 0x74, 0xf6, 0x27, 0x4a, 0x70, 0x46, 0x14, 0x14, 0x57, 0x19, 0x55, 0x47, 0x2, 0x1, 0x2, 0x4, 0xc, 0x1, 0x7,
        0x41, 0x4, 0x8, 0x7, 0x1c, 0x4, 0x5, 0x1, 0x7, 0x154, 0x124, 0x2be, 0x5, 0xf, 0x1f, 0x6, 0x7, 0x11, 0x7, 0x2,
        0x5, 0x3e, 0x1, 0x2d, 0xe, 0xa, 0x2, 0x1f, 0x3a, 0x1, 0x2a, 0x7, 0x4, 0x2, 0xf, 0xc5, 0x10, 0x4c, 0xa, 0x2,
        0x44, 0x3d, 0x4, 0x1b, 0x2, 0x1, 0x1, 0xa, 0x4, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1,
        0x1, 0x2, 0x1, 0x4, 0x7, 0x4, 0x4, 0x1, 0xa, 0x11, 0x3, 0x5, 0x11, 0x2, 0x2c, 0x64, 0xf, 0xf, 0xf, 0x25, 0xae,
        0x1d, 0x2c, 0x9, 0x2, 0x6, 0x3d8, 0x11, 0xd, 0x77, 0x5f, 0xc, 0x1, 0xc, 0x38, 0xa, 0x28, 0x1e, 0x2, 0x154, 0xe,
        0xd, 0x9, 0x2e, 0x7, 0xe, 0x9, 0x9, 0x93, 0x37, 0xa, 0xa6e0, 0x103a, 0xde, 0x1682, 0x1d31, 0x21e, 0x134b,
        0x1060, 0xf0}};

// DerivedCoreProperties-15.0.0.txt
// Date: 2022-08-05, 22:17:05 GMT
enum class _Grapheme_Extend_property_values : uint8_t { _Grapheme_Extend_value, _No_value = 255 };

// DerivedCoreProperties-15.0.0.txt
// Date: 2022-08-05, 22:17:05 GMT
inline constexpr _Unicode_property_data<_Grapheme_Extend_property_values, 363, true> _Grapheme_Extend_property_data{
    {0x300, 0x483, 0x591, 0x5bf, 0x5c1, 0x5c4, 0x5c7, 0x610, 0x64b, 0x670, 0x6d6, 0x6df, 0x6e7, 0x6ea, 0x711, 0x730,
        0x7a6, 0x7eb, 0x7fd, 0x816, 0x81b, 0x825, 0x829, 0x859, 0x898, 0x8ca, 0x8e3, 0x93a, 0x93c, 0x941, 0x94d, 0x951,
        0x962, 0x981, 0x9bc, 0x9be, 0x9c1, 0x9cd, 0x9d7, 0x9e2, 0x9fe, 0xa01, 0xa3c, 0xa41, 0xa47, 0xa4b, 0xa51, 0xa70,
        0xa75, 0xa81, 0xabc, 0xac1, 0xac7, 0xacd, 0xae2, 0xafa, 0xb01, 0xb3c, 0xb3e, 0xb41, 0xb4d, 0xb55, 0xb62, 0xb82,
        0xbbe, 0xbc0, 0xbcd, 0xbd7, 0xc00, 0xc04, 0xc3c, 0xc3e, 0xc46, 0xc4a, 0xc55, 0xc62, 0xc81, 0xcbc, 0xcbf, 0xcc2,
        0xcc6, 0xccc, 0xcd5, 0xce2, 0xd00, 0xd3b, 0xd3e, 0xd41, 0xd4d, 0xd57, 0xd62, 0xd81, 0xdca, 0xdcf, 0xdd2, 0xdd6,
        0xddf, 0xe31, 0xe34, 0xe47, 0xeb1, 0xeb4, 0xec8, 0xf18, 0xf35, 0xf37, 0xf39, 0xf71, 0xf80, 0xf86, 0xf8d, 0xf99,
        0xfc6, 0x102d, 0x1032, 0x1039, 0x103d, 0x1058, 0x105e, 0x1071, 0x1082, 0x1085, 0x108d, 0x109d, 0x135d, 0x1712,
        0x1732, 0x1752, 0x1772, 0x17b4, 0x17b7, 0x17c6, 0x17c9, 0x17dd, 0x180b, 0x180f, 0x1885, 0x18a9, 0x1920, 0x1927,
        0x1932, 0x1939, 0x1a17, 0x1a1b, 0x1a56, 0x1a58, 0x1a60, 0x1a62, 0x1a65, 0x1a73, 0x1a7f, 0x1ab0, 0x1b00, 0x1b34,
        0x1b3c, 0x1b42, 0x1b6b, 0x1b80, 0x1ba2, 0x1ba8, 0x1bab, 0x1be6, 0x1be8, 0x1bed, 0x1bef, 0x1c2c, 0x1c36, 0x1cd0,
        0x1cd4, 0x1ce2, 0x1ced, 0x1cf4, 0x1cf8, 0x1dc0, 0x200c, 0x20d0, 0x2cef, 0x2d7f, 0x2de0, 0x302a, 0x3099, 0xa66f,
        0xa674, 0xa69e, 0xa6f0, 0xa802, 0xa806, 0xa80b, 0xa825, 0xa82c, 0xa8c4, 0xa8e0, 0xa8ff, 0xa926, 0xa947, 0xa980,
        0xa9b3, 0xa9b6, 0xa9bc, 0xa9e5, 0xaa29, 0xaa31, 0xaa35, 0xaa43, 0xaa4c, 0xaa7c, 0xaab0, 0xaab2, 0xaab7, 0xaabe,
        0xaac1, 0xaaec, 0xaaf6, 0xabe5, 0xabe8, 0xabed, 0xfb1e, 0xfe00, 0xfe20, 0xff9e, 0x101fd, 0x102e0, 0x10376,
        0x10a01, 0x10a05, 0x10a0c, 0x10a38, 0x10a3f, 0x10ae5, 0x10d24, 0x10eab, 0x10efd, 0x10f46, 0x10f82, 0x11001,
        0x11038, 0x11070, 0x11073, 0x1107f, 0x110b3, 0x110b9, 0x110c2, 0x11100, 0x11127, 0x1112d, 0x11173, 0x11180,
        0x111b6, 0x111c9, 0x111cf, 0x1122f, 0x11234, 0x11236, 0x1123e, 0x11241, 0x112df, 0x112e3, 0x11300, 0x1133b,
        0x1133e, 0x11340, 0x11357, 0x11366, 0x11370, 0x11438, 0x11442, 0x11446, 0x1145e, 0x114b0, 0x114b3, 0x114ba,
        0x114bd, 0x114bf, 0x114c2, 0x115af, 0x115b2, 0x115bc, 0x115bf, 0x115dc, 0x11633, 0x1163d, 0x1163f, 0x116ab,
        0x116ad, 0x116b0, 0x116b7, 0x1171d, 0x11722, 0x11727, 0x1182f, 0x11839, 0x11930, 0x1193b, 0x1193e, 0x11943,
        0x119d4, 0x119da, 0x119e0, 0x11a01, 0x11a33, 0x11a3b, 0x11a47, 0x11a51, 0x11a59, 0x11a8a, 0x11a98, 0x11c30,
        0x11c38, 0x11c3f, 0x11c92, 0x11caa, 0x11cb2, 0x11cb5, 0x11d31, 0x11d3a, 0x11d3c, 0x11d3f, 0x11d47, 0x11d90,
        0x11d95, 0x11d97, 0x11ef3, 0x11f00, 0x11f36, 0x11f40, 0x11f42, 0x13440, 0x13447, 0x16af0, 0x16b30, 0x16f4f,
        0x16f8f, 0x16fe4, 0x1bc9d, 0x1cf00, 0x1cf30, 0x1d165, 0x1d167, 0x1d16e, 0x1d17b, 0x1d185, 0x1d1aa, 0x1d242,
        0x1da00, 0x1da3b, 0x1da75, 0x1da84, 0x1da9b, 0x1daa1, 0x1e000, 0x1e008, 0x1e01b, 0x1e023, 0x1e026, 0x1e08f,
        0x1e130, 0x1e2ae, 0x1e2ec, 0x1e4ec, 0x1e8d0, 0x1e944, 0xe0020, 0xe0100},
    {0x70, 0x7, 0x2d, 0x1, 0x2, 0x2, 0x1, 0xb, 0x15, 0x1, 0x7, 0x6, 0x2, 0x4, 0x1, 0x1b, 0xb, 0x9, 0x1, 0x4, 0x9, 0x3,
        0x5, 0x3, 0x8, 0x18, 0x20, 0x1, 0x1, 0x8, 0x1, 0x7, 0x2, 0x1, 0x1, 0x1, 0x4, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2,
        0x2, 0x3, 0x1, 0x2, 0x1, 0x2, 0x1, 0x5, 0x2, 0x1, 0x2, 0x6, 0x1, 0x1, 0x2, 0x4, 0x1, 0x3, 0x2, 0x1, 0x1, 0x1,
        0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x4,
        0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x7, 0x8, 0x1, 0x9, 0x7, 0x2, 0x1, 0x1, 0x1, 0xe, 0x5, 0x2,
        0xb, 0x24, 0x1, 0x4, 0x6, 0x2, 0x2, 0x2, 0x3, 0x4, 0x1, 0x2, 0x1, 0x1, 0x3, 0x3, 0x2, 0x2, 0x2, 0x2, 0x7, 0x1,
        0xb, 0x1, 0x3, 0x1, 0x2, 0x1, 0x3, 0x2, 0x1, 0x3, 0x2, 0x1, 0x1, 0x7, 0x1, 0x1, 0x8, 0xa, 0x1, 0x1f, 0x4, 0x7,
        0x1, 0x1, 0x9, 0x2, 0x4, 0x2, 0x3, 0x1, 0x2, 0x1, 0x3, 0x8, 0x2, 0x3, 0xd, 0x7, 0x1, 0x1, 0x2, 0x40, 0x1, 0x21,
        0x3, 0x1, 0x20, 0x6, 0x2, 0x4, 0xa, 0x2, 0x2, 0x1, 0x1, 0x1, 0x2, 0x1, 0x2, 0x12, 0x1, 0x8, 0xb, 0x3, 0x1, 0x4,
        0x2, 0x1, 0x6, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x3, 0x2, 0x2, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x10, 0x10, 0x2,
        0x1, 0x1, 0x5, 0x3, 0x2, 0x4, 0x3, 0x1, 0x2, 0x4, 0x2, 0x3, 0xb, 0x4, 0x1, 0xf, 0x1, 0x2, 0x3, 0x4, 0x2, 0x1,
        0x3, 0x5, 0x8, 0x1, 0x2, 0x9, 0x4, 0x1, 0x3, 0x1, 0x2, 0x1, 0x1, 0x1, 0x8, 0x2, 0x2, 0x1, 0x1, 0x1, 0x7, 0x5,
        0x8, 0x3, 0x1, 0x1, 0x1, 0x6, 0x1, 0x1, 0x2, 0x2, 0x1, 0x4, 0x2, 0x2, 0x2, 0x8, 0x1, 0x2, 0x1, 0x1, 0x6, 0x1,
        0x3, 0x4, 0x5, 0x9, 0x2, 0x1, 0x2, 0x1, 0x1, 0x4, 0x2, 0x1, 0xa, 0x6, 0x4, 0x1, 0x6, 0x3, 0xd, 0x2, 0x7, 0x6,
        0x1, 0x16, 0x7, 0x2, 0x2, 0x6, 0x1, 0x2, 0x7, 0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x5, 0x1, 0x1, 0x1, 0xf, 0x5, 0x7,
        0x1, 0x4, 0x1, 0x2, 0x2e, 0x17, 0x1, 0x3, 0x5, 0x8, 0x7, 0x4, 0x3, 0x37, 0x32, 0x1, 0x1, 0x5, 0xf, 0x7, 0x11,
        0x7, 0x2, 0x5, 0x1, 0x7, 0x1, 0x4, 0x4, 0x7, 0x7, 0x60, 0xf0}};

_STD_END

#pragma pop_macro("new")
_STL_RESTORE_CLANG_WARNINGS
#pragma warning(pop)
#pragma pack(pop)

#endif // _STL_COMPILER_PREPROCESSOR
#endif // __MSVC_FORMAT_UCD_TABLES_HPP
